/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.redstoneRequester;

import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiParticle;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterEffectPacket;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterMenu;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.fabricators_of_create.porting_lib.util.NetworkHooks;
import java.util.List;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

public class RedstoneRequesterBlockEntity
extends StockCheckingBlockEntity
implements class_3908 {
    public boolean allowPartialRequests = false;
    public PackageOrderWithCrafts encodedRequest = PackageOrderWithCrafts.empty();
    public String encodedTargetAdress = "";
    public boolean lastRequestSucceeded;
    protected boolean redstonePowered;
    public AbstractComputerBehaviour computerBehaviour;

    public RedstoneRequesterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    protected void onRedstonePowerChanged() {
        boolean hasNeighborSignal = this.field_11863.method_49803(this.field_11867);
        if (this.redstonePowered == hasNeighborSignal) {
            return;
        }
        this.lastRequestSucceeded = false;
        if (hasNeighborSignal) {
            this.triggerRequest();
        }
        this.redstonePowered = hasNeighborSignal;
        this.notifyUpdate();
    }

    public void triggerRequest() {
        if (this.encodedRequest.isEmpty()) {
            return;
        }
        boolean anySucceeded = false;
        InventorySummary summaryOfOrder = new InventorySummary();
        this.encodedRequest.stacks().forEach(summaryOfOrder::add);
        InventorySummary summary = this.getAccurateSummary();
        for (BigItemStack entry : summaryOfOrder.getStacks()) {
            if (summary.getCountOf(entry.stack) >= entry.count) {
                anySucceeded = true;
                continue;
            }
            if (this.allowPartialRequests) continue;
            AllPackets.sendToNear(this.field_11863, this.field_11867, 32, new RedstoneRequesterEffectPacket(this.field_11867, false));
            return;
        }
        this.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.REDSTONE, this.encodedRequest, null, this.encodedTargetAdress);
        AllPackets.sendToNear(this.field_11863, this.field_11867, 32, new RedstoneRequesterEffectPacket(this.field_11867, anySucceeded));
        this.lastRequestSucceeded = true;
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.redstonePowered = tag.method_10577("Powered");
        this.lastRequestSucceeded = tag.method_10577("Success");
        this.allowPartialRequests = tag.method_10577("AllowPartial");
        this.encodedRequest = PackageOrderWithCrafts.read(tag.method_10562("EncodedRequest"));
        this.encodedTargetAdress = tag.method_10558("EncodedAddress");
    }

    @Override
    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        tag.method_10556("AllowPartial", this.allowPartialRequests);
        tag.method_10582("EncodedAddress", this.encodedTargetAdress);
        tag.method_10566("EncodedRequest", (class_2520)this.encodedRequest.write());
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("Powered", this.redstonePowered);
        tag.method_10556("Success", this.lastRequestSucceeded);
        tag.method_10556("AllowPartial", this.allowPartialRequests);
        tag.method_10582("EncodedAddress", this.encodedTargetAdress);
        tag.method_10566("EncodedRequest", (class_2520)this.encodedRequest.write());
    }

    public class_1269 use(class_1657 player) {
        if (player == null || player.method_18276()) {
            return class_1269.field_5811;
        }
        if (player instanceof FakePlayer) {
            return class_1269.field_5811;
        }
        if (this.field_11863.field_9236) {
            return class_1269.field_5812;
        }
        if (!this.behaviour.mayInteractMessage(player)) {
            return class_1269.field_5812;
        }
        NetworkHooks.openScreen((class_3222)((class_3222)player), (class_3908)this, (class_2338)this.field_11867);
        return class_1269.field_5812;
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
        return RedstoneRequesterMenu.create(pContainerId, pPlayerInventory, this);
    }

    public void playEffect(boolean success) {
        class_243 vec3 = class_243.method_24953((class_2382)this.field_11867);
        if (success) {
            AllSoundEvents.CONFIRM.playAt(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.5f, false);
            AllSoundEvents.STOCK_LINK.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f, false);
            this.field_11863.method_8406((class_2394)new WiFiParticle.Data(), vec3.field_1352, vec3.field_1351, vec3.field_1350, 1.0, 1.0, 1.0);
        } else {
            AllSoundEvents.DENY.playAt(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f, false);
            this.field_11863.method_8406((class_2394)class_2398.field_11208, vec3.field_1352, vec3.field_1351 + 1.0, vec3.field_1350, 0.0, 0.0, 0.0);
        }
    }
}

