/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class DisplayLinkBlockEntity
extends LinkWithBulbBlockEntity
implements TransformableBlockEntity {
    protected class_2338 targetOffset = class_2338.field_10980;
    public DisplaySource activeSource;
    private class_2487 sourceConfig = new class_2487();
    public DisplayTarget activeTarget;
    public int targetLine = 0;
    public int refreshTicks;
    public AbstractComputerBehaviour computerBehaviour;
    public FactoryPanelSupportBehaviour factoryPanelSupport;
    private static final class_243 bulbOffset = VecHelper.voxelSpace((double)11.0, (double)7.0, (double)5.0);
    private static final class_243 bulbOffsetVertical = VecHelper.voxelSpace((double)5.0, (double)7.0, (double)11.0);

    public DisplayLinkBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        this.factoryPanelSupport = new FactoryPanelSupportBehaviour(this, () -> false, () -> false, () -> this.updateGatheredData());
        behaviours.add(this.factoryPanelSupport);
        this.registerAwardables(behaviours, AllAdvancements.DISPLAY_LINK, AllAdvancements.DISPLAY_BOARD);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isVirtual()) {
            return;
        }
        if (this.activeSource == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        ++this.refreshTicks;
        if (this.refreshTicks < this.activeSource.getPassiveRefreshTicks() || !this.activeSource.shouldPassiveReset()) {
            return;
        }
        this.tickSource();
    }

    public void tickSource() {
        this.refreshTicks = 0;
        if (this.method_11010().method_28500((class_2769)DisplayLinkBlock.POWERED).orElse(true).booleanValue()) {
            return;
        }
        if (!this.field_11863.field_9236) {
            this.updateGatheredData();
        }
    }

    public void onNoLongerPowered() {
        if (this.activeSource == null) {
            return;
        }
        this.refreshTicks = 0;
        this.activeSource.onSignalReset(new DisplayLinkContext(this.field_11863, this));
        this.updateGatheredData();
    }

    public void updateGatheredData() {
        class_2338 sourcePosition = this.getSourcePosition();
        class_2338 targetPosition = this.getTargetPosition();
        if (!this.field_11863.method_8477(targetPosition) || !this.field_11863.method_8477(sourcePosition)) {
            return;
        }
        DisplayTarget target = DisplayTarget.get((class_1936)this.field_11863, targetPosition);
        List<DisplaySource> sources = DisplaySource.getAll((class_1936)this.field_11863, sourcePosition);
        boolean notify = false;
        if (this.activeTarget != target) {
            this.activeTarget = target;
            notify = true;
        }
        if (this.activeSource != null && !sources.contains(this.activeSource)) {
            this.activeSource = null;
            this.sourceConfig = new class_2487();
            notify = true;
        }
        if (notify) {
            this.notifyUpdate();
        }
        if (this.activeSource == null || this.activeTarget == null) {
            return;
        }
        DisplayLinkContext context = new DisplayLinkContext(this.field_11863, this);
        this.activeSource.transferData(context, this.activeTarget, this.targetLine);
        this.sendPulseNextSync();
        this.sendData();
        this.award(AllAdvancements.DISPLAY_LINK);
    }

    @Override
    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        this.writeGatheredData(tag);
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        class_2960 id;
        super.write(tag, clientPacket);
        this.writeGatheredData(tag);
        if (clientPacket && this.activeTarget != null && (id = CreateBuiltInRegistries.DISPLAY_TARGET.method_10221((Object)this.activeTarget)) != null) {
            tag.method_10582("TargetType", id.toString());
        }
    }

    private void writeGatheredData(class_2487 tag) {
        tag.method_10566("TargetOffset", (class_2520)class_2512.method_10692((class_2338)this.targetOffset));
        tag.method_10569("TargetLine", this.targetLine);
        if (this.activeSource != null) {
            class_2487 data = this.sourceConfig.method_10553();
            class_2960 id = CreateBuiltInRegistries.DISPLAY_SOURCE.method_10221((Object)this.activeSource);
            if (id != null) {
                data.method_10582("Id", id.toString());
            }
            tag.method_10566("Source", (class_2520)data);
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.targetOffset = class_2512.method_10691((class_2487)tag.method_10562("TargetOffset"));
        this.targetLine = tag.method_10550("TargetLine");
        if (clientPacket && tag.method_10545("TargetType")) {
            this.activeTarget = DisplayTarget.get(class_2960.method_12829((String)tag.method_10558("TargetType")));
        }
        if (!tag.method_10545("Source")) {
            return;
        }
        class_2487 data = tag.method_10562("Source");
        this.activeSource = DisplaySource.get(class_2960.method_12829((String)data.method_10558("Id")));
        this.sourceConfig = new class_2487();
        if (this.activeSource != null) {
            this.sourceConfig = data.method_10553();
        }
    }

    public void target(class_2338 targetPosition) {
        this.targetOffset = targetPosition.method_10059((class_2382)this.field_11867);
    }

    public class_2338 getSourcePosition() {
        Iterator<FactoryPanelPosition> iterator = this.factoryPanelSupport.getLinkedPanels().iterator();
        if (iterator.hasNext()) {
            FactoryPanelPosition position = iterator.next();
            return position.pos();
        }
        return this.field_11867.method_10093(this.getDirection());
    }

    public class_2487 getSourceConfig() {
        return this.sourceConfig;
    }

    public void setSourceConfig(class_2487 sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public class_2350 getDirection() {
        return this.method_11010().method_28500((class_2769)DisplayLinkBlock.field_10927).orElse(class_2350.field_11036).method_10153();
    }

    public class_2338 getTargetPosition() {
        return this.field_11867.method_10081((class_2382)this.targetOffset);
    }

    @Override
    public class_243 getBulbOffset(class_2680 state) {
        if (state.method_28500((class_2769)DisplayLinkBlock.field_10927).orElse(class_2350.field_11036).method_10166().method_10178()) {
            return bulbOffsetVertical;
        }
        return bulbOffset;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        this.targetOffset = transform.applyWithoutOffset(this.targetOffset);
        this.notifyUpdate();
    }
}

