/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.client.tools.ToolType;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ToolSelectionScreen
extends class_437 {
    public final String scrollToCycle = CreateLang.translateDirect("gui.toolmenu.cycle", new Object[0]).getString();
    public final String holdToFocus = "gui.toolmenu.focusKey";
    protected List<ToolType> tools;
    protected Consumer<ToolType> callback;
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;

    public ToolSelectionScreen(List<ToolType> tools, Consumer<ToolType> callback) {
        super((class_2561)class_2561.method_43470((String)"Tool Selection"));
        this.field_22787 = class_310.method_1551();
        this.tools = tools;
        this.callback = callback;
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        callback.accept(tools.get(this.selection));
        this.w = Math.max(tools.size() * 50 + 30, 220);
        this.h = 30;
    }

    public void setSelectedElement(ToolType tool) {
        if (!this.tools.contains((Object)tool)) {
            return;
        }
        this.selection = this.tools.indexOf((Object)tool);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(class_332 graphics, float partialTicks) {
        class_4587 matrixStack = graphics.method_51448();
        class_1041 mainWindow = this.field_22787.method_22683();
        if (!this.initialized) {
            this.method_25423(this.field_22787, mainWindow.method_4486(), mainWindow.method_4502());
        }
        int x = (mainWindow.method_4486() - this.w) / 2 + 15;
        int y = mainWindow.method_4502() - this.h - 75;
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, -this.yOffset, this.focused ? 100.0f : 0.0f);
        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.focused ? 0.875f : 0.5f));
        graphics.method_25290(gray.location, x - 15, y, (float)gray.getStartX(), (float)gray.getStartY(), this.w, this.h, gray.getWidth(), gray.getHeight());
        float toolTipAlpha = this.yOffset / 10.0f;
        List<class_2561> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            graphics.method_25290(gray.location, x - 15, y + 33, (float)gray.getStartX(), (float)gray.getStartY(), this.w, this.h + 22, gray.getWidth(), gray.getHeight());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                graphics.method_51439(this.field_22793, toolTip.get(0), x - 10, y + 38, 0xEEEEEE + stringAlphaComponent, false);
            }
            if (toolTip.size() > 1) {
                graphics.method_51439(this.field_22793, toolTip.get(1), x - 10, y + 50, 0xCCDDFF + stringAlphaComponent, false);
            }
            if (toolTip.size() > 2) {
                graphics.method_51439(this.field_22793, toolTip.get(2), x - 10, y + 60, 0xCCDDFF + stringAlphaComponent, false);
            }
            if (toolTip.size() > 3) {
                graphics.method_51439(this.field_22793, toolTip.get(3), x - 10, y + 72, 0xCCCCDD + stringAlphaComponent, false);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.getBoundKey();
            int width = this.field_22787.method_22683().method_4486();
            if (!this.focused) {
                graphics.method_27534(this.field_22787.field_1772, (class_2561)CreateLang.translateDirect("gui.toolmenu.focusKey", keyName), width / 2, y - 10, 0xCCDDFF);
            } else {
                graphics.method_25300(this.field_22787.field_1772, this.scrollToCycle, width / 2, y - 10, 0xCCDDFF);
            }
        } else {
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            RenderSystem.enableBlend();
            matrixStack.method_22903();
            float f = alpha = this.focused ? 1.0f : 0.2f;
            if (i == this.selection) {
                matrixStack.method_46416(0.0f, -10.0f, 0.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.method_25300(this.field_22787.field_1772, this.tools.get(i).getDisplayName().getString(), x + i * 50 + 24, y + 28, 0xCCDDFF);
                alpha = 1.0f;
            }
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 12);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 11);
            matrixStack.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        matrixStack.method_22909();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(class_332 graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void method_25419() {
        this.callback.accept(this.tools.get(this.selection));
    }

    protected void method_25426() {
        super.method_25426();
        this.initialized = true;
    }
}

