/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class PlayerPassengerCondition
extends ScheduleWaitCondition {
    @Override
    public Pair<class_1799, class_2561> getSummary() {
        int target = this.getTarget();
        return Pair.of((Object)AllBlocks.SEATS.get(class_1767.field_7947).asStack(), (Object)CreateLang.translateDirect("schedule.condition.player_count." + (target == 1 ? "summary" : "summary_plural"), target));
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("player_count");
    }

    public int getTarget() {
        return this.intData("Count");
    }

    public boolean canOvershoot() {
        return this.intData("Exact") != 0;
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        int target = this.getTarget();
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.player_count.seated", CreateLang.translateDirect("schedule.condition.player_count." + (target == 1 ? "summary" : "summary_plural"), class_2561.method_43470((String)("" + target)).method_27692(class_124.field_1062))));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 31, (i, l) -> i.titled(CreateLang.translateDirect("schedule.condition.player_count.players", new Object[0])).withShiftStep(5).withRange(0, 21), "Count");
        builder.addSelectionScrollInput(36, 85, (i, l) -> i.forOptions(CreateLang.translatedOptions("schedule.condition.player_count", "exactly", "or_above")).titled(CreateLang.translateDirect("schedule.condition.player_count.condition", new Object[0])), "Exact");
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        int prev = context.method_10550("PrevPlayerCount");
        int present = train.countPlayerPassengers();
        int target = this.getTarget();
        context.method_10569("PrevPlayerCount", present);
        if (prev != present) {
            this.requestStatusToUpdate(context);
        }
        return this.canOvershoot() ? present >= target : present == target;
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        return CreateLang.translateDirect("schedule.condition.player_count.status", train.countPlayerPassengers(), this.getTarget());
    }
}

