/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.signal;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public abstract class TrackEdgePoint {
    public UUID id;
    public Couple<TrackNodeLocation> edgeLocation;
    public double position;
    private EdgePointType<?> type;

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public void setType(EdgePointType<?> type) {
        this.type = type;
    }

    public EdgePointType<?> getType() {
        return this.type;
    }

    public abstract boolean canMerge();

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return false;
    }

    public abstract void invalidate(class_1936 var1);

    protected void invalidateAt(class_1936 level, class_2338 blockEntityPos) {
        TrackTargetingBehaviour<?> behaviour = BlockEntityBehaviour.get((class_1922)level, blockEntityPos, TrackTargetingBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        class_2487 migrationData = new class_2487();
        DimensionPalette dimensions = new DimensionPalette();
        this.write(migrationData, dimensions);
        dimensions.write(migrationData);
        behaviour.invalidateEdgePoint(migrationData);
    }

    public abstract void blockEntityAdded(class_2586 var1, boolean var2);

    public abstract void blockEntityRemoved(class_2338 var1, boolean var2);

    public void onRemoved(TrackGraph graph) {
    }

    public void setLocation(Couple<TrackNodeLocation> nodes, double position) {
        this.edgeLocation = nodes;
        this.position = position;
    }

    public double getLocationOn(TrackEdge edge) {
        return this.isPrimary(edge.node1) ? edge.getLength() - this.position : this.position;
    }

    public boolean canNavigateVia(TrackNode side) {
        return true;
    }

    public boolean isPrimary(TrackNode node1) {
        return ((TrackNodeLocation)((Object)this.edgeLocation.getSecond())).equals((Object)node1.getLocation());
    }

    public void read(class_2487 nbt, boolean migration, DimensionPalette dimensions) {
        if (migration) {
            return;
        }
        this.id = nbt.method_25926("Id");
        this.position = nbt.method_10574("Position");
        this.edgeLocation = Couple.deserializeEach((class_2499)nbt.method_10554("Edge", 10), tag -> TrackNodeLocation.read(tag, dimensions));
    }

    public void read(class_2540 buffer, DimensionPalette dimensions) {
        this.id = buffer.method_10790();
        this.edgeLocation = Couple.create(() -> TrackNodeLocation.receive(buffer, dimensions));
        this.position = buffer.readDouble();
    }

    public void write(class_2487 nbt, DimensionPalette dimensions) {
        nbt.method_25927("Id", this.id);
        nbt.method_10549("Position", this.position);
        nbt.method_10566("Edge", (class_2520)this.edgeLocation.serializeEach(loc -> loc.write(dimensions)));
    }

    public void write(class_2540 buffer, DimensionPalette dimensions) {
        buffer.method_10812(this.type.getId());
        buffer.method_10797(this.id);
        this.edgeLocation.forEach(loc -> loc.send(buffer, dimensions));
        buffer.writeDouble(this.position);
    }

    public void tick(TrackGraph graph, boolean preTrains) {
    }

    protected void removeFromAllGraphs() {
        for (TrackGraph trackGraph : Create.RAILWAYS.trackNetworks.values()) {
            if (trackGraph.removePoint(this.getType(), this.id) == null) continue;
            return;
        }
    }
}

