/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.commons.lang3.mutable.MutableObject;

public class CurvedTrackSelectionPacket
extends BlockEntityConfigurationPacket<TrackBlockEntity> {
    private class_2338 targetPos;
    private boolean front;
    private int segment;
    private int slot;

    public CurvedTrackSelectionPacket(class_2338 pos, class_2338 targetPos, int segment, boolean front, int slot) {
        super(pos);
        this.targetPos = targetPos;
        this.segment = segment;
        this.front = front;
        this.slot = slot;
    }

    public CurvedTrackSelectionPacket(class_2540 buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(class_2540 buffer) {
        buffer.method_10807(this.targetPos);
        buffer.method_10804(this.segment);
        buffer.writeBoolean(this.front);
        buffer.method_10804(this.slot);
    }

    @Override
    protected void readSettings(class_2540 buffer) {
        this.targetPos = buffer.method_10811();
        this.segment = buffer.method_10816();
        this.front = buffer.readBoolean();
        this.slot = buffer.method_10816();
    }

    @Override
    protected void applySettings(class_3222 player, TrackBlockEntity be) {
        if (player.method_31548().field_7545 != this.slot) {
            return;
        }
        class_1799 stack = player.method_31548().method_5438(this.slot);
        if (!(stack.method_7909() instanceof TrackTargetingBlockItem)) {
            return;
        }
        if (player.method_5715() && stack.method_7985()) {
            player.method_7353((class_2561)CreateLang.translateDirect("track_target.clear", new Object[0]), true);
            stack.method_7980(null);
            AllSoundEvents.CONTROLLER_CLICK.play(player.method_37908(), null, (class_2382)this.pos, 1.0f, 0.5f);
            return;
        }
        EdgePointType<TrackEdgePoint> type = AllBlocks.TRACK_SIGNAL.isIn(stack) ? EdgePointType.SIGNAL : EdgePointType.STATION;
        MutableObject result = new MutableObject(null);
        TrackTargetingBlockItem.withGraphLocation(player.method_37908(), this.pos, this.front, new BezierTrackPointLocation(this.targetPos, this.segment), type, (overlap, location) -> result.setValue((Object)overlap));
        if (((TrackTargetingBlockItem.OverlapResult)((Object)result.getValue())).feedback != null) {
            player.method_7353((class_2561)CreateLang.translateDirect(((TrackTargetingBlockItem.OverlapResult)((Object)result.getValue())).feedback, new Object[0]).method_27692(class_124.field_1061), true);
            AllSoundEvents.DENY.play(player.method_37908(), null, (class_2382)this.pos, 0.5f, 1.0f);
            return;
        }
        class_2487 stackTag = stack.method_7948();
        stackTag.method_10566("SelectedPos", (class_2520)class_2512.method_10692((class_2338)this.pos));
        stackTag.method_10556("SelectedDirection", this.front);
        class_2487 bezierNbt = new class_2487();
        bezierNbt.method_10569("Segment", this.segment);
        bezierNbt.method_10566("Key", (class_2520)class_2512.method_10692((class_2338)this.targetPos));
        bezierNbt.method_10556("FromStack", true);
        stackTag.method_10566("Bezier", (class_2520)bezierNbt);
        player.method_7353((class_2561)CreateLang.translateDirect("track_target.set", new Object[0]), true);
        stack.method_7980(stackTag);
        AllSoundEvents.CONTROLLER_CLICK.play(player.method_37908(), null, (class_2382)this.pos, 1.0f, 1.0f);
    }

    @Override
    protected int maxRange() {
        return (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() + 16;
    }

    @Override
    protected void applySettings(TrackBlockEntity be) {
    }
}

