/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class TrackMaterial {
    public static final Map<class_2960, TrackMaterial> ALL = new HashMap<class_2960, TrackMaterial>();
    public static final TrackMaterial ANDESITE = TrackMaterialFactory.make(Create.asResource("andesite")).lang("Andesite").block((NonNullSupplier<NonNullSupplier<? extends TrackBlock>>)NonNullSupplier.lazy(() -> AllBlocks.TRACK)).particle(Create.asResource("block/palettes/stone_types/polished/andesite_cut_polished")).defaultModels().build();
    public final class_2960 id;
    public final String langName;
    public final NonNullSupplier<NonNullSupplier<? extends TrackBlock>> trackBlock;
    public final class_1856 sleeperIngredient;
    public final class_1856 railsIngredient;
    public final class_2960 particle;
    public final TrackType trackType;
    @Nullable
    private final TrackType.TrackBlockFactory customFactory;
    @Environment(value=EnvType.CLIENT)
    protected TrackModelHolder modelHolder;

    @Environment(value=EnvType.CLIENT)
    public TrackModelHolder getModelHolder() {
        return this.modelHolder;
    }

    public TrackMaterial(class_2960 id, String langName, NonNullSupplier<NonNullSupplier<? extends TrackBlock>> trackBlock, class_2960 particle, class_1856 sleeperIngredient, class_1856 railsIngredient, TrackType trackType, Supplier<Supplier<TrackModelHolder>> modelHolder) {
        this(id, langName, trackBlock, particle, sleeperIngredient, railsIngredient, trackType, modelHolder, null);
    }

    public TrackMaterial(class_2960 id, String langName, NonNullSupplier<NonNullSupplier<? extends TrackBlock>> trackBlock, class_2960 particle, class_1856 sleeperIngredient, class_1856 railsIngredient, TrackType trackType, Supplier<Supplier<TrackModelHolder>> modelHolder, @Nullable TrackType.TrackBlockFactory customFactory) {
        this.id = id;
        this.langName = langName;
        this.trackBlock = trackBlock;
        this.sleeperIngredient = sleeperIngredient;
        this.railsIngredient = railsIngredient;
        this.particle = particle;
        this.trackType = trackType;
        this.customFactory = customFactory;
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.lambda$new$1((Supplier)modelHolder));
        ALL.put(this.id, this);
    }

    public NonNullSupplier<? extends TrackBlock> getBlockSupplier() {
        return (NonNullSupplier)this.trackBlock.get();
    }

    public TrackBlock getBlock() {
        return (TrackBlock)this.getBlockSupplier().get();
    }

    public class_1799 asStack() {
        return this.asStack(1);
    }

    public class_1799 asStack(int count) {
        return new class_1799((class_1935)this.getBlock(), count);
    }

    public TrackBlock createBlock(class_4970.class_2251 properties) {
        return (this.customFactory != null ? this.customFactory : this.trackType.factory).create(properties, this);
    }

    public boolean isFromMod(String modId) {
        return this.id.method_12836().equals(modId);
    }

    public static List<TrackMaterial> allFromMod(String modid) {
        return ALL.values().stream().filter(tm -> tm.isFromMod(modid)).toList();
    }

    public static List<NonNullSupplier<? extends class_2248>> allBlocksFromMod(String modid) {
        ArrayList<NonNullSupplier<? extends class_2248>> list = new ArrayList<NonNullSupplier<? extends class_2248>>();
        for (TrackMaterial material : TrackMaterial.allFromMod(modid)) {
            list.add(material.getBlockSupplier());
        }
        return list;
    }

    public static List<NonNullSupplier<? extends class_2248>> allBlocks() {
        ArrayList<NonNullSupplier<? extends class_2248>> list = new ArrayList<NonNullSupplier<? extends class_2248>>();
        for (TrackMaterial material : ALL.values()) {
            list.add(material.getBlockSupplier());
        }
        return list;
    }

    public String resourceName() {
        return this.id.method_12832();
    }

    public static TrackMaterial deserialize(String serializedName) {
        if (serializedName.isBlank()) {
            return ANDESITE;
        }
        class_2960 id = class_2960.method_12829((String)serializedName);
        if (ALL.containsKey(id)) {
            return ALL.get(id);
        }
        Create.LOGGER.error("Failed to locate serialized track material: " + serializedName);
        return ANDESITE;
    }

    public static TrackMaterial fromItem(class_1792 item) {
        class_1747 blockItem;
        class_2248 class_22482;
        if (item instanceof class_1747 && (class_22482 = (blockItem = (class_1747)item).method_7711()) instanceof ITrackBlock) {
            ITrackBlock trackBlock = (ITrackBlock)class_22482;
            return trackBlock.getMaterial();
        }
        return ANDESITE;
    }

    private /* synthetic */ void lambda$new$1(Supplier modelHolder) {
        this.modelHolder = (TrackModelHolder)((Supplier)modelHolder.get()).get();
    }

    @Environment(value=EnvType.CLIENT)
    public record TrackModelHolder(PartialModel tie, PartialModel leftSegment, PartialModel rightSegment) {
        static final TrackModelHolder DEFAULT = new TrackModelHolder(AllPartialModels.TRACK_TIE, AllPartialModels.TRACK_SEGMENT_LEFT, AllPartialModels.TRACK_SEGMENT_RIGHT);
    }

    public static class TrackType {
        public static final TrackType STANDARD = new TrackType(Create.asResource("standard"), TrackBlock::new);
        public final class_2960 id;
        protected final TrackBlockFactory factory;

        public TrackType(class_2960 id, TrackBlockFactory factory) {
            this.id = id;
            this.factory = factory;
        }

        @FunctionalInterface
        public static interface TrackBlockFactory {
            public TrackBlock create(class_4970.class_2251 var1, TrackMaterial var2);
        }
    }
}

