/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.infrastructure.fabric.SimpleEntityVisualFactory;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.EntityBuilder;
import com.tterrag.registrate.fabric.EnvExecutor;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.engine_room.flywheel.lib.visualization.SimpleEntityVisualizer;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;

@ParametersAreNonnullByDefault
public class CreateEntityBuilder<T extends class_1297, P>
extends EntityBuilder<T, P> {
    @Nullable
    private NonNullSupplier<SimpleEntityVisualFactory<T>> visualFactory;
    private Predicate<T> renderNormally;

    public static <T extends class_1297, P> EntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_1299.class_4049<T> factory, class_1311 classification) {
        return new CreateEntityBuilder<T, P>(owner, parent, name, callback, factory, classification).defaultLang();
    }

    public CreateEntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_1299.class_4049<T> factory, class_1311 classification) {
        super(owner, parent, name, callback, factory, classification);
    }

    public CreateEntityBuilder<T, P> visual(NonNullSupplier<SimpleEntityVisualFactory<T>> visualFactory) {
        return this.visual(visualFactory, true);
    }

    public CreateEntityBuilder<T, P> visual(NonNullSupplier<SimpleEntityVisualFactory<T>> visualFactory, boolean renderNormally) {
        return this.visual(visualFactory, entity -> renderNormally);
    }

    public CreateEntityBuilder<T, P> visual(NonNullSupplier<SimpleEntityVisualFactory<T>> visualFactory, Predicate<T> renderNormally) {
        if (this.visualFactory == null) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::registerVisualizer);
        }
        this.visualFactory = visualFactory;
        this.renderNormally = renderNormally;
        return this;
    }

    protected void registerVisualizer() {
        this.onRegister(entry -> {
            Objects.requireNonNull(this.visualFactory);
            Predicate renderNormally = this.renderNormally;
            SimpleEntityVisualizer.builder((class_1299)((class_1299)this.getEntry())).factory(((SimpleEntityVisualFactory)this.visualFactory.get())::create).skipVanillaRender(entity -> !renderNormally.test(entity)).apply();
        });
    }
}

