/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.google.common.base.Suppliers;
import com.google.common.primitives.UnsignedBytes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.item.ItemSlots;
import com.simibubi.create.foundation.mixin.accessor.MobEffectInstanceAccessor;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1293;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_4174;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

public class CreateCodecs {
    public static final Codec<Long> NON_NEGATIVE_LONG = class_5699.method_48112((Codec)Codec.LONG, value -> value < 0L ? DataResult.error(() -> "Value is negative: " + value) : DataResult.success((Object)value));
    public static final Codec<Integer> INT_STR = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Integer.parseInt(string));
        }
        catch (NumberFormatException ignored) {
            return DataResult.error(() -> "Not an integer: " + string);
        }
    }, String::valueOf);
    public static final Codec<ItemStackHandler> ITEM_STACK_HANDLER = class_5699.method_39240(() -> ItemSlots.CODEC.xmap(slots -> slots.toHandler(ItemStackHandler::new), ItemSlots::fromHandler));
    public static final Codec<class_2487> COMPOUND_TAG = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        DataResult dataResult;
        class_2520 converted = (class_2520)dynamic.convert((DynamicOps)class_2509.field_11560).getValue();
        if (converted instanceof class_2487) {
            class_2487 compound = (class_2487)converted;
            dataResult = DataResult.success((Object)compound);
        } else {
            dataResult = DataResult.error(() -> "Not a compound: " + String.valueOf(converted));
        }
        return dataResult;
    }, tag -> new Dynamic((DynamicOps)class_2509.field_11560, tag));
    public static final Codec<FluidStack> FLUID_STACK = COMPOUND_TAG.xmap(FluidStack::loadFluidStackFromNBT, stack -> stack.writeToNBT(new class_2487()));
    public static final Codec<Double> NON_NEGATIVE_DOUBLE = CreateCodecs.doubleRangeWithMessage(0.0, Double.MAX_VALUE, i -> "Value must be non-negative: " + i);
    public static final Codec<Double> POSITIVE_DOUBLE = CreateCodecs.doubleRangeWithMessage(1.0, Double.MAX_VALUE, i -> "Value must be positive: " + i);
    public static final Codec<Integer> UNSIGNED_BYTE = Codec.BYTE.flatComapMap(UnsignedBytes::toInt, p_324632_ -> p_324632_ > 255 ? DataResult.error(() -> "Unsigned byte was too large: " + p_324632_ + " > 255") : DataResult.success((Object)p_324632_.byteValue()));
    public static final Codec<FluidStack> FLUID_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41173.method_39673().fieldOf("FluidName").forGetter(FluidStack::getFluid), (App)Codec.LONG.fieldOf("Amount").forGetter(FluidStack::getAmount), (App)class_2487.field_25128.optionalFieldOf("Tag").forGetter(stack -> Optional.ofNullable(stack.getTag()))).apply((Applicative)instance, (fluid, amount, tag) -> {
        FluidStack stack = new FluidStack(fluid, amount.longValue());
        if (!stack.isEmpty()) {
            tag.ifPresent(arg_0 -> ((FluidStack)stack).setTag(arg_0));
        }
        return stack;
    }));
    public static final MapCodec<class_1293> MOB_EFFECT_INSTANCE = CreateCodecs.recursive("MobEffectInstance", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41174.method_39673().fieldOf("effect").forGetter(class_1293::method_5579), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(class_1293::method_5584), (App)UNSIGNED_BYTE.optionalFieldOf("amplifier", (Object)0).forGetter(class_1293::method_5578), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(class_1293::method_5591), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(class_1293::method_5581), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(class_1293::method_5592), (App)codec.optionalFieldOf("hidden_effect").forGetter(i -> Optional.ofNullable(((MobEffectInstanceAccessor)i).create$getHiddenEffect())), (App)class_1293.class_7247.field_38085.optionalFieldOf("factor_data").forGetter(class_1293::method_42129)).apply((Applicative)instance, (effect, duration, amplifier, isAmbient, showParticles, showIcon, hiddenEffect, factorData) -> new class_1293(effect, duration.intValue(), amplifier.intValue(), isAmbient.booleanValue(), showParticles.booleanValue(), showIcon.booleanValue(), (class_1293)hiddenEffect.orElse(null), factorData))));
    public static final Codec<class_4174> FOOD_PROPERTIES = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("nutrition").forGetter(class_4174::method_19230), (App)Codec.FLOAT.fieldOf("saturation_modifier").forGetter(class_4174::method_19231), (App)Codec.BOOL.optionalFieldOf("is_meat", (Object)false).forGetter(class_4174::method_19232), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(class_4174::method_19233), (App)Codec.BOOL.optionalFieldOf("is_fast_food", (Object)false).forGetter(class_4174::method_19234), (App)FoodEffect.CODEC.listOf().optionalFieldOf("effects", List.of()).forGetter(i -> {
        ArrayList<FoodEffect> effects = new ArrayList<FoodEffect>();
        for (Pair pair : i.method_19235()) {
            effects.add(new FoodEffect((class_1293)pair.getFirst(), ((Float)pair.getSecond()).floatValue()));
        }
        return effects;
    })).apply((Applicative)instance, (nutrition, saturationModifier, isMeat, canAlwaysEat, isFastFood, effects) -> {
        class_4174.class_4175 builder = new class_4174.class_4175().method_19238(nutrition.intValue()).method_19237(saturationModifier.floatValue());
        if (isMeat.booleanValue()) {
            builder.method_19236();
        }
        if (canAlwaysEat.booleanValue()) {
            builder.method_19240();
        }
        if (isFastFood.booleanValue()) {
            builder.method_19241();
        }
        for (FoodEffect effect : effects) {
            builder.method_19239(effect.effect(), effect.probability());
        }
        return builder.method_19242();
    }));

    public static Codec<Integer> boundedIntStr(int min) {
        return class_5699.method_48112(INT_STR, i -> i >= min ? DataResult.success((Object)i) : DataResult.error(() -> "Value under minimum of " + min));
    }

    private static Codec<Double> doubleRangeWithMessage(double min, double max, Function<Double, String> errorMessage) {
        return class_5699.method_48112((Codec)Codec.DOUBLE, i -> i.compareTo(min) >= 0 && i.compareTo(max) <= 0 ? DataResult.success((Object)i) : DataResult.error(() -> (String)errorMessage.apply((Double)i)));
    }

    public static <A> MapCodec<A> recursive(String name, Function<Codec<A>, MapCodec<A>> wrapped) {
        return new RecursiveMapCodec<A>(name, wrapped);
    }

    private static class RecursiveMapCodec<A>
    extends MapCodec<A> {
        private final String name;
        private final Supplier<MapCodec<A>> wrapped;

        private RecursiveMapCodec(String name, Function<Codec<A>, MapCodec<A>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (MapCodec)wrapped.apply(this.codec()));
        }

        public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return this.wrapped.get().keys(ops);
        }

        public String toString() {
            return "RecursiveMapCodec[" + this.name + "]";
        }
    }

    public record FoodEffect(Supplier<class_1293> effectSupplier, float probability) {
        public static final Codec<FoodEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MOB_EFFECT_INSTANCE.fieldOf("effect").forGetter(FoodEffect::effect), (App)Codec.FLOAT.fieldOf("probability").forGetter(FoodEffect::probability)).apply((Applicative)instance, FoodEffect::new));

        private FoodEffect(class_1293 effect, float probability) {
            this(() -> effect, probability);
        }

        public class_1293 effect() {
            return new class_1293(this.effectSupplier.get());
        }
    }
}

