/*
 * Decompiled with CFR 0.152.
 */
package net.quackimpala7321.crafter.block.entity;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_8566;
import net.quackimpala7321.crafter.block.CrafterBlock;
import net.quackimpala7321.crafter.registry.ModBlockEntities;
import net.quackimpala7321.crafter.screen.CrafterScreenHandler;

public class CrafterBlockEntity
extends class_2621
implements class_8566,
ExtendedScreenHandlerFactory {
    public static final int GRID_WIDTH = 3;
    public static final int GRID_HEIGHT = 3;
    public static final int GRID_SIZE = 9;
    public static final int SLOT_DISABLED = 1;
    public static final int SLOT_ENABLED = 0;
    public static final int TRIGGERED_PROPERTY = 9;
    public static final int PROPERTIES_COUNT = 10;
    private class_2371<class_1799> inputStacks = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private int craftingTicksRemaining = 0;
    protected final class_3913 propertyDelegate = new class_3913(){
        private final int[] disabledSlots = new int[9];
        private int triggered = 0;

        public int method_17390(int index) {
            return index == 9 ? this.triggered : this.disabledSlots[index];
        }

        public void method_17391(int index, int value) {
            if (index == 9) {
                this.triggered = value;
            } else {
                this.disabledSlots[index] = value;
            }
        }

        public int method_17389() {
            return 10;
        }
    };

    public CrafterBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.CRAFTER, pos, state);
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"container.crafter");
    }

    public class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new CrafterScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void setSlotEnabled(int slot, boolean enabled) {
        if (this.canToggleSlot(slot)) {
            this.propertyDelegate.method_17391(slot, enabled ? 0 : 1);
            this.method_5431();
        }
    }

    public boolean isSlotDisabled(int slot) {
        return slot >= 0 && slot < 9 && this.propertyDelegate.method_17390(slot) == 1;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (this.propertyDelegate.method_17390(slot) == 1) {
            return false;
        }
        class_1799 itemStack = (class_1799)this.inputStacks.get(slot);
        int i = itemStack.method_7947();
        if (i >= itemStack.method_7914()) {
            return false;
        }
        if (itemStack.method_7960()) {
            return true;
        }
        return !this.betterSlotExists(i, itemStack, slot);
    }

    private boolean betterSlotExists(int count, class_1799 stack, int slot) {
        for (int i = slot + 1; i < 9; ++i) {
            class_1799 itemStack;
            if (this.isSlotDisabled(i) || !(itemStack = this.method_5438(i)).method_7960() && (itemStack.method_7947() >= count || !class_1799.method_31577((class_1799)itemStack, (class_1799)stack))) continue;
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.craftingTicksRemaining = nbt.method_10550("crafting_ticks_remaining");
        this.inputStacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(nbt)) {
            class_1262.method_5429((class_2487)nbt, this.inputStacks);
        }
        int[] is = nbt.method_10561("disabled_slots");
        for (int i = 0; i < 9; ++i) {
            this.propertyDelegate.method_17391(i, 0);
        }
        int[] var7 = is;
        int var4 = is.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            int j = var7[var5];
            if (!this.canToggleSlot(j)) continue;
            this.propertyDelegate.method_17391(j, 1);
        }
        this.propertyDelegate.method_17391(9, nbt.method_10550("triggered"));
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("crafting_ticks_remaining", this.craftingTicksRemaining);
        if (!this.method_11286(nbt)) {
            class_1262.method_5426((class_2487)nbt, this.inputStacks);
        }
        this.putDisabledSlots(nbt);
        this.putTriggered(nbt);
    }

    public int method_5439() {
        return 9;
    }

    public boolean method_5442() {
        return this.inputStacks.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inputStacks.get(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (this.isSlotDisabled(slot)) {
            this.setSlotEnabled(slot, true);
        }
        super.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 != null && this.field_11863.method_8321(this.field_11867) == this) {
            return !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > 64.0);
        }
        return false;
    }

    public class_2371<class_1799> method_11282() {
        return this.inputStacks;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inputStacks = list;
    }

    public int method_17398() {
        return 3;
    }

    public int method_17397() {
        return 3;
    }

    public List<class_1799> method_51305() {
        return this.inputStacks;
    }

    public void method_7683(class_1662 finder) {
        for (class_1799 itemStack : this.inputStacks) {
            finder.method_7404(itemStack);
        }
    }

    private void putDisabledSlots(class_2487 nbt) {
        IntArrayList intList = new IntArrayList();
        for (int i = 0; i < 9; ++i) {
            if (!this.isSlotDisabled(i)) continue;
            intList.add(i);
        }
        nbt.method_10572("disabled_slots", (List)intList);
    }

    private void putTriggered(class_2487 nbt) {
        nbt.method_10569("triggered", this.propertyDelegate.method_17390(9));
    }

    public void setTriggered(boolean triggered) {
        this.propertyDelegate.method_17391(9, triggered ? 1 : 0);
    }

    @VisibleForTesting
    public boolean isTriggered() {
        return this.propertyDelegate.method_17390(9) == 1;
    }

    public static void tickCrafting(class_1937 world, class_2338 pos, class_2680 state, CrafterBlockEntity blockEntity) {
        int i = blockEntity.craftingTicksRemaining - 1;
        if (i >= 0) {
            blockEntity.craftingTicksRemaining = i;
            if (i == 0) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)CrafterBlock.CRAFTING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void setCraftingTicksRemaining(int craftingTicksRemaining) {
        this.craftingTicksRemaining = craftingTicksRemaining;
    }

    public int getComparatorOutput() {
        int i = 0;
        for (int j = 0; j < this.method_5439(); ++j) {
            class_1799 itemStack = this.method_5438(j);
            if (itemStack.method_7960() && !this.isSlotDisabled(j)) continue;
            ++i;
        }
        return i;
    }

    private boolean canToggleSlot(int slot) {
        return slot > -1 && slot < 9 && ((class_1799)this.inputStacks.get(slot)).method_7960();
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }
}

