/*
 * Decompiled with CFR 0.152.
 */
package net.quackimpala7321.crafter.recipe;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;

public class RecipeCache {
    private final CachedRecipe[] cache;
    private WeakReference<class_1863> recipeManagerRef = new WeakReference<Object>(null);

    public RecipeCache(int size) {
        this.cache = new CachedRecipe[size];
    }

    public Optional<class_3955> getRecipe(class_1937 world, class_8566 inputInventory) {
        if (inputInventory.method_5442()) {
            return Optional.empty();
        }
        this.validateRecipeManager(world);
        for (int i = 0; i < this.cache.length; ++i) {
            CachedRecipe cachedRecipe = this.cache[i];
            if (cachedRecipe == null || !cachedRecipe.matches(inputInventory.method_51305())) continue;
            this.sendToFront(i);
            return Optional.ofNullable(cachedRecipe.craftingRecipe());
        }
        return this.getAndCacheRecipe(inputInventory, world);
    }

    private void validateRecipeManager(class_1937 world) {
        class_1863 recipeManager = world.method_8433();
        if (recipeManager != this.recipeManagerRef.get()) {
            this.recipeManagerRef = new WeakReference<class_1863>(recipeManager);
            Arrays.fill(this.cache, null);
        }
    }

    private Optional<class_3955> getAndCacheRecipe(class_8566 inputInventory, class_1937 world) {
        Optional optional = world.method_8433().method_8132(class_3956.field_17545, (class_1263)inputInventory, world);
        this.cache(inputInventory.method_51305(), optional.orElse(null));
        return optional;
    }

    private void sendToFront(int index) {
        if (index > 0) {
            CachedRecipe cachedRecipe = this.cache[index];
            System.arraycopy(this.cache, 0, this.cache, 1, index);
            this.cache[0] = cachedRecipe;
        }
    }

    private void cache(List<class_1799> inputStacks, @Nullable class_3955 recipe) {
        class_2371 defaultedList = class_2371.method_10213((int)inputStacks.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < inputStacks.size(); ++i) {
            defaultedList.set(i, (Object)inputStacks.get(i).method_46651(1));
        }
        System.arraycopy(this.cache, 0, this.cache, 1, this.cache.length - 1);
        this.cache[0] = new CachedRecipe((class_2371<class_1799>)defaultedList, recipe);
    }

    record CachedRecipe(class_2371<class_1799> defaultedList, @Nullable class_3955 craftingRecipe) {
        public boolean matches(List<class_1799> inputs) {
            if (this.defaultedList.size() != inputs.size()) {
                return false;
            }
            for (int i = 0; i < this.defaultedList.size(); ++i) {
                if (class_1799.method_31577((class_1799)((class_1799)this.defaultedList.get(i)), (class_1799)inputs.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

