/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1934;
import team.creative.creativecore.common.config.gui.GuiPlayerSelectorButton;
import team.creative.creativecore.common.config.gui.PlayerSelectorDialog;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.util.player.PlayerSelector;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

@Environment(value=EnvType.CLIENT)
public abstract class GuiPlayerSelectorHandler<T extends PlayerSelector> {
    public static final NamedHandlerRegistry<GuiPlayerSelectorHandler> REGISTRY = new NamedHandlerRegistry<Object>(null);
    private String name;

    public static GuiPlayerSelectorHandler get(PlayerSelector selector) {
        return REGISTRY.get(PlayerSelector.REGISTRY.getId(selector));
    }

    public String getName() {
        return this.name;
    }

    public abstract void createControls(PlayerSelectorDialog var1, PlayerSelector var2);

    public abstract T parseSelector(PlayerSelectorDialog var1);

    public void onChanged(PlayerSelectorDialog gui, GuiControlChangedEvent event) {
    }

    static {
        REGISTRY.register("and", new GuiPlayerSelectorHandlerMultiple<PlayerSelector.PlayerSelectorAnd>(){

            @Override
            public PlayerSelector.PlayerSelectorAnd parseSelector(PlayerSelector[] selectors) {
                return new PlayerSelector.PlayerSelectorAnd(selectors);
            }
        });
        REGISTRY.register("or", new GuiPlayerSelectorHandlerMultiple<PlayerSelector.PlayerSelectorOr>(){

            @Override
            public PlayerSelector.PlayerSelectorOr parseSelector(PlayerSelector[] selectors) {
                return new PlayerSelector.PlayerSelectorOr(selectors);
            }
        });
        REGISTRY.register("not", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorNot>(){

            @Override
            public void createControls(PlayerSelectorDialog gui, PlayerSelector selector) {
                PlayerSelector playerSelector;
                if (selector instanceof PlayerSelector.PlayerSelectorNot) {
                    PlayerSelector.PlayerSelectorNot select = (PlayerSelector.PlayerSelectorNot)selector;
                    playerSelector = select.selector;
                } else {
                    playerSelector = new PlayerSelector.PlayerSelectorLevel(0);
                }
                gui.add((GuiControl)new GuiPlayerSelectorButton("not", playerSelector));
            }

            @Override
            public PlayerSelector.PlayerSelectorNot parseSelector(PlayerSelectorDialog gui) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)gui.get("not");
                PlayerSelector selector = button.get();
                if (selector != null) {
                    return new PlayerSelector.PlayerSelectorNot(selector);
                }
                return null;
            }
        });
        REGISTRY.register("level", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorLevel>(){

            @Override
            public void createControls(PlayerSelectorDialog gui, PlayerSelector selector) {
                Object object;
                if (selector instanceof PlayerSelector.PlayerSelectorLevel) {
                    PlayerSelector.PlayerSelectorLevel select = (PlayerSelector.PlayerSelectorLevel)selector;
                    object = "" + select.permissionLevel;
                } else {
                    object = "0";
                }
                gui.add((GuiControl)new GuiTextfield("content", (String)object).setNumbersOnly());
            }

            @Override
            public PlayerSelector.PlayerSelectorLevel parseSelector(PlayerSelectorDialog gui) {
                GuiTextfield text = (GuiTextfield)gui.get("content");
                return new PlayerSelector.PlayerSelectorLevel(text.parseInteger());
            }
        });
        REGISTRY.register("mode", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorGamemode>(){

            @Override
            public void createControls(PlayerSelectorDialog gui, PlayerSelector selector) {
                int n;
                if (selector instanceof PlayerSelector.PlayerSelectorGamemode) {
                    PlayerSelector.PlayerSelectorGamemode select = (PlayerSelector.PlayerSelectorGamemode)selector;
                    n = select.type.method_8379();
                } else {
                    n = 0;
                }
                gui.add((GuiControl)new GuiStateButton("mode", n, "survival", "creative", "adventure", "spectator"));
            }

            @Override
            public PlayerSelector.PlayerSelectorGamemode parseSelector(PlayerSelectorDialog gui) {
                GuiStateButton mode = (GuiStateButton)gui.get("mode");
                return new PlayerSelector.PlayerSelectorGamemode(class_1934.method_8384((int)mode.getState()));
            }
        });
        REGISTRY.register("selector", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorCommandSelector>(){

            @Override
            public void createControls(PlayerSelectorDialog gui, PlayerSelector selector) {
                String string;
                if (selector instanceof PlayerSelector.PlayerSelectorCommandSelector) {
                    PlayerSelector.PlayerSelectorCommandSelector select = (PlayerSelector.PlayerSelectorCommandSelector)selector;
                    string = select.pattern;
                } else {
                    string = "@a[]";
                }
                gui.add((GuiControl)new GuiTextfield("content", string));
            }

            @Override
            public PlayerSelector.PlayerSelectorCommandSelector parseSelector(PlayerSelectorDialog gui) {
                GuiTextfield text = (GuiTextfield)gui.get("content");
                if (text.getText().isEmpty()) {
                    return null;
                }
                return new PlayerSelector.PlayerSelectorCommandSelector(text.getText());
            }
        });
    }

    public static abstract class GuiPlayerSelectorHandlerMultiple<T extends PlayerSelector>
    extends GuiPlayerSelectorHandler<T> {
        public PlayerSelector[] getChildren(PlayerSelector selector) {
            if (selector instanceof PlayerSelector.PlayerSelectorAnd) {
                return ((PlayerSelector.PlayerSelectorAnd)selector).selectors;
            }
            if (selector instanceof PlayerSelector.PlayerSelectorOr) {
                return ((PlayerSelector.PlayerSelectorOr)selector).selectors;
            }
            return new PlayerSelector[]{selector};
        }

        @Override
        public void createControls(PlayerSelectorDialog gui, PlayerSelector selector) {
            PlayerSelector[] selectors = this.getChildren(selector);
            ArrayList<GuiPlayerSelectorButton> buttons = new ArrayList<GuiPlayerSelectorButton>();
            if (selectors != null) {
                for (int i = 0; i < selectors.length; ++i) {
                    buttons.add(new GuiPlayerSelectorButton("" + i, selectors[i]));
                }
            }
            GuiListBoxBase list = new GuiListBoxBase("list", true, buttons);
            gui.addControl(list);
            gui.addControl(new GuiButton("add", x -> list.addItem(new GuiPlayerSelectorButton("new", new PlayerSelector.PlayerSelectorLevel(0)))));
        }

        @Override
        public T parseSelector(PlayerSelectorDialog gui) {
            GuiListBoxBase list = (GuiListBoxBase)gui.get("list");
            PlayerSelector[] selectors = new PlayerSelector[list.size()];
            for (int i = 0; i < selectors.length; ++i) {
                selectors[i] = ((GuiPlayerSelectorButton)list.get(i)).get();
            }
            if (selectors.length > 0) {
                return this.parseSelector(selectors);
            }
            return null;
        }

        public abstract T parseSelector(PlayerSelector[] var1);
    }
}

