/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2473;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4590;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_816;
import net.minecraft.class_8567;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.PostInitable;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.JsonFactory;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.basis.PottableLeavesBlock;
import org.betterx.betterend.client.models.Patterns;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.interfaces.PottablePlant;
import org.betterx.betterend.interfaces.PottableTerrain;
import org.betterx.betterend.registry.EndBlocks;
import org.joml.Vector3f;

public class FlowerPotBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
PostInitable {
    private static final class_2758 PLANT_ID = EndBlockProperties.PLANT_ID;
    private static final class_2758 SOIL_ID = EndBlockProperties.SOIL_ID;
    private static final class_2758 POT_LIGHT = EndBlockProperties.POT_LIGHT;
    private static final class_265 SHAPE_EMPTY = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (class_265)class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0));
    private static final class_265 SHAPE_FULL = class_259.method_1084((class_265)SHAPE_EMPTY, (class_265)class_2248.method_9541((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static class_2248[] plants;
    private static class_2248[] soils;

    public FlowerPotBlock(class_2248 source) {
        super((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)source).luminance(state -> (Integer)state.method_11654((class_2769)POT_LIGHT) * 5));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)PLANT_ID, (Comparable)Integer.valueOf(0))).method_11657((class_2769)SOIL_ID, (Comparable)Integer.valueOf(0))).method_11657((class_2769)POT_LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{PLANT_ID, SOIL_ID, POT_LIGHT});
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        ArrayList drop = Lists.newArrayList((Object[])new class_1799[]{new class_1799((class_1935)this)});
        int id = (Integer)state.method_11654((class_2769)SOIL_ID) - 1;
        if (id >= 0 && id < soils.length && soils[id] != null) {
            drop.add(new class_1799((class_1935)soils[id]));
        }
        if ((id = (Integer)state.method_11654((class_2769)PLANT_ID) - 1) >= 0 && id < plants.length && plants[id] != null) {
            drop.add(new class_1799((class_1935)plants[id]));
        }
        return drop;
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        int plantID = (Integer)state.method_11654((class_2769)PLANT_ID);
        if (plantID < 1 || plantID > plants.length || plants[plantID - 1] == null) {
            return (Integer)state.method_11654((class_2769)POT_LIGHT) > 0 ? (class_2680)state.method_11657((class_2769)POT_LIGHT, (Comparable)Integer.valueOf(0)) : state;
        }
        int light = plants[plantID - 1].method_9564().method_26213() / 5;
        if ((Integer)state.method_11654((class_2769)POT_LIGHT) != light) {
            state = (class_2680)state.method_11657((class_2769)POT_LIGHT, (Comparable)Integer.valueOf(light));
        }
        return state;
    }

    public void postInit() {
        if (plants != null) {
            return;
        }
        class_2248[] plants = new class_2248[128];
        class_2248[] soils = new class_2248[16];
        HashMap reservedPlantsIDs = Maps.newHashMap();
        HashMap reservedSoilIDs = Maps.newHashMap();
        JsonObject obj = JsonFactory.getJsonObject((File)new File(FabricLoader.getInstance().getConfigDir().toFile(), "betterend/blocks.json"));
        if (obj.get("flower_pots") != null) {
            JsonElement plantsObj = obj.get("flower_pots").getAsJsonObject().get("plants");
            JsonElement soilsObj = obj.get("flower_pots").getAsJsonObject().get("soils");
            if (plantsObj != null) {
                plantsObj.getAsJsonObject().entrySet().forEach(entry -> {
                    String name = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(32));
                    reservedPlantsIDs.put(name, ((JsonElement)entry.getValue()).getAsInt());
                });
            }
            if (soilsObj != null) {
                soilsObj.getAsJsonObject().entrySet().forEach(entry -> {
                    String name = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(32));
                    reservedSoilIDs.put(name, ((JsonElement)entry.getValue()).getAsInt());
                });
            }
        }
        EndBlocks.getModBlocks().forEach(block -> {
            if (block instanceof PottablePlant && ((PottablePlant)block).canBePotted()) {
                this.processBlock(plants, (class_2248)block, "flower_pots.plants", reservedPlantsIDs);
            } else if (block instanceof PottableTerrain && ((PottableTerrain)block).canBePotted()) {
                this.processBlock(soils, (class_2248)block, "flower_pots.soils", reservedSoilIDs);
            }
        });
        Configs.BLOCK_CONFIG.saveChanges();
        FlowerPotBlock.plants = new class_2248[this.maxNotNull(plants) + 1];
        System.arraycopy(plants, 0, FlowerPotBlock.plants, 0, FlowerPotBlock.plants.length);
        FlowerPotBlock.soils = new class_2248[this.maxNotNull(soils) + 1];
        System.arraycopy(soils, 0, FlowerPotBlock.soils, 0, FlowerPotBlock.soils.length);
        if (PLANT_ID.method_11900(Integer.toString(FlowerPotBlock.plants.length)).isEmpty()) {
            throw new RuntimeException("There are too much plant ID values!");
        }
        if (SOIL_ID.method_11900(Integer.toString(FlowerPotBlock.soils.length)).isEmpty()) {
            throw new RuntimeException("There are too much soil ID values!");
        }
    }

    private int maxNotNull(class_2248[] array) {
        int max = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            max = i;
        }
        return max;
    }

    private void processBlock(class_2248[] target, class_2248 block, String path, Map<String, Integer> idMap) {
        class_2960 location = class_7923.field_41175.method_10221((Object)block);
        if (idMap.containsKey(location.method_12832())) {
            target[idMap.get((Object)location.method_12832()).intValue()] = block;
        } else {
            for (int i = 0; i < target.length; ++i) {
                if (idMap.containsValue(i)) continue;
                target[i] = block;
                idMap.put(location.method_12832(), i);
                Configs.BLOCK_CONFIG.getInt(path, location.method_12832(), i);
                break;
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_21466;
        }
        class_1799 itemStack = player.method_5998(hand);
        int soilID = (Integer)state.method_11654((class_2769)SOIL_ID);
        if (soilID == 0 || soilID > soils.length || soils[soilID - 1] == null) {
            if (!(itemStack.method_7909() instanceof class_1747)) {
                return class_1269.field_5811;
            }
            class_2248 block = ((class_1747)itemStack.method_7909()).method_7711();
            for (int i = 0; i < soils.length; ++i) {
                if (block != soils[i]) continue;
                BlocksHelper.setWithUpdate((class_1936)level, (class_2338)pos, (class_2680)((class_2680)state.method_11657((class_2769)SOIL_ID, (Comparable)Integer.valueOf(i + 1))));
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                level.method_43128(player, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_21946, class_3419.field_15245, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        int plantID = (Integer)state.method_11654((class_2769)PLANT_ID);
        if (itemStack.method_7960()) {
            if (plantID > 0 && plantID <= plants.length && plants[plantID - 1] != null) {
                BlocksHelper.setWithUpdate((class_1936)level, (class_2338)pos, (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)PLANT_ID, (Comparable)Integer.valueOf(0))).method_11657((class_2769)POT_LIGHT, (Comparable)Integer.valueOf(0))));
                player.method_7270(new class_1799((class_1935)plants[plantID - 1]));
                return class_1269.field_5812;
            }
            if (soilID > 0 && soilID <= soils.length && soils[soilID - 1] != null) {
                BlocksHelper.setWithUpdate((class_1936)level, (class_2338)pos, (class_2680)((class_2680)state.method_11657((class_2769)SOIL_ID, (Comparable)Integer.valueOf(0))));
                player.method_7270(new class_1799((class_1935)soils[soilID - 1]));
            }
            return class_1269.field_5811;
        }
        if (!(itemStack.method_7909() instanceof class_1747)) {
            return class_1269.field_5811;
        }
        class_1747 item = (class_1747)itemStack.method_7909();
        for (int i = 0; i < plants.length; ++i) {
            if (item.method_7711() != plants[i]) continue;
            if (!((PottablePlant)plants[i]).canPlantOn(soils[soilID - 1])) {
                return class_1269.field_5811;
            }
            int light = plants[i].method_9564().method_26213() / 5;
            BlocksHelper.setWithUpdate((class_1936)level, (class_2338)pos, (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)PLANT_ID, (Comparable)Integer.valueOf(i + 1))).method_11657((class_2769)POT_LIGHT, (Comparable)Integer.valueOf(light))));
            level.method_43128(player, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 blockId) {
        Optional pattern = PatternsHelper.createJson((class_2960)Patterns.BLOCK_FLOWER_POT, (class_2960)blockId);
        return ModelsHelper.fromPattern((Optional)pattern);
    }

    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        int i;
        ModelsHelper.MultiPartBuilder model = ModelsHelper.MultiPartBuilder.create((class_2689)this.field_10647);
        model.part((class_2960)new class_1091(stateId.method_12836(), stateId.method_12832(), "inventory")).add();
        class_4590 offset = new class_4590(new Vector3f(0.0f, 0.46875f, 0.0f), null, null, null);
        for (i = 0; i < plants.length; ++i) {
            class_793 unbakedModel;
            Optional<String> pattern;
            HashMap textures;
            class_2960 loc;
            if (plants[i] == null) continue;
            int compareID = i + 1;
            class_2960 modelPath = class_7923.field_41175.method_10221((Object)plants[i]);
            class_2960 objSource = new class_2960(modelPath.method_12836(), "models/block/" + modelPath.method_12832() + "_potted.json");
            if (class_310.method_1551().method_1478().method_14486(objSource).isPresent()) {
                objSource = new class_2960(modelPath.method_12836(), "block/" + modelPath.method_12832() + "_potted");
                model.part(objSource).setTransformation(offset).setCondition(state -> (Integer)state.method_11654((class_2769)PLANT_ID) == compareID).add();
                continue;
            }
            if (plants[i] instanceof class_2473) {
                loc = class_7923.field_41175.method_10221((Object)plants[i]);
                modelPath = new class_2960(loc.method_12836(), "block/" + loc.method_12832() + "_potted");
                textures = Maps.newHashMap();
                textures.put("%modid%", loc.method_12836());
                textures.put("%texture%", loc.method_12832());
                pattern = Patterns.createJson(BasePatterns.BLOCK_CROSS, textures);
                unbakedModel = ModelsHelper.fromPattern(pattern);
                modelCache.put(modelPath, (class_1100)unbakedModel);
                model.part(modelPath).setTransformation(offset).setCondition(state -> (Integer)state.method_11654((class_2769)PLANT_ID) == compareID).add();
                continue;
            }
            if (plants[i] instanceof PottableLeavesBlock) {
                loc = class_7923.field_41175.method_10221((Object)plants[i]);
                modelPath = new class_2960(loc.method_12836(), "block/" + loc.method_12832() + "_potted");
                textures = Maps.newHashMap();
                textures.put("%leaves%", loc.method_12832().contains("lucernia") ? loc.method_12832() + "_1" : loc.method_12832());
                textures.put("%stem%", loc.method_12832().replace("_leaves", "_log_side"));
                pattern = Patterns.createJson(Patterns.BLOCK_POTTED_LEAVES, textures);
                unbakedModel = ModelsHelper.fromPattern(pattern);
                modelCache.put(modelPath, (class_1100)unbakedModel);
                model.part(modelPath).setTransformation(offset).setCondition(state -> (Integer)state.method_11654((class_2769)PLANT_ID) == compareID).add();
                continue;
            }
            objSource = new class_2960(modelPath.method_12836(), "blockstates/" + modelPath.method_12832() + ".json");
            JsonObject obj = JsonFactory.getJsonObject((class_2960)objSource);
            if (obj != null) {
                JsonElement variants = obj.get("variants");
                JsonElement list = null;
                String path = null;
                if (variants == null) continue;
                if (variants.isJsonArray()) {
                    list = variants.getAsJsonArray().get(0);
                } else if (variants.isJsonObject()) {
                    list = variants.getAsJsonObject().get(((PottablePlant)plants[i]).getPottedState());
                }
                if (list == null) {
                    BetterEnd.LOGGER.warning("Incorrect json for pot plant " + objSource + ", no matching variants", new Object[0]);
                    continue;
                }
                path = list.isJsonArray() ? list.getAsJsonArray().get(0).getAsJsonObject().get("model").getAsString() : list.getAsJsonObject().get("model").getAsString();
                if (path == null) {
                    BetterEnd.LOGGER.warning("Incorrect json for pot plant " + objSource + ", no matching variants", new Object[0]);
                    continue;
                }
                model.part(new class_2960(path)).setTransformation(offset).setCondition(state -> (Integer)state.method_11654((class_2769)PLANT_ID) == compareID).add();
                continue;
            }
            class_2960 loc2 = class_7923.field_41175.method_10221((Object)plants[i]);
            modelPath = new class_2960(loc2.method_12836(), "block/" + loc2.method_12832() + "_potted");
            HashMap textures2 = Maps.newHashMap();
            textures2.put("%modid%", loc2.method_12836());
            textures2.put("%texture%", loc2.method_12832());
            Optional<String> pattern2 = Patterns.createJson(BasePatterns.BLOCK_CROSS, textures2);
            class_793 unbakedModel2 = ModelsHelper.fromPattern(pattern2);
            modelCache.put(modelPath, (class_1100)unbakedModel2);
            model.part(modelPath).setTransformation(offset).setCondition(state -> (Integer)state.method_11654((class_2769)PLANT_ID) == compareID).add();
        }
        for (i = 0; i < soils.length; ++i) {
            if (soils[i] == null) continue;
            class_2960 soilLoc = BetterEnd.makeID("flower_pot_soil_" + i);
            if (!modelCache.containsKey(soilLoc)) {
                String texture = class_7923.field_41175.method_10221((Object)soils[i]).method_12832() + "_top";
                if (texture.contains("rutiscus")) {
                    texture = texture + "_1";
                }
                Optional<String> pattern = Patterns.createJson(Patterns.BLOCK_FLOWER_POT_SOIL, texture);
                class_793 soil = ModelsHelper.fromPattern(pattern);
                modelCache.put(soilLoc, (class_1100)soil);
            }
            int compareID = i + 1;
            model.part(soilLoc).setCondition(state -> (Integer)state.method_11654((class_2769)SOIL_ID) == compareID).add();
        }
        class_816 result = model.build();
        modelCache.put(stateId, (class_1100)result);
        return result;
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        int id = (Integer)state.method_11654((class_2769)PLANT_ID);
        return id > 0 && id <= plants.length ? SHAPE_FULL : SHAPE_EMPTY;
    }

    public class_265 method_9549(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        return SHAPE_EMPTY;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public static class Stone
    extends FlowerPotBlock
    implements BehaviourStone {
        public Stone(class_2248 source) {
            super(source);
        }
    }
}

