/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.portal;

import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_4153;
import net.minecraft.class_4538;
import net.minecraft.class_5459;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.EndPortalBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.rituals.EternalRitual;

public class PortalBuilder {
    public static final Set<Point> FRAME_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 6), new Point(1, 0), new Point(1, 6), new Point(2, 1), new Point(2, 5), new Point(3, 2), new Point(3, 3), new Point(3, 4)});
    public static final Set<Point> PORTAL_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 1), new Point(0, 2), new Point(0, 3), new Point(0, 4), new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(1, 3), new Point(1, 4), new Point(2, 1), new Point(2, 2), new Point(2, 3)});
    private static final Set<Point> BASE_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(3, 0), new Point(2, 0), new Point(2, 1), new Point(1, 1), new Point(1, 2), new Point(0, 1), new Point(0, 2)});
    private static final class_2248 BASE = EndBlocks.FLAVOLITE.tiles;
    public static final class_2248 FRAME = EndBlocks.FLAVOLITE_RUNED_ETERNAL;
    public static final class_2248 PORTAL = EndBlocks.END_PORTAL_BLOCK;
    public static int SPIRAL_SEARCH_RADIUS = 128;
    private final class_3218 targetLevel;
    private final class_1937 sourceLevel;

    public PortalBuilder(class_1937 sourceLevel, class_3218 targetLevel) {
        this.targetLevel = targetLevel;
        this.sourceLevel = sourceLevel;
    }

    public static void generatePortal(class_1937 world, class_2338 center, class_2350.class_2351 axis, int portalId) {
        class_2338 framePos = center.method_10074();
        class_2350 moveDir = class_2350.class_2351.field_11048 == axis ? class_2350.field_11034 : class_2350.field_11043;
        class_2680 frame = (class_2680)FRAME.method_9564().method_11657((class_2769)EternalRitual.ACTIVE, (Comparable)Boolean.valueOf(true));
        FRAME_POSITIONS.forEach(point -> {
            class_2338.class_2339 pos = framePos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            world.method_8501((class_2338)pos, frame);
            pos = framePos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y);
            world.method_8501((class_2338)pos, frame);
        });
        class_2680 portal = (class_2680)((class_2680)PORTAL.method_9564().method_11657((class_2769)EndPortalBlock.field_11310, (Comparable)axis)).method_11657((class_2769)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(portalId));
        PORTAL_POSITIONS.forEach(point -> {
            class_2338.class_2339 pos = center.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            world.method_8501((class_2338)pos, portal);
            pos = center.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y);
            world.method_8501((class_2338)pos, portal);
        });
        PortalBuilder.generateBase(world, framePos, moveDir);
    }

    private static void generateBase(class_1937 world, class_2338 center, class_2350 moveX) {
        class_2680 base = BASE.method_9564();
        class_2350 moveY = moveX.method_10170();
        BASE_POSITIONS.forEach(point -> {
            class_2338.class_2339 pos = center.method_25503().method_10104(moveX, point.x).method_10104(moveY, point.y);
            world.method_8501((class_2338)pos, base);
            pos = center.method_25503().method_10104(moveX, -point.x).method_10104(moveY, point.y);
            world.method_8501((class_2338)pos, base);
            pos = center.method_25503().method_10104(moveX, point.x).method_10104(moveY, -point.y);
            world.method_8501((class_2338)pos, base);
            pos = center.method_25503().method_10104(moveX, -point.x).method_10104(moveY, -point.y);
            world.method_8501((class_2338)pos, base);
        });
    }

    public static boolean checkIsAreaValid(class_1937 world, class_2338 pos, class_2350.class_2351 axis) {
        if (pos.method_10264() >= world.method_31605() - 1) {
            return false;
        }
        if (!PortalBuilder.isBaseValid(world, pos, axis)) {
            return false;
        }
        return PortalBuilder.checkArea(world, pos, axis);
    }

    private static boolean isBaseValid(class_1937 world, class_2338 pos, class_2350.class_2351 axis) {
        boolean solid = true;
        if (axis.equals((Object)class_2350.class_2351.field_11048)) {
            pos = pos.method_10074().method_10069(0, 0, -3);
            for (int i = 0; i < 7; ++i) {
                class_2338 checkPos = pos.method_10069(0, 0, i);
                class_2680 state = world.method_8320(checkPos);
                solid &= PortalBuilder.validBlock(world, checkPos, state);
            }
        } else {
            pos = pos.method_10074().method_10069(-3, 0, 0);
            for (int i = 0; i < 7; ++i) {
                class_2338 checkPos = pos.method_10069(i, 0, 0);
                class_2680 state = world.method_8320(checkPos);
                solid &= PortalBuilder.validBlock(world, checkPos, state);
            }
        }
        return solid;
    }

    private static boolean validBlock(class_1937 world, class_2338 pos, class_2680 state) {
        return state.method_26212((class_1922)world, pos) && state.method_26234((class_1922)world, pos);
    }

    public static boolean checkArea(class_1937 world, class_2338 center, class_2350.class_2351 axis) {
        class_2350 moveDir = class_2350.class_2351.field_11048 == axis ? class_2350.field_11043 : class_2350.field_11034;
        for (class_2338 checkPos : class_2338.method_10097((class_2338)center.method_10093(moveDir.method_10170()), (class_2338)center.method_10093(moveDir.method_10160()))) {
            for (Point point : PORTAL_POSITIONS) {
                class_2338.class_2339 pos = checkPos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
                class_2680 state = world.method_8320((class_2338)pos);
                if (PortalBuilder.isStateInvalid(state)) {
                    return false;
                }
                pos = checkPos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y);
                state = world.method_8320((class_2338)pos);
                if (!PortalBuilder.isStateInvalid(state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isStateInvalid(class_2680 state) {
        if (!state.method_26227().method_15769()) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((class_2680)state) == false;
    }

    public Optional<class_5459.class_5460> findPortalAround(class_2338 blockPos, class_2784 worldBorder) {
        class_4153 poiManager = this.targetLevel.method_19494();
        poiManager.method_22439((class_4538)this.targetLevel, blockPos, SPIRAL_SEARCH_RADIUS);
        Optional oPos = EndPoiTypes.ETERNAL_PORTAL.findPoiAround(this.targetLevel, blockPos, SPIRAL_SEARCH_RADIUS, worldBorder);
        return oPos.map(poiPos -> {
            this.targetLevel.method_14178().method_17297(class_3230.field_19280, new class_1923(poiPos), 3, poiPos);
            class_2680 blockState = this.targetLevel.method_8320(poiPos);
            return class_5459.method_30574((class_2338)poiPos, (class_2350.class_2351)((class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529)), (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, bp -> this.targetLevel.method_8320(bp) == blockState);
        });
    }

    public static class_2338 getStartingPos(class_1937 sourceLevel, class_1937 targetLevel, class_1297 entity, class_2784 worldBorder) {
        double dimensionScale = class_2874.method_31109((class_2874)sourceLevel.method_8597(), (class_2874)targetLevel.method_8597());
        return worldBorder.method_39538(entity.method_23317() * dimensionScale, entity.method_23318(), entity.method_23321() * dimensionScale);
    }

    public Optional<class_2338> createPortal(class_2338 startPosition, class_2350.class_2351 axis, int portalID) {
        class_2350 portalDirection = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        double d = -1.0;
        class_2338 centerPos = null;
        double e = -1.0;
        class_2338 blockPos3 = null;
        class_2784 worldBorder = this.targetLevel.method_8621();
        int maxHeight = Math.min(this.targetLevel.method_31600(), this.targetLevel.method_31607() + this.targetLevel.method_32819()) - 1;
        class_2338.class_2339 currentPos = startPosition.method_25503();
        for (class_2338.class_2339 testPosition : class_2338.method_30512((class_2338)startPosition, (int)SPIRAL_SEARCH_RADIUS, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
            int levelHeight = Math.min(maxHeight, this.targetLevel.method_8624(class_2902.class_2903.field_13197, testPosition.method_10263(), testPosition.method_10260()));
            if (!worldBorder.method_11952((class_2338)testPosition) || !worldBorder.method_11952((class_2338)testPosition.method_10104(portalDirection, 1))) continue;
            testPosition.method_10104(portalDirection.method_10153(), 1);
            for (int yy = levelHeight; yy >= this.targetLevel.method_31607(); --yy) {
                int n;
                testPosition.method_33098(yy);
                if (!this.canPortalReplaceBlock((class_2338)testPosition)) continue;
                int startY = yy;
                while (yy > this.targetLevel.method_31607() && this.canPortalReplaceBlock((class_2338)testPosition.method_10098(class_2350.field_11033))) {
                    --yy;
                }
                if (yy + 4 > maxHeight || (n = startY - yy) > 0 && n < 3) continue;
                testPosition.method_33098(yy);
                if (!this.canHostFrame((class_2338)testPosition, currentPos, portalDirection, 0)) continue;
                double f = startPosition.method_10262((class_2382)testPosition);
                if (this.canHostFrame((class_2338)testPosition, currentPos, portalDirection, -1) && this.canHostFrame((class_2338)testPosition, currentPos, portalDirection, 1) && (d == -1.0 || d > f)) {
                    d = f;
                    centerPos = testPosition.method_10062();
                }
                if (d != -1.0 || e != -1.0 && !(e > f)) continue;
                e = f;
                blockPos3 = testPosition.method_10062();
            }
        }
        if (d == -1.0 && e != -1.0) {
            centerPos = blockPos3;
            d = e;
        }
        if (d == -1.0) {
            int p = maxHeight - 9;
            int o = Math.max(this.targetLevel.method_31607() - -1, 70);
            if (p < o) {
                return Optional.empty();
            }
            centerPos = new class_2338(startPosition.method_10263(), class_3532.method_15340((int)startPosition.method_10264(), (int)o, (int)p), startPosition.method_10260()).method_10062();
            if (!worldBorder.method_11952(centerPos)) {
                return Optional.empty();
            }
        }
        this.buildPortal(portalDirection, centerPos, portalID);
        return Optional.of(centerPos.method_10062());
    }

    private void buildPortal(class_2350 portalDirection, class_2338 centerPos, int portalID) {
        class_2350.class_2351 portalAxis = class_2350.class_2351.field_11048 == portalDirection.method_10166() ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        PortalBuilder.generatePortal((class_1937)this.targetLevel, centerPos, portalAxis, portalID);
    }

    private int getPortalID(class_2338 portalEntrancePos) {
        class_2680 currentState = this.sourceLevel.method_8320(portalEntrancePos);
        int portalID = currentState.method_28498((class_2769)EndPortalBlock.PORTAL) ? (Integer)currentState.method_11654((class_2769)EndPortalBlock.PORTAL) : -1;
        return portalID;
    }

    private boolean canPortalReplaceBlock(class_2338 currentPos) {
        class_2680 blockState = this.targetLevel.method_8320(currentPos);
        return blockState.method_45474() && blockState.method_26227().method_15769();
    }

    private boolean canHostFrame(class_2338 pos, class_2338.class_2339 currentPos, class_2350 direction, int widthScale) {
        class_2350 orthogonalDir = direction.method_10170();
        for (int x = -1; x < 3; ++x) {
            for (int y = -1; y < 4; ++y) {
                currentPos.method_25504((class_2382)pos, direction.method_10148() * x + orthogonalDir.method_10148() * widthScale, y, direction.method_10165() * x + orthogonalDir.method_10165() * widthScale);
                if (y < 0 && !this.targetLevel.method_8320((class_2338)currentPos).method_51367()) {
                    return false;
                }
                if (y < 0 || this.canPortalReplaceBlock((class_2338)currentPos)) continue;
                return false;
            }
        }
        return true;
    }
}

