/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.SulphurCrystalBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.util.GlobalState;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class SulphuricLakeFeature
extends DefaultFeature {
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(15152L);

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_2338 blockPos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        blockPos = SulphuricLakeFeature.getPosOnSurfaceWG((class_5281)world, (class_2338)blockPos);
        if (blockPos.method_10264() < 57) {
            return false;
        }
        class_5819 random = featureConfig.method_33654();
        class_2338.class_2339 POS = GlobalState.stateForThread().POS;
        double radius = MHelper.randRange((double)10.0, (double)20.0, (class_5819)random);
        int dist2 = MHelper.floor((double)(radius * 1.5));
        int minX = blockPos.method_10263() - dist2;
        int maxX = blockPos.method_10263() + dist2;
        int minZ = blockPos.method_10260() - dist2;
        int maxZ = blockPos.method_10260() + dist2;
        HashSet brimstone = Sets.newHashSet();
        for (int x = minX; x <= maxX; ++x) {
            POS.method_33097(x);
            int x2 = x - blockPos.method_10263();
            x2 *= x2;
            for (int z = minZ; z <= maxZ; ++z) {
                POS.method_33099(z);
                int z2 = z - blockPos.method_10260();
                z2 *= z2;
                double r = radius * (NOISE.eval((double)x * 0.2, (double)z * 0.2) * 0.25 + 0.75);
                double r2 = r * 1.5;
                r *= r;
                r2 *= r2;
                int dist = x2 + z2;
                if ((double)dist <= r) {
                    class_2338 offseted;
                    POS.method_33098(SulphuricLakeFeature.getYOnSurface((class_5281)world, (int)x, (int)z) - 1);
                    if (!world.method_8320((class_2338)POS).method_26164(CommonBlockTags.GEN_END_STONES)) continue;
                    if (this.isBorder(world, (class_2338)POS)) {
                        if (random.method_43048(8) > 0) {
                            brimstone.add(POS.method_10062());
                            if (!random.method_43056()) continue;
                            brimstone.add(POS.method_10074());
                            if (!random.method_43056()) continue;
                            brimstone.add(POS.method_10087(2));
                            continue;
                        }
                        if (!this.isAbsoluteBorder(world, (class_2338)POS)) {
                            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)POS, (class_2248)class_2246.field_10382);
                            world.method_39281((class_2338)POS, (class_3611)class_3612.field_15910, 0);
                            brimstone.add(POS.method_10074());
                            if (!random.method_43056()) continue;
                            brimstone.add(POS.method_10087(2));
                            if (!random.method_43056()) continue;
                            brimstone.add(POS.method_10087(3));
                            continue;
                        }
                        brimstone.add(POS.method_10062());
                        if (!random.method_43056()) continue;
                        brimstone.add(POS.method_10074());
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)POS, (class_2248)class_2246.field_10382);
                    brimstone.remove(POS);
                    for (class_2350 dir : BlocksHelper.HORIZONTAL) {
                        offseted = POS.method_10093(dir);
                        if (!world.method_8320(offseted).method_26164(CommonBlockTags.GEN_END_STONES)) continue;
                        brimstone.add(offseted);
                    }
                    if (this.isDeepWater(world, (class_2338)POS)) {
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)POS.method_10098(class_2350.field_11033), (class_2248)class_2246.field_10382);
                        brimstone.remove(POS);
                        for (class_2350 dir : BlocksHelper.HORIZONTAL) {
                            offseted = POS.method_10093(dir);
                            if (!world.method_8320(offseted).method_26164(CommonBlockTags.GEN_END_STONES)) continue;
                            brimstone.add(offseted);
                        }
                    }
                    brimstone.add(POS.method_10074());
                    if (!random.method_43056()) continue;
                    brimstone.add(POS.method_10087(2));
                    if (!random.method_43056()) continue;
                    brimstone.add(POS.method_10087(3));
                    continue;
                }
                if (!((double)dist < r2)) continue;
                POS.method_33098(SulphuricLakeFeature.getYOnSurface((class_5281)world, (int)x, (int)z) - 1);
                if (!world.method_8320((class_2338)POS).method_26164(CommonBlockTags.GEN_END_STONES)) continue;
                brimstone.add(POS.method_10062());
                if (!random.method_43056()) continue;
                brimstone.add(POS.method_10074());
                if (!random.method_43056()) continue;
                brimstone.add(POS.method_10087(2));
            }
        }
        brimstone.forEach(bpos -> this.placeBrimstone(world, (class_2338)bpos, random));
        return true;
    }

    private boolean isBorder(class_5281 world, class_2338 pos) {
        int y = pos.method_10264() + 1;
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((class_5281)world, (int)(pos.method_10263() + dir.method_10148()), (int)(pos.method_10260() + dir.method_10165())) >= y) continue;
            return true;
        }
        return false;
    }

    private boolean isAbsoluteBorder(class_5281 world, class_2338 pos) {
        int y = pos.method_10264() - 2;
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((class_5281)world, (int)(pos.method_10263() + dir.method_10148() * 3), (int)(pos.method_10260() + dir.method_10165() * 3)) >= y) continue;
            return true;
        }
        return false;
    }

    private boolean isDeepWater(class_5281 world, class_2338 pos) {
        int y = pos.method_10264() + 1;
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((class_5281)world, (int)(pos.method_10263() + dir.method_10148()), (int)(pos.method_10260() + dir.method_10165())) >= y && SulphuricLakeFeature.getYOnSurface((class_5281)world, (int)(pos.method_10263() + dir.method_10148() * 2), (int)(pos.method_10260() + dir.method_10165() * 2)) >= y && SulphuricLakeFeature.getYOnSurface((class_5281)world, (int)(pos.method_10263() + dir.method_10148() * 3), (int)(pos.method_10260() + dir.method_10165() * 3)) >= y) continue;
            return false;
        }
        return true;
    }

    private void placeBrimstone(class_5281 world, class_2338 pos, class_5819 random) {
        class_2680 state = this.getBrimstone(world, pos);
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)state);
        if (((Boolean)state.method_11654((class_2769)EndBlockProperties.ACTIVE)).booleanValue()) {
            this.makeShards(world, pos, random);
        }
    }

    private class_2680 getBrimstone(class_5281 world, class_2338 pos) {
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            if (!world.method_8320(pos.method_10093(dir)).method_27852(class_2246.field_10382)) continue;
            return (class_2680)EndBlocks.BRIMSTONE.method_9564().method_11657((class_2769)EndBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return EndBlocks.BRIMSTONE.method_9564();
    }

    private void makeShards(class_5281 world, class_2338 pos, class_5819 random) {
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            class_2338 side;
            if (random.method_43048(16) != 0 || !world.method_8320(side = pos.method_10093(dir)).method_27852(class_2246.field_10382)) continue;
            class_2680 state = (class_2680)((class_2680)((class_2680)EndBlocks.SULPHUR_CRYSTAL.method_9564().method_11657((class_2769)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)SulphurCrystalBlock.FACING, (Comparable)dir)).method_11657((class_2769)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(random.method_43048(3)));
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)side, (class_2680)state);
        }
    }
}

