/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.resources.bbmodel;

import com.google.gson.JsonObject;
import immersive_aircraft.Main;
import immersive_aircraft.resources.bbmodel.BBAnimation;
import immersive_aircraft.resources.bbmodel.BBBone;
import immersive_aircraft.resources.bbmodel.BBCube;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBMeta;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.resources.bbmodel.BBTexture;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2960;

public class BBModel {
    public final BBMeta meta;
    public final List<BBTexture> textures = new LinkedList<BBTexture>();
    public final LinkedList<BBObject> root;
    public final HashMap<String, BBObject> objects;
    public final HashMap<String, BBObject> objectsByName;
    public final List<BBAnimation> animations = new LinkedList<BBAnimation>();
    public final float textureWidth;
    public final float textureHeight;
    public final class_2960 id;

    public BBModel(JsonObject model, class_2960 identifier) {
        this.meta = new BBMeta(model.get("meta"));
        this.root = new LinkedList();
        this.objects = new HashMap();
        this.objectsByName = new HashMap();
        this.id = identifier;
        JsonObject resolution = model.get("resolution").getAsJsonObject();
        this.textureWidth = resolution.getAsJsonPrimitive("width").getAsFloat();
        this.textureHeight = resolution.getAsJsonPrimitive("height").getAsFloat();
        model.get("textures").getAsJsonArray().forEach(element -> {
            BBTexture texture = new BBTexture(element.getAsJsonObject(), identifier);
            this.textures.add(texture);
        });
        model.get("elements").getAsJsonArray().forEach(element -> {
            String type = element.getAsJsonObject().get("type").getAsString();
            if (type.equals("cube")) {
                BBCube object = new BBCube(element.getAsJsonObject(), this);
                this.objects.put(object.uuid, object);
                this.objectsByName.put(object.name, object);
            } else if (type.equals("mesh")) {
                BBMesh object = new BBMesh(element.getAsJsonObject(), this);
                this.objects.put(object.uuid, object);
                this.objectsByName.put(object.name, object);
            } else {
                Main.LOGGER.warn("Unknown object type {}", (Object)type);
            }
        });
        model.get("outliner").getAsJsonArray().forEach(element -> {
            if (element.isJsonPrimitive()) {
                BBObject object = this.objects.get(element.getAsString());
                if (object != null) {
                    this.root.add(object);
                } else {
                    Main.LOGGER.warn("Object with uuid {} not found", (Object)element.getAsString());
                }
            } else {
                BBBone bone = new BBBone(element.getAsJsonObject(), this);
                this.root.add(bone);
                this.objects.put(bone.uuid, bone);
                this.objectsByName.put(bone.name, bone);
            }
        });
        if (model.has("animations")) {
            model.get("animations").getAsJsonArray().forEach(element -> {
                BBAnimation animation = new BBAnimation(element.getAsJsonObject());
                this.animations.add(animation);
            });
        }
    }

    public float getTextureWidth(BBTexture texture) {
        return this.meta.modelFormat.equals("free") ? (float)texture.uvWidth : this.textureWidth;
    }

    public float getTextureHeight(BBTexture texture) {
        return this.meta.modelFormat.equals("free") ? (float)texture.uvHeight : this.textureHeight;
    }

    public BBTexture getTexture(int id) {
        return id < this.textures.size() ? this.textures.get(id) : BBTexture.MISSING;
    }
}

