/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.event;

import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.ModMenuButtonWidget;
import com.terraformersmc.modmenu.gui.widget.UpdateCheckerTexturedButtonWidget;
import com.terraformersmc.modmenu.util.ModrinthUtil;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_7417;
import net.minecraft.class_8021;

public class ModMenuEventHandler {
    public static final class_2960 FABRIC_ICON_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/mods_button.png");
    private static class_304 MENU_KEY_BIND;

    public static void register() {
        MENU_KEY_BIND = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.modmenu.open_menu", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "key.categories.misc"));
        ClientTickEvents.END_CLIENT_TICK.register(ModMenuEventHandler::onClientEndTick);
        ScreenEvents.AFTER_INIT.register(ModMenuEventHandler::afterScreenInit);
    }

    public static void afterScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof class_442) {
            ModMenuEventHandler.afterTitleScreenInit(screen);
        }
    }

    private static void afterTitleScreenInit(class_437 screen) {
        List buttons = Screens.getButtons((class_437)screen);
        if (ModMenuConfig.MODIFY_TITLE_SCREEN.getValue()) {
            int modsButtonIndex = -1;
            int spacing = 24;
            int buttonsY = screen.field_22790 / 4 + 48;
            for (int i = 0; i < buttons.size(); ++i) {
                class_339 widget = (class_339)buttons.get(i);
                if (!(widget instanceof class_4185)) continue;
                class_4185 button2 = (class_4185)widget;
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC && button2.field_22764) {
                    ModMenuEventHandler.shiftButtons((class_8021)button2, modsButtonIndex == -1, 24);
                    if (modsButtonIndex == -1) {
                        buttonsY = button2.method_46427();
                    }
                }
                if (!ModMenuEventHandler.buttonHasText((class_8021)button2, "menu.online")) continue;
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.REPLACE_REALMS) {
                    buttons.set(i, new ModMenuButtonWidget(button2.method_46426(), button2.method_46427(), button2.method_25368(), button2.method_25364(), ModMenuApi.createModsButtonText(), screen));
                    continue;
                }
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                    button2.method_25358(98);
                }
                modsButtonIndex = i + 1;
                if (!button2.field_22764) continue;
                buttonsY = button2.method_46427();
            }
            if (modsButtonIndex != -1) {
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 - 100, buttonsY + 24, 200, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 + 2, buttonsY, 98, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.ICON) {
                    buttons.add(modsButtonIndex, new UpdateCheckerTexturedButtonWidget(screen.field_22789 / 2 + 104, buttonsY, 20, 20, 0, 0, 20, FABRIC_ICON_BUTTON_LOCATION, 32, 64, button -> class_310.method_1551().method_1507((class_437)new ModsScreen(screen)), ModMenuApi.createModsButtonText()));
                }
            }
        }
        ModrinthUtil.triggerV2DeprecatedToast();
    }

    private static void onClientEndTick(class_310 client) {
        while (MENU_KEY_BIND.method_1436()) {
            client.method_1507((class_437)new ModsScreen(client.field_1755));
        }
    }

    public static boolean buttonHasText(class_8021 widget, String translationKey) {
        if (widget instanceof class_4185) {
            class_4185 button = (class_4185)widget;
            class_2561 text = button.method_25369();
            class_7417 textContent = text.method_10851();
            return textContent instanceof class_2588 && ((class_2588)textContent).method_11022().equals(translationKey);
        }
        return false;
    }

    public static void shiftButtons(class_8021 widget, boolean shiftUp, int spacing) {
        class_339 button;
        if (shiftUp) {
            widget.method_46419(widget.method_46427() - spacing / 2);
        } else if (!(widget instanceof class_339) || !(button = (class_339)widget).method_25369().equals(class_442.field_32271)) {
            widget.method_46419(widget.method_46427() + spacing / 2);
        }
    }
}

