/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.WithDim;

public class ProtoPortalSide {
    @NotNull
    public class_5321<class_1937> dimension;
    @NotNull
    public class_243 leftBottom;
    @Nullable
    public class_243 rightBottom;
    @Nullable
    public class_243 leftTop;

    public ProtoPortalSide(@NotNull class_5321<class_1937> dimension, @NotNull class_243 leftBottom) {
        this.leftBottom = leftBottom;
        this.dimension = dimension;
    }

    public ProtoPortalSide copy() {
        ProtoPortalSide newPortal = new ProtoPortalSide(this.dimension, this.leftBottom);
        newPortal.rightBottom = this.rightBottom;
        newPortal.leftTop = this.leftTop;
        return newPortal;
    }

    public class_243 getHorizontalAxis() {
        assert (this.rightBottom != null);
        return this.rightBottom.method_1020(this.leftBottom);
    }

    public class_243 getVerticalAxis() {
        assert (this.leftTop != null);
        return this.leftTop.method_1020(this.leftBottom);
    }

    public class_243 getNormal() {
        return this.getHorizontalAxis().method_1036(this.getVerticalAxis()).method_1029();
    }

    public double getWidth() {
        return this.getHorizontalAxis().method_1033();
    }

    public double getHeight() {
        return this.getVerticalAxis().method_1033();
    }

    public double getHeightDivWidth() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width == 0.0) {
            return 0.0;
        }
        return height / width;
    }

    @Nullable
    public ProtoPortalSide undo() {
        if (this.leftTop != null) {
            this.leftTop = null;
            return this;
        }
        if (this.rightBottom != null) {
            this.rightBottom = null;
            return this;
        }
        return null;
    }

    public boolean isComplete() {
        return this.leftTop != null;
    }

    @Nullable
    public WithDim<Plane> getCursorConstraintPlane() {
        if (this.isComplete()) {
            return null;
        }
        if (this.rightBottom == null) {
            return null;
        }
        return new WithDim(this.dimension, (Object)new Plane(this.leftBottom, this.getHorizontalAxis()));
    }

    @Nullable
    public WithDim<Circle> getCursorConstraintCircle(double heightDivWidth) {
        if (this.isComplete()) {
            return null;
        }
        if (this.rightBottom == null) {
            return null;
        }
        WithDim<Plane> plane = this.getCursorConstraintPlane();
        Validate.notNull(plane);
        class_243 horizontalAxis = this.getHorizontalAxis();
        double width = horizontalAxis.method_1033();
        double constraintHeight = width * heightDivWidth;
        return new WithDim(this.dimension, (Object)new Circle((Plane)plane.value(), this.leftBottom, constraintHeight));
    }

    public boolean isValidPlacement(@Nullable Double heightDivWidth) {
        if (this.rightBottom != null) {
            double height;
            double width = this.getHorizontalAxis().method_1033();
            if (width < 0.001 || width > 64.001) {
                return false;
            }
            if (this.leftTop != null ? (height = this.getVerticalAxis().method_1033()) < 0.001 || height > 64.001 : heightDivWidth != null && ((height = width * heightDivWidth) < 0.001 || height > 64.001)) {
                return false;
            }
        }
        return true;
    }

    public void placeCursor(class_243 pos) {
        if (this.rightBottom == null) {
            this.rightBottom = pos;
        } else if (this.leftTop == null) {
            this.leftTop = pos;
        } else {
            throw new IllegalStateException();
        }
    }

    public UnilateralPortalState toUnilateralPortalState() {
        Validate.isTrue((boolean)this.isComplete());
        class_243 horizontalAxis = this.getHorizontalAxis();
        class_243 verticalAxis = this.getVerticalAxis();
        return new UnilateralPortalState(this.dimension, this.leftBottom.method_1019(horizontalAxis.method_1021(0.5)).method_1019(verticalAxis.method_1021(0.5)), DQuaternion.fromFacingVecs((class_243)horizontalAxis.method_1029(), (class_243)verticalAxis.method_1029()), horizontalAxis.method_1033(), verticalAxis.method_1033());
    }
}

