/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlock;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorMode;
import org.antarcticgardens.cna.content.electricity.network.ElectricalNetwork;
import org.antarcticgardens.cna.content.electricity.network.NetworkEnergyStorage;
import org.antarcticgardens.cna.content.electricity.wire.WireType;
import org.antarcticgardens.esl.energy.EnergyStorage;

public class ElectricalConnectorBlockEntity
extends class_2586
implements IHaveGoggleInformation {
    private final Map<ElectricalConnectorBlockEntity, WireType> connectors = new HashMap<ElectricalConnectorBlockEntity, WireType>();
    private final Map<class_2338, WireType> connectorPositions = new HashMap<class_2338, WireType>();
    private ElectricalNetwork network;
    private final NetworkEnergyStorage storage = new NetworkEnergyStorage(this, null);
    private boolean connectionsInitialized = false;
    boolean needsInstanceUpdate = true;

    public ElectricalConnectorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        EnergyStorage.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, (class_2591)((class_2591)CNABlockEntityTypes.ELECTRICAL_CONNECTOR.get()));
    }

    protected void method_11007(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_2338, WireType> e : this.connectorPositions.entrySet()) {
            class_2487 compound = new class_2487();
            compound.method_10566("position", (class_2520)NBTHelper.writeVec3i((class_2382)((class_2382)e.getKey())));
            compound.method_10566("wire", (class_2520)class_2519.method_23256((String)e.getValue().name()));
            list.add((Object)compound);
        }
        nbt.method_10566("connections", (class_2520)list);
        super.method_11007(nbt);
    }

    public void method_11014(class_2487 nbt) {
        class_2499 list = nbt.method_10554("connections", 10);
        this.connectorPositions.clear();
        for (class_2520 listTag : (class_2520[])list.toArray((Object[])new class_2520[0])) {
            class_2487 ct;
            if (!(listTag instanceof class_2487) || !(ct = (class_2487)listTag).method_10545("position") || !ct.method_10545("wire")) continue;
            class_2338 pos = new class_2338(NBTHelper.readVec3i((class_2499)((class_2499)ct.method_10580("position"))));
            WireType wire = WireType.valueOf(ct.method_10558("wire"));
            this.connectorPositions.put(pos, wire);
        }
        this.needsInstanceUpdate = true;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public Map<class_2338, WireType> getConnectorPositions() {
        return Collections.unmodifiableMap(this.connectorPositions);
    }

    public class_2338 getSupportingBlockPos() {
        return this.method_11016().method_10093(((class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525)).method_10153());
    }

    protected void serverTick() {
        if (this.network == null) {
            this.setNetwork(new ElectricalNetwork(this));
        }
        if (!this.connectionsInitialized) {
            this.updateConnections();
            this.connectionsInitialized = true;
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.connector_info", (Object[])new Object[0]).style(class_124.field_1068).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.mode", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        ElectricalConnectorMode mode = (ElectricalConnectorMode)((Object)this.method_11010().method_11654(ElectricalConnectorBlock.MODE));
        CreateLang.translate((String)("tooltip.create_new_age.connector_mode." + mode.method_15434()), (Object[])new Object[0]).style(class_124.field_1075).forGoggles(tooltip, 1);
        return true;
    }

    protected void neighborChanged() {
        if (this.network != null) {
            this.network.updateConsumersAndSources();
        }
    }

    private void updateConnections() {
        for (Map.Entry<class_2338, WireType> e : this.connectorPositions.entrySet()) {
            class_2586 class_25862 = this.method_10997().method_8321(e.getKey());
            if (!(class_25862 instanceof ElectricalConnectorBlockEntity)) continue;
            ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)class_25862;
            this.connect(connector, e.getValue());
        }
        this.needsInstanceUpdate = true;
    }

    protected void remove(class_1937 level) {
        if (!level.method_8608()) {
            this.network.destroy();
        }
        for (Map.Entry<ElectricalConnectorBlockEntity, WireType> e : this.connectors.entrySet()) {
            e.getKey().disconnect(this);
            e.getKey().updateConnections();
            e.getKey().method_5431();
            if (!(level instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14178().method_14128(e.getKey().method_11016());
            class_1264.method_17349((class_1937)level, (class_2338)this.method_11016(), (class_2371)class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{e.getValue().getDroppedItem()}));
        }
    }

    public void connect(ElectricalConnectorBlockEntity entity, WireType wireType) {
        entity.connectWithoutNetworking(this, wireType);
        this.connectWithoutNetworking(entity, wireType);
        entity.method_5431();
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.network.addNode(entity);
            serverLevel.method_14178().method_14128(entity.method_11016());
            serverLevel.method_14178().method_14128(this.method_11016());
        }
    }

    private void connectWithoutNetworking(ElectricalConnectorBlockEntity entity, WireType wireType) {
        if (!this.connectors.containsKey((Object)entity)) {
            this.connectors.put(entity, wireType);
        }
        if (!this.connectorPositions.containsKey(entity.method_11016())) {
            this.connectorPositions.put(entity.method_11016(), wireType);
        }
    }

    public void disconnect(ElectricalConnectorBlockEntity entity) {
        this.connectors.remove((Object)entity);
        this.connectorPositions.remove(entity.method_11016());
    }

    public boolean isConnected(class_2338 pos) {
        return this.connectorPositions.containsKey(pos);
    }

    public Map<ElectricalConnectorBlockEntity, WireType> getConnectedConnectors() {
        return Collections.unmodifiableMap(this.connectors);
    }

    public void setNetwork(ElectricalNetwork network) {
        this.network = network;
        this.storage.setNetwork(network);
    }

    public ElectricalNetwork getNetwork() {
        return this.network;
    }
}

