/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear.reactor.rod;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.config.CommonConfig;
import org.antarcticgardens.cna.content.heat.HeatBlockEntity;
import org.antarcticgardens.cna.content.nuclear.NuclearUtil;
import org.antarcticgardens.cna.content.nuclear.reactor.rod.ReactorRodBlock;
import org.jetbrains.annotations.Nullable;

public class ReactorRodBlockEntity
extends class_2586
implements HeatBlockEntity,
IHaveGoggleInformation {
    int twoSeconds = 0;
    private boolean working;
    public float heat = 0.0f;
    public int fuel = 0;

    public ReactorRodBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        this.working = (Boolean)blockState.method_11654((class_2769)ReactorRodBlock.ACTIVE);
    }

    public void tick(class_2338 pos, class_1937 world, class_2680 state) {
        CommonConfig common = CNAConfig.getCommon();
        double multiplier = (Double)common.overheatingMultiplier.get();
        if (multiplier > 0.0 && (double)this.heat > 16000.0 * multiplier) {
            this.heat = (float)((double)this.heat - (Double)common.nuclearReactorRodHeatLoss.get());
            this.method_5431();
            HeatBlockEntity.handleOverheat(this, () -> world.method_8652(pos, CNABlocks.CORIUM.getDefaultState(), 3));
        }
        ++this.twoSeconds;
        if (this.twoSeconds > 40) {
            ReactorRodBlockEntity.transferAroundRodOnly(this);
            this.working = (Boolean)state.method_11654((class_2769)ReactorRodBlock.ACTIVE);
            this.twoSeconds = 0;
            if (this.working) {
                NuclearUtil.createRadiation(8, world, pos);
            }
        }
        if (this.fuel > 0) {
            --this.fuel;
            if (!this.working) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ReactorRodBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                this.working = true;
            }
            this.heat = (float)((double)this.heat + (Double)common.nuclearReactorRodHeat.get());
            this.method_5431();
        } else if (this.working) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ReactorRodBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            this.working = false;
            this.method_5431();
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        HeatBlockEntity.addToolTips(this, tooltip);
        return true;
    }

    static <T extends class_2586> void transferAroundRodOnly(T self) {
        if (self.method_10997() == null) {
            return;
        }
        float totalToAverage = ((HeatBlockEntity)self).getHeat();
        int totalBlocks = 1;
        HeatBlockEntity[] setters = new HeatBlockEntity[6];
        for (int i = 0; i < 6; ++i) {
            ReactorRodBlockEntity hbe;
            class_2350 value = class_2350.values()[i];
            class_2586 entity = self.method_10997().method_8321(self.method_11016().method_10093(value));
            if (!(entity instanceof ReactorRodBlockEntity) || !(hbe = (ReactorRodBlockEntity)entity).canAdd(value)) continue;
            setters[i] = hbe;
            totalToAverage += hbe.getHeat();
            ++totalBlocks;
        }
        HeatBlockEntity.average(self, totalToAverage, totalBlocks, setters);
    }

    @Override
    public float maxHeat() {
        return 26000.0f;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.heat = tag.method_10583("heat");
        this.fuel = tag.method_10550("fuel");
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10548("heat", this.heat);
        tag.method_10569("fuel", this.fuel);
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.method_5431();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.method_5431();
    }
}

