/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe.fabric;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class BlockTypeSwapIngredientImpl<T extends BlockType>
implements CustomIngredient,
BlockTypeSwapIngredient {
    private static final class_2960 ID = Moonlight.res("block_type_swap");
    private final class_1856 inner;
    private final T fromType;
    private final T toType;
    private final BlockTypeRegistry<T> registry;
    private List<class_1799> items;
    public static CustomIngredientSerializer<BlockTypeSwapIngredientImpl<?>> SERIALIZER = new CustomIngredientSerializer<BlockTypeSwapIngredientImpl<?>>(){

        public class_2960 getIdentifier() {
            return ID;
        }

        public BlockTypeSwapIngredientImpl<?> read(JsonObject json) {
            BlockTypeRegistry<?> reg = BlockSetInternal.getRegistry(json.get("block_type").getAsString());
            Object from = reg.getFromNBT(json.get("from").getAsString());
            Object to = reg.getFromNBT(json.get("to").getAsString());
            class_1856 ing = class_1856.method_52177((JsonElement)json.get("ingredient"));
            return new BlockTypeSwapIngredientImpl(ing, from, to, reg);
        }

        public void write(JsonObject json, BlockTypeSwapIngredientImpl<?> ingredient) {
            json.addProperty("block_type", ingredient.registry.typeName());
            json.addProperty("from", ((BlockType)ingredient.fromType).getId().toString());
            json.addProperty("to", ((BlockType)ingredient.toType).getId().toString());
            json.add("ingredient", ingredient.inner.method_8089());
        }

        public BlockTypeSwapIngredientImpl<?> read(class_2540 buf) {
            BlockTypeRegistry<?> reg = BlockSetInternal.getRegistry(buf.method_19772());
            Object from = reg.getFromNBT(buf.method_19772());
            Object to = reg.getFromNBT(buf.method_19772());
            class_1856 ing = class_1856.method_8086((class_2540)buf);
            return new BlockTypeSwapIngredientImpl(ing, from, to, reg);
        }

        public void write(class_2540 buf, BlockTypeSwapIngredientImpl<?> ing) {
            buf.method_10814(ing.registry.typeName());
            buf.method_10814(((BlockType)ing.fromType).getId().toString());
            buf.method_10814(((BlockType)ing.toType).getId().toString());
            ing.inner.method_8088(buf);
        }
    };

    public BlockTypeSwapIngredientImpl(class_1856 inner, T fromType, T toType, BlockTypeRegistry<T> reg) {
        Preconditions.checkNotNull(fromType, (Object)"From block type cannot be null");
        Preconditions.checkNotNull(toType, (Object)"To block type cannot be null");
        this.inner = inner;
        this.fromType = fromType;
        this.toType = toType;
        this.registry = reg;
    }

    @Override
    public class_1856 getInner() {
        return this.inner;
    }

    public boolean test(class_1799 stack) {
        if (stack != null) {
            for (class_1799 itemStack : this.getMatchingStacks()) {
                if (!itemStack.method_31574(stack.method_7909())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<class_1799> convertItems(List<class_1799> toConvert) {
        class_1799 it;
        T type;
        ArrayList<class_1799> newItems = new ArrayList<class_1799>();
        boolean success = false;
        Iterator<class_1799> iterator = toConvert.iterator();
        while (iterator.hasNext() && (type = this.registry.getBlockTypeOf((class_1935)(it = iterator.next()).method_7909())) == this.fromType) {
            class_1792 newItem = BlockType.changeItemType(it.method_7909(), this.fromType, this.toType);
            if (newItem == null) continue;
            newItems.add(new class_1799((class_1935)newItem));
            success = true;
        }
        if (!success) {
            newItems.addAll(toConvert);
        }
        return newItems;
    }

    public List<class_1799> getMatchingStacks() {
        if (this.items == null) {
            class_1799[] original = this.inner.method_8105();
            this.items = this.convertItems(Arrays.asList(original));
        }
        return this.items;
    }

    public boolean requiresTesting() {
        return this.inner.requiresTesting();
    }

    public CustomIngredientSerializer<BlockTypeSwapIngredientImpl<?>> getSerializer() {
        return SERIALIZER;
    }

    public static <T extends BlockType> class_1856 create(class_1856 original, T from, T to) {
        return new BlockTypeSwapIngredientImpl<T>(original, from, to, from.getRegistry()).toVanilla();
    }

    public static void init() {
        CustomIngredientSerializer.register(SERIALIZER);
    }
}

