/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3542;

public enum BarrelMaterial implements class_3542
{
    SIDE("side", MaterialModelPart.CORE, new BarrelMaterial[0]),
    SIDE_TRIM("side_trim", MaterialModelPart.TRIM, new BarrelMaterial[0]),
    BOTTOM("bottom", MaterialModelPart.CORE, new BarrelMaterial[0]),
    BOTTOM_TRIM("bottom_trim", MaterialModelPart.TRIM, new BarrelMaterial[0]),
    TOP("top", MaterialModelPart.CORE, new BarrelMaterial[0]),
    TOP_TRIM("top_trim", MaterialModelPart.TRIM, new BarrelMaterial[0]),
    TOP_INNER_TRIM("top_inner_trim", MaterialModelPart.TRIM, new BarrelMaterial[0]),
    ALL("all", MaterialModelPart.BOTH, SIDE, SIDE_TRIM, BOTTOM, BOTTOM_TRIM, TOP, TOP_TRIM, TOP_INNER_TRIM),
    ALL_TRIM("all_trim", MaterialModelPart.TRIM, SIDE_TRIM, BOTTOM_TRIM, TOP_TRIM, TOP_INNER_TRIM),
    ALL_BUT_TRIM("all_but_trim", MaterialModelPart.CORE, SIDE, BOTTOM, TOP),
    TOP_ALL("top_all", MaterialModelPart.BOTH, TOP, TOP_TRIM, TOP_INNER_TRIM),
    SIDE_ALL("side_all", MaterialModelPart.BOTH, SIDE, SIDE_TRIM),
    BOTTOM_ALL("bottom_all", MaterialModelPart.BOTH, BOTTOM, BOTTOM_TRIM);

    private final String name;
    private MaterialModelPart materialModelPart;
    private final BarrelMaterial[] children;
    private static final Map<String, BarrelMaterial> NAME_VALUES;

    private BarrelMaterial(String name, MaterialModelPart materialModelPart, BarrelMaterial ... children) {
        this.name = name;
        this.materialModelPart = materialModelPart;
        this.children = children;
    }

    public MaterialModelPart getMaterialModelPart() {
        return this.materialModelPart;
    }

    public String method_15434() {
        return this.name;
    }

    public BarrelMaterial[] getChildren() {
        BarrelMaterial[] barrelMaterialArray;
        if (this.children.length > 0) {
            barrelMaterialArray = this.children;
        } else {
            BarrelMaterial[] barrelMaterialArray2 = new BarrelMaterial[1];
            barrelMaterialArray = barrelMaterialArray2;
            barrelMaterialArray2[0] = this;
        }
        return barrelMaterialArray;
    }

    public boolean isLeaf() {
        return this.children.length == 0;
    }

    public static BarrelMaterial fromName(String name) {
        return NAME_VALUES.getOrDefault(name, SIDE);
    }

    public static List<BarrelMaterial> getFillFromDefaults(BarrelMaterial material) {
        return switch (material) {
            case SIDE -> List.of(BOTTOM, TOP, TOP_INNER_TRIM);
            case SIDE_TRIM -> List.of(BOTTOM_TRIM, TOP_TRIM);
            case BOTTOM -> List.of(SIDE, TOP, TOP_INNER_TRIM);
            case BOTTOM_TRIM -> List.of(SIDE_TRIM, TOP_TRIM);
            case TOP -> List.of(TOP_INNER_TRIM, SIDE, BOTTOM);
            case TOP_TRIM -> List.of(SIDE_TRIM, BOTTOM_TRIM);
            case TOP_INNER_TRIM -> List.of(TOP_TRIM, SIDE_TRIM, BOTTOM_TRIM);
            default -> List.of();
        };
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BarrelMaterial value : BarrelMaterial.values()) {
            builder.put((Object)value.method_15434(), (Object)value);
        }
        NAME_VALUES = builder.build();
    }

    public static enum MaterialModelPart {
        BOTH,
        TRIM,
        CORE;

    }
}

