/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_747;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.particle.CustomTintTerrainParticleData;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;

public class ShulkerBoxBlock
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final class_2754<class_2350> FACING = class_2318.field_10927;
    private static final class_265 ITEM_ENTITY_COLLISION_SHAPE = ShulkerBoxBlock.method_9541((double)0.05, (double)0.05, (double)0.05, (double)15.95, (double)15.95, (double)15.95);

    public ShulkerBoxBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        this(numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier, 2.0f);
    }

    public ShulkerBoxBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, float explosionResistance) {
        super(ShulkerBoxBlock.getProperties(explosionResistance), numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
    }

    private static class_4970.class_2251 getProperties(float explosionResistance) {
        class_4970.class_4973 statePredicate = (state, blockGetter, pos) -> {
            class_2586 blockentity = blockGetter.method_8321(pos);
            if (!(blockentity instanceof ShulkerBoxBlockEntity)) {
                return true;
            }
            ShulkerBoxBlockEntity shulkerboxblockentity = (ShulkerBoxBlockEntity)blockentity;
            return shulkerboxblockentity.isClosed();
        };
        return class_4970.class_2251.method_9637().method_9629(2.0f, explosionResistance).method_9624().method_22488().method_26243(statePredicate).method_26245(statePredicate).method_50012(class_3619.field_15971).method_51517(class_1767.field_7945);
    }

    @Override
    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return ShulkerBoxBlock.createTickerHelper(blockEntityType, ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE, (l, pos, s, blockEntity) -> {
            ShulkerBoxBlockEntity.tick(l, pos, s, blockEntity);
            if (!l.field_9236) {
                StorageBlockEntity.serverTick(l, pos, blockEntity);
            }
        });
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        ShulkerBoxBlockEntity shulkerBoxBlockEntity;
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        if (player.method_7325()) {
            return class_1269.field_21466;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof ShulkerBoxBlockEntity) || !ShulkerBoxBlock.canOpen(state, level, pos, shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)class_25862)) {
            return class_1269.field_5811;
        }
        return WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).map(b -> {
            if (this.tryItemInteraction(player, hand, (StorageBlockEntity)b, player.method_5998(hand), this.getFacing(state), hitResult)) {
                return class_1269.field_5812;
            }
            player.method_7259(class_3468.field_15419.method_14956((Object)class_3468.field_15418));
            player.sophisticatedCore_openMenu((class_3908)new class_747((w, p, pl) -> new StorageContainerMenu(w, pl, pos), WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).map(StorageBlockEntity::method_5476).orElse((class_2561)class_2561.method_43473())), pos);
            class_4838.method_24733((class_1657)player, (boolean)true);
            return class_1269.field_21466;
        }).orElse(class_1269.field_5811);
    }

    private boolean tryItemInteraction(class_1657 player, class_1268 hand, StorageBlockEntity b, class_1799 itemInHand, class_2350 facing, class_3965 hitResult) {
        return this.tryAddUpgrade(player, hand, b, itemInHand, facing, hitResult);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).ifPresent(be -> {
            class_1792 patt6795$temp;
            NBTHelper.getUniqueId((class_1799)stack, (String)"uuid").ifPresent(uuid -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                be.method_11014(itemContentsStorage.getOrCreateStorageContents((UUID)uuid));
                itemContentsStorage.removeStorageContents((UUID)uuid);
            });
            if (stack.method_7938()) {
                be.setCustomName(stack.method_7964());
            }
            if ((patt6795$temp = stack.method_7909()) instanceof ShulkerBoxItem) {
                ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)patt6795$temp;
                StorageWrapper storageWrapper = be.getStorageWrapper();
                storageWrapper.setColors(shulkerBoxItem.getMainColor(stack).orElse(-1), shulkerBoxItem.getAccentColor(stack).orElse(-1));
                InventoryHandler inventoryHandler = storageWrapper.getInventoryHandler();
                UpgradeHandler upgradeHandler = storageWrapper.getUpgradeHandler();
                storageWrapper.changeSize(shulkerBoxItem.getNumberOfInventorySlotsOrDefault(stack) - inventoryHandler.getSlotCount(), shulkerBoxItem.getNumberOfUpgradeSlotsOrDefault(stack) - upgradeHandler.getSlotCount());
            }
            be.getStorageWrapper().onInit();
            be.tryToAddToController();
            if (placer != null && placer.method_6079().method_7909() == ModItems.STORAGE_TOOL) {
                StorageToolItem.useOffHandOnPlaced(placer.method_6079(), be);
            }
            be.method_5431();
        });
    }

    @Override
    public void addCreativeTabItems(Consumer<class_1799> itemConsumer) {
        itemConsumer.accept(new class_1799((class_1935)this));
        if (this == ModBlocks.SHULKER_BOX || Boolean.TRUE.equals(!Config.CLIENT_SPEC.isLoaded() || (Boolean)Config.CLIENT.showHigherTierTintedVariants.get() != false)) {
            for (class_1767 color : class_1767.values()) {
                class_1799 storageStack = this.getTintedStack(color);
                itemConsumer.accept(storageStack);
            }
            class_1799 storageStack = new class_1799((class_1935)this);
            class_1792 class_17922 = storageStack.method_7909();
            if (class_17922 instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
                tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])class_1767.field_7947.method_7787()));
                tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])class_1767.field_7961.method_7787()));
            }
            itemConsumer.accept(storageStack);
        }
    }

    public class_1799 getTintedStack(class_1767 color) {
        class_1799 storageStack = new class_1799((class_1935)this);
        class_1792 class_17922 = storageStack.method_7909();
        if (class_17922 instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
            tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])color.method_7787()));
            tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])color.method_7787()));
        }
        return storageStack;
    }

    private static boolean canOpen(class_2680 state, class_1937 level, class_2338 pos, ShulkerBoxBlockEntity blockEntity) {
        if (blockEntity.getAnimationStatus() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        class_238 aabb = class_1606.method_33347((class_2350)((class_2350)state.method_11654(FACING)), (float)0.0f, (float)0.5f).method_996(pos).method_1011(1.0E-6);
        return level.method_18026(aabb);
    }

    @Override
    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockentity = level.method_8321(pos);
        if (blockentity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockentity;
            if (!level.field_9236 && player.method_7337()) {
                class_1799 shulkerBoxDrop = new class_1799((class_1935)this);
                this.addShulkerContentsToStack(shulkerBoxDrop, shulkerBoxBlockEntity);
                class_1542 itementity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, shulkerBoxDrop);
                itementity.method_6988();
                level.method_8649((class_1297)itementity);
            }
        }
        super.method_9576(level, pos, state, player);
    }

    @Override
    public void addDropData(class_1799 stack, StorageBlockEntity be) {
        this.addShulkerContentsToStack(stack, be);
    }

    private void addShulkerContentsToStack(class_1799 stack, StorageBlockEntity be) {
        StorageWrapper storageWrapper = be.getStorageWrapper();
        UUID shulkerBoxUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
        class_2487 shulkerContents = be.method_38244();
        shulkerContents.method_10551("controllerPos");
        if (!shulkerContents.method_33133()) {
            ItemContentsStorage.get().setStorageContents(shulkerBoxUuid, shulkerContents);
            NBTHelper.setUniqueId((class_1799)stack, (String)"uuid", (UUID)shulkerBoxUuid);
        }
        this.addBasicPropertiesToStack(stack, be, storageWrapper);
        StorageBlockItem.setShowsTier(stack, be.shouldShowTier());
    }

    private void addBasicPropertiesToStack(class_1799 stack, StorageBlockEntity be, StorageWrapper storageWrapper) {
        class_1792 class_17922;
        if (be.method_16914()) {
            stack.method_7977(be.method_5797());
        }
        if ((class_17922 = stack.method_7909()) instanceof ShulkerBoxItem) {
            int accentColor;
            ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)class_17922;
            int mainColor = storageWrapper.getMainColor();
            if (mainColor > -1) {
                shulkerBoxItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = storageWrapper.getAccentColor()) > -1) {
                shulkerBoxItem.setAccentColor(stack, accentColor);
            }
            StorageBlockItem.setNumberOfInventorySlots(stack, storageWrapper.getInventoryHandler().getSlotCount());
            StorageBlockItem.setNumberOfUpgradeSlots(stack, storageWrapper.getUpgradeHandler().getSlotCount());
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_265 class_2652;
        class_2586 blockentity = level.method_8321(pos);
        if (blockentity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockentity;
            class_2652 = class_259.method_1078((class_238)shulkerBoxBlockEntity.getBoundingBox(state));
        } else {
            class_2652 = class_259.method_1077();
        }
        return class_2652;
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(level, pos, state);
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, ShulkerBoxBlockEntity.class).ifPresent(be -> {
            StorageWrapper storageWrapper = be.getStorageWrapper();
            this.addBasicPropertiesToStack(stack, (StorageBlockEntity)be, storageWrapper);
        });
        return stack;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    @Override
    public void setTicking(class_1937 level, class_2338 pos, class_2680 currentState, boolean ticking) {
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)context.method_8038());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    @Override
    public StorageBlockEntity newBlockEntity(class_2338 pos, class_2680 state) {
        return new ShulkerBoxBlockEntity(pos, state);
    }

    @Override
    protected class_2591<? extends StorageBlockEntity> getBlockEntityType() {
        return ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE;
    }

    @Override
    public class_2350 getFacing(class_2680 state) {
        return (class_2350)state.method_11654(FACING);
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_3727 entityCollisionContext;
        return context instanceof class_3727 && (entityCollisionContext = (class_3727)context).method_32480() instanceof class_1542 ? ITEM_ENTITY_COLLISION_SHAPE : super.method_9549(state, level, pos, context);
    }

    public boolean method_37403(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public boolean addLandingEffects(class_2680 state1, class_3218 level, class_2338 pos, class_2680 state2, class_1309 entity, int numberOfParticles) {
        level.method_14199((class_2394)new CustomTintTerrainParticleData(state1, pos), entity.method_23317(), entity.method_23318(), entity.method_23321(), numberOfParticles, 0.0, 0.0, 0.0, 0.15);
        return true;
    }

    public boolean addRunningEffects(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        class_243 vec3 = entity.method_18798();
        level.method_8406((class_2394)new CustomTintTerrainParticleData(state, pos), entity.method_23317() + (level.field_9229.method_43058() - 0.5) * (double)entity.method_17681(), entity.method_23318() + 0.1, entity.method_23321() + (level.field_9229.method_43058() - 0.5) * (double)entity.method_17681(), vec3.field_1352 * -4.0, 1.5, vec3.field_1350 * -4.0);
        return true;
    }
}

