/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_7923;
import net.p3pp3rf1y.porting_lib.base.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.model.ModelData;
import net.p3pp3rf1y.sophisticatedcore.util.model.ModelProperties;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class WoodStorageBlockEntity
extends StorageBlockEntity {
    private static final String PACKED_TAG = "packed";
    @Nullable
    private class_4719 woodType = null;
    private boolean packed = false;

    protected WoodStorageBlockEntity(class_2338 pos, class_2680 state, class_2591<? extends StorageBlockEntity> blockEntityType) {
        super(pos, state, blockEntityType);
    }

    @Override
    protected void saveSynchronizedData(class_2487 tag) {
        super.saveSynchronizedData(tag);
        if (this.woodType != null) {
            tag.method_10582("woodType", this.woodType.comp_1299());
        }
        tag.method_10556(PACKED_TAG, this.packed);
    }

    public class_2487 getStorageContentsTag() {
        class_2487 contents = this.method_38244();
        contents.method_10556(PACKED_TAG, false);
        return contents;
    }

    @Override
    public void loadSynchronizedData(class_2487 tag) {
        super.loadSynchronizedData(tag);
        this.woodType = NBTHelper.getString((class_2487)tag, (String)"woodType").flatMap(woodTypeName -> class_4719.method_24026().filter(wt -> wt.comp_1299().equals(woodTypeName)).findFirst()).orElse(this.getStorageWrapper().hasMainColor() && this.getStorageWrapper().hasAccentColor() ? null : class_4719.field_21679);
        this.packed = tag.method_10577(PACKED_TAG);
    }

    public Optional<class_4719> getWoodType() {
        return Optional.ofNullable(this.woodType);
    }

    public void setWoodType(class_4719 woodType) {
        this.woodType = woodType;
        this.method_5431();
    }

    @Override
    public class_2561 method_5476() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.makeWoodStorageDescriptionId(this.getWoodType().orElse(null));
    }

    private class_2561 makeWoodStorageDescriptionId(@Nullable class_4719 wt) {
        String id = class_156.method_646((String)"block", (class_2960)Objects.requireNonNull(class_7923.field_41175.method_10221((Object)this.method_11010().method_26204())));
        return WoodStorageBlockItem.getDisplayName(id, wt);
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setPacked(boolean packed) {
        this.packed = packed;
    }

    @Override
    public boolean shouldDropContents() {
        return !this.isPacked();
    }

    @Override
    @Nonnull
    public <T, C> LazyOptional<T> getCapability(BlockApiLookup<T, C> cap, @Nullable C opt) {
        if (this.isPacked() && cap == ItemStorage.SIDED) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, opt);
    }

    @Override
    public boolean canConnectStorages() {
        return !this.packed && super.canConnectStorages();
    }

    @Override
    public boolean canBeConnected() {
        return !this.packed && super.canBeConnected();
    }

    public boolean canBeLinked() {
        return !this.packed;
    }

    @Override
    protected boolean canRefreshUpgrades() {
        return super.canRefreshUpgrades() && !this.packed;
    }

    @Nullable
    public Object getRenderData() {
        ModelData.Builder builder = ModelData.builder();
        builder.with(ModelProperties.HAS_MAIN_COLOR, (Object)(this.getStorageWrapper().getMainColor() > -1 ? 1 : 0));
        this.getWoodType().ifPresent(n -> builder.with(ModelProperties.WOOD_NAME, (Object)n.comp_1299()));
        return builder.build();
    }
}

