/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_602;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

@Environment(value=EnvType.CLIENT)
public class ShulkerBoxRenderer
extends StorageRenderer<ShulkerBoxBlockEntity> {
    private static final String ENTITY_SHULKER_BOX_FOLDER = "entity/shulker_box/";
    public static final class_4730 BASE_TIER_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/base_tier"));
    public static final class_4730 COPPER_TIER_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/copper_tier"));
    public static final class_4730 IRON_TIER_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/iron_tier"));
    public static final class_4730 GOLD_TIER_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/gold_tier"));
    public static final class_4730 DIAMOND_TIER_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/diamond_tier"));
    public static final class_4730 NETHERITE_TIER_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/netherite_tier"));
    public static final class_4730 TINTABLE_MAIN_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/tintable_main"));
    public static final class_4730 TINTABLE_ACCENT_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/tintable_accent"));
    public static final class_4730 NO_TINT_MATERIAL = new class_4730(class_4722.field_21704, SophisticatedStorage.getRL("entity/shulker_box/no_tint"));
    private final class_602<?> model;
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new class_243(0.0, 0.0, -0.0075));

    public ShulkerBoxRenderer(class_5614.class_5615 context) {
        this.model = new class_602(context.method_32140(class_5602.field_27596));
    }

    public void render(ShulkerBoxBlockEntity shulkerBoxEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_4588 vertexconsumer;
        class_2680 blockstate;
        class_2680 blockState = shulkerBoxEntity.method_11010();
        class_2350 direction = class_2350.field_11036;
        if (shulkerBoxEntity.method_11002() && (blockstate = shulkerBoxEntity.method_10997().method_8320(shulkerBoxEntity.method_11016())).method_26204() instanceof ShulkerBoxBlock) {
            direction = (class_2350)blockstate.method_11654(ShulkerBoxBlock.FACING);
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22905(0.9995f, 0.9995f, 0.9995f);
        poseStack.method_22907(direction.method_23224());
        poseStack.method_22905(1.0f, -1.0f, -1.0f);
        poseStack.method_22904(0.0, -1.0, 0.0);
        class_630 lidPart = this.model.method_2829();
        float lidProgress = shulkerBoxEntity.getProgress(partialTick);
        lidPart.method_2851(0.0f, 24.0f - lidProgress * 0.5f * 16.0f, 0.0f);
        lidPart.field_3675 = 270.0f * lidProgress * ((float)Math.PI / 180);
        int mainColor = shulkerBoxEntity.getStorageWrapper().getMainColor();
        int accentColor = shulkerBoxEntity.getStorageWrapper().getAccentColor();
        if (mainColor == -1 || accentColor == -1) {
            vertexconsumer = NO_TINT_MATERIAL.method_24145(bufferSource, class_1921::method_23578);
            this.model.method_2828(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (mainColor > -1) {
            this.renderTintedModel(poseStack, bufferSource, packedLight, packedOverlay, mainColor, TINTABLE_MAIN_MATERIAL);
        }
        if (accentColor > -1) {
            this.renderTintedModel(poseStack, bufferSource, packedLight, packedOverlay, accentColor, TINTABLE_ACCENT_MATERIAL);
        }
        if (shulkerBoxEntity.shouldShowTier()) {
            vertexconsumer = this.getTierMaterial(blockState.method_26204()).method_24145(bufferSource, class_1921::method_23578);
            this.model.method_2828(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (this.holdsItemThatShowsHiddenTiers()) {
            class_1058 sprite = this.getTierMaterial(blockState.method_26204()).method_24148();
            class_4588 vertexconsumer2 = sprite.method_24108(bufferSource.getBuffer(class_1921.method_23580((class_2960)sprite.method_45852())));
            poseStack.method_22903();
            poseStack.method_22904(0.0, -0.01, 0.0);
            poseStack.method_22905(1.01f, 1.01f, 1.01f);
            this.model.method_2828(poseStack, vertexconsumer2, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.5f);
            poseStack.method_22909();
        }
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(DisplayItemRenderer.getNorthBasedRotation(direction));
        float zOffset = 0.0f;
        if (lidProgress > 0.0f) {
            zOffset = lidProgress * 0.5f;
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(270.0f * lidProgress));
        }
        poseStack.method_22904(-0.5, -0.5, -0.5 - (double)zOffset);
        if (shulkerBoxEntity.shouldShowUpgrades() || this.holdsItemThatShowsUpgrades()) {
            this.displayItemRenderer.renderUpgradeItems(shulkerBoxEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(shulkerBoxEntity));
        }
        this.displayItemRenderer.renderDisplayItem(shulkerBoxEntity, poseStack, bufferSource, packedLight, packedOverlay);
        LockRenderer.renderLock(shulkerBoxEntity, poseStack, bufferSource, packedLight, packedOverlay, 0.9375f, this::holdsToolInToggleLockOrLockDisplay);
        poseStack.method_22909();
    }

    private class_4730 getTierMaterial(class_2248 block) {
        if (block == ModBlocks.COPPER_SHULKER_BOX) {
            return COPPER_TIER_MATERIAL;
        }
        if (block == ModBlocks.IRON_SHULKER_BOX) {
            return IRON_TIER_MATERIAL;
        }
        if (block == ModBlocks.GOLD_SHULKER_BOX) {
            return GOLD_TIER_MATERIAL;
        }
        if (block == ModBlocks.DIAMOND_SHULKER_BOX) {
            return DIAMOND_TIER_MATERIAL;
        }
        if (block == ModBlocks.NETHERITE_SHULKER_BOX) {
            return NETHERITE_TIER_MATERIAL;
        }
        return BASE_TIER_MATERIAL;
    }

    private void renderTintedModel(class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, int mainColor, class_4730 material) {
        float tintRed = (float)(mainColor >> 16 & 0xFF) / 255.0f;
        float tingGreen = (float)(mainColor >> 8 & 0xFF) / 255.0f;
        float tintBlue = (float)(mainColor & 0xFF) / 255.0f;
        class_4588 vertexconsumer = material.method_24145(bufferSource, class_1921::method_23578);
        this.model.method_2828(poseStack, vertexconsumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
    }
}

