/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ITintable;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.util.DecorationHelper;
import org.jetbrains.annotations.NotNull;

public class PaintbrushItem
extends ItemBase {
    private static final String BARREL_MATERIALS_TAG = "barrelMaterials";
    private static final String MAIN_COLOR_TAG = "mainColor";
    private static final String ACCENT_COLOR_TAG = "accentColor";
    private static final String REMAINING_PARTS_TAG = "remainingParts";

    public PaintbrushItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static void setBarrelMaterials(class_1799 paintbrush, Map<BarrelMaterial, class_2960> materials) {
        NBTHelper.putMap((class_2487)paintbrush.method_7948(), (String)BARREL_MATERIALS_TAG, materials, BarrelMaterial::method_15434, resourceLocation -> class_2519.method_23256((String)resourceLocation.toString()));
        PaintbrushItem.resetMainColor(paintbrush);
        PaintbrushItem.resetAccentColor(paintbrush);
    }

    public static Optional<ItemRequirements> getItemRequirements(class_1799 paintbrush, class_1657 player, class_1937 level, class_2338 lookingAtPos) {
        HashMap<BarrelMaterial, class_2960> materialsToApply = new HashMap<BarrelMaterial, class_2960>(PaintbrushItem.getBarrelMaterials(paintbrush));
        class_2586 be = level.method_8321(lookingAtPos);
        if (be == null) {
            return Optional.empty();
        }
        if (!materialsToApply.isEmpty()) {
            return PaintbrushItem.getMaterialItemRequirements(paintbrush, player, be, materialsToApply);
        }
        return PaintbrushItem.getDyeItemRequirements(paintbrush, player, be);
    }

    private static Optional<ItemRequirements> getMaterialItemRequirements(class_1799 paintbrush, class_1657 player, class_2586 be, Map<BarrelMaterial, class_2960> materialsToApply) {
        HashMap<class_2960, Integer> allPartsNeeded = new HashMap();
        if (be instanceof IMaterialHolder) {
            IMaterialHolder materialHolder = (IMaterialHolder)be;
            allPartsNeeded = PaintbrushItem.getMaterialHolderPartsNeeded(materialsToApply, materialHolder);
        } else if (be instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBe = (ControllerBlockEntity)be;
            for (class_2338 storagePosition : controllerBe.getStoragePositions()) {
                PaintbrushItem.addStorageMaterialPartsNeeded(materialsToApply, controllerBe, storagePosition, allPartsNeeded);
            }
        }
        if (allPartsNeeded.isEmpty()) {
            return Optional.empty();
        }
        return PaintbrushItem.getItemRequirements(paintbrush, player, allPartsNeeded);
    }

    public static Optional<ItemRequirements> getItemRequirements(class_1799 paintbrush, class_1657 player, Map<class_2960, Integer> allPartsNeeded) {
        DecorationHelper.ConsumptionResult result;
        Map<class_2960, Integer> remainingParts = PaintbrushItem.getRemainingParts(paintbrush);
        try (Transaction simulate = Transaction.openOuter();){
            result = DecorationHelper.consumeMaterialPartsNeeded(allPartsNeeded, remainingParts, InventoryHelper.getItemHandlersFromPlayerIncludingContainers((class_1657)player), (TransactionContext)simulate);
        }
        ArrayList<class_1799> itemsPresent = new ArrayList<class_1799>();
        ArrayList<class_1799> itemsMissing = new ArrayList<class_1799>();
        for (Map.Entry<class_2960, Integer> entry : allPartsNeeded.entrySet()) {
            class_2960 part = entry.getKey();
            int count = PaintbrushItem.ceilDiv(entry.getValue() - remainingParts.getOrDefault(part, 0), 24);
            int missing = PaintbrushItem.ceilDiv(result.missingParts().getOrDefault(part, 0), 24);
            int present = count - missing;
            class_7923.field_41178.method_17966(part).ifPresent(item -> {
                if (missing > 0) {
                    itemsMissing.add(new class_1799((class_1935)item, missing));
                }
                if (present > 0) {
                    itemsPresent.add(new class_1799((class_1935)item, present));
                }
            });
        }
        return Optional.of(new ItemRequirements(itemsPresent, itemsMissing));
    }

    private static int ceilDiv(int x, int y) {
        return (int)Math.ceil((double)x / (double)y);
    }

    private static void addStorageMaterialPartsNeeded(Map<BarrelMaterial, class_2960> materialsToApply, ControllerBlockEntity controllerBe, class_2338 storagePosition, Map<class_2960, Integer> allPartsNeeded) {
        WorldHelper.getBlockEntity((class_1922)controllerBe.method_10997(), (class_2338)storagePosition, IMaterialHolder.class).ifPresent(materialHolder -> {
            Map<class_2960, Integer> storagePartsNeeded = PaintbrushItem.getMaterialHolderPartsNeeded(materialsToApply, materialHolder);
            storagePartsNeeded.forEach((part, count) -> allPartsNeeded.merge((class_2960)part, (Integer)count, Integer::sum));
        });
    }

    private static Optional<ItemRequirements> getDyeItemRequirements(class_1799 paintbrush, class_1657 player, class_2586 be) {
        int mainColorToSet = PaintbrushItem.getMainColor(paintbrush) & 0xFFFFFF;
        int accentColorToSet = PaintbrushItem.getAccentColor(paintbrush) & 0xFFFFFF;
        HashMap<class_6862<class_1792>, Integer> allPartsNeeded = new HashMap();
        if (be instanceof StorageBlockEntity) {
            StorageBlockEntity storageBe = (StorageBlockEntity)be;
            allPartsNeeded = PaintbrushItem.getStorageDyePartsNeeded(mainColorToSet, accentColorToSet, (ITintable)storageBe.getStorageWrapper());
        } else if (be instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBe = (ControllerBlockEntity)be;
            for (class_2338 storagePosition : controllerBe.getStoragePositions()) {
                PaintbrushItem.addStorageDyePartsNeeded(mainColorToSet, accentColorToSet, controllerBe, storagePosition, allPartsNeeded);
            }
        }
        if (allPartsNeeded.isEmpty()) {
            return Optional.empty();
        }
        return PaintbrushItem.getDyeItemRequirements(paintbrush, player, allPartsNeeded);
    }

    @NotNull
    public static Optional<ItemRequirements> getDyeItemRequirements(class_1799 paintbrush, class_1657 player, Map<class_6862<class_1792>, Integer> allPartsNeeded) {
        DecorationHelper.ConsumptionResult result;
        Map<class_2960, Integer> remainingParts = PaintbrushItem.getRemainingParts(paintbrush);
        try (Transaction simulate = Transaction.openOuter();){
            result = DecorationHelper.consumeDyePartsNeeded(allPartsNeeded, InventoryHelper.getItemHandlersFromPlayerIncludingContainers((class_1657)player), remainingParts, (TransactionContext)simulate);
        }
        return PaintbrushItem.compileDyeItemRequirements(allPartsNeeded, remainingParts, result);
    }

    private static void addStorageDyePartsNeeded(int mainColorToSet, int accentColorToSet, ControllerBlockEntity controllerBe, class_2338 storagePosition, Map<class_6862<class_1792>, Integer> allPartsNeeded) {
        WorldHelper.getBlockEntity((class_1922)controllerBe.method_10997(), (class_2338)storagePosition, StorageBlockEntity.class).ifPresent(storageBe -> {
            Map<class_6862<class_1792>, Integer> storagePartsNeeded = PaintbrushItem.getStorageDyePartsNeeded(mainColorToSet, accentColorToSet, (ITintable)storageBe.getStorageWrapper());
            storagePartsNeeded.forEach((part, count) -> allPartsNeeded.merge((class_6862<class_1792>)part, (Integer)count, Integer::sum));
        });
    }

    public static Map<class_6862<class_1792>, Integer> getStorageDyePartsNeeded(int mainColorToSet, int accentColorToSet, ITintable tintable) {
        return DecorationHelper.getDyePartsNeeded(mainColorToSet, accentColorToSet, tintable.getMainColor(), tintable.getAccentColor());
    }

    @NotNull
    private static Optional<ItemRequirements> compileDyeItemRequirements(Map<class_6862<class_1792>, Integer> allPartsNeeded, Map<class_2960, Integer> remainingParts, DecorationHelper.ConsumptionResult result) {
        ArrayList<class_1799> itemsPresent = new ArrayList<class_1799>();
        ArrayList<class_1799> itemsMissing = new ArrayList<class_1799>();
        for (Map.Entry<class_6862<class_1792>, Integer> entry : allPartsNeeded.entrySet()) {
            class_1792 dyeItem;
            class_6862<class_1792> part = entry.getKey();
            int count = PaintbrushItem.ceilDiv(entry.getValue() - remainingParts.getOrDefault(part.comp_327(), 0), 24);
            int missing = PaintbrushItem.ceilDiv(result.missingParts().getOrDefault(part.comp_327(), 0), 24);
            int present = count - missing;
            if (part == ConventionalItemTags.RED_DYES) {
                dyeItem = class_1802.field_8264;
            } else if (part == ConventionalItemTags.GREEN_DYES) {
                dyeItem = class_1802.field_8408;
            } else {
                if (part != ConventionalItemTags.BLUE_DYES) continue;
                dyeItem = class_1802.field_8345;
            }
            if (missing > 0) {
                itemsMissing.add(new class_1799((class_1935)dyeItem, missing));
            }
            if (present <= 0) continue;
            itemsPresent.add(new class_1799((class_1935)dyeItem, present));
        }
        return Optional.of(new ItemRequirements(itemsPresent, itemsMissing));
    }

    public static Map<class_2960, Integer> getMaterialHolderPartsNeeded(Map<BarrelMaterial, class_2960> materialsToApply, IMaterialHolder materialHolder) {
        HashMap<BarrelMaterial, class_2960> originalMaterials = new HashMap<BarrelMaterial, class_2960>(materialHolder.getMaterials());
        BarrelBlockItem.uncompactMaterials(originalMaterials);
        return DecorationHelper.getMaterialPartsNeeded(originalMaterials, materialsToApply);
    }

    public class_1269 onItemUseFirst(class_1799 paintbrush, class_1838 context) {
        if (!(PaintbrushItem.hasMainColor(paintbrush) || PaintbrushItem.hasAccentColor(paintbrush) || PaintbrushItem.hasBarrelMaterials(paintbrush))) {
            return class_1269.field_5811;
        }
        class_1937 level = context.method_8045();
        class_2586 be = level.method_8321(context.method_8037());
        if (be instanceof StorageBlockEntity) {
            StorageBlockEntity storageBe = (StorageBlockEntity)be;
            if (!level.method_8608()) {
                PaintbrushItem.paintStorage(context.method_8036(), paintbrush, storageBe, 1.0f);
            }
            return class_1269.field_5812;
        }
        if (be instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBe = (ControllerBlockEntity)be;
            if (!level.method_8608()) {
                this.paintConnectedStorages(context.method_8036(), level, paintbrush, controllerBe);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void paintConnectedStorages(@Nullable class_1657 player, class_1937 level, class_1799 paintbrush, ControllerBlockEntity controllerBe) {
        if (player == null) {
            return;
        }
        for (class_2338 pos : controllerBe.getStoragePositions()) {
            WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).ifPresent(storageBe -> PaintbrushItem.paintStorage(player, paintbrush, storageBe, 0.6f));
        }
    }

    private static void paintStorage(@Nullable class_1657 player, class_1799 paintbrush, StorageBlockEntity storageBe, float soundVolume) {
        class_2350 effectOffsetDirection;
        class_2680 state;
        class_2248 class_22482;
        IMaterialHolder materialHolder;
        if (player == null) {
            return;
        }
        StorageWrapper tintable = storageBe.getStorageWrapper();
        IMaterialHolder iMaterialHolder = materialHolder = storageBe instanceof IMaterialHolder ? (IMaterialHolder)((Object)storageBe) : null;
        if (storageBe instanceof ChestBlockEntity) {
            ChestBlockEntity chestBe = (ChestBlockEntity)storageBe;
            tintable = chestBe.getMainStorageWrapper();
            storageBe = chestBe.getMainChestBlockEntity();
        }
        if ((class_22482 = (state = storageBe.method_11010()).method_26204()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            v1 = storageBlock.getFacing(state);
        } else {
            v1 = effectOffsetDirection = class_2350.field_11036;
        }
        if (PaintbrushItem.paint(player, paintbrush, soundVolume, materialHolder, (ITintable)tintable, class_243.method_24953((class_2382)storageBe.method_11016()), effectOffsetDirection, state.method_26231().method_10598())) {
            WorldHelper.notifyBlockUpdate((class_2586)storageBe);
        }
    }

    public static boolean paint(@NotNull class_1657 player, class_1799 paintbrush, @Nullable IMaterialHolder materialHolder, ITintable tintable, class_243 successEffectPos, class_2350 effectOffsetDirection, class_3414 placeSound) {
        return PaintbrushItem.paint(player, paintbrush, 1.0f, materialHolder, tintable, successEffectPos, effectOffsetDirection, placeSound);
    }

    public static boolean paint(@NotNull class_1657 player, class_1799 paintbrush, float soundVolume, @Nullable IMaterialHolder materialHolder, ITintable tintable, class_243 successEffectPos, class_2350 effectOffsetDirection, class_3414 placeSound) {
        if (PaintbrushItem.hasBarrelMaterials(paintbrush)) {
            if (materialHolder == null || !materialHolder.canHoldMaterials()) {
                return false;
            }
            if (PaintbrushItem.applyMaterials(player, paintbrush, materialHolder, tintable)) {
                PaintbrushItem.playSoundAndParticles(player.method_37908(), successEffectPos, soundVolume, placeSound, effectOffsetDirection);
                return true;
            }
        } else if (PaintbrushItem.setColors(player, paintbrush, tintable, materialHolder)) {
            PaintbrushItem.playSoundAndParticles(player.method_37908(), successEffectPos, soundVolume, placeSound, effectOffsetDirection);
            return true;
        }
        return false;
    }

    public static boolean setColors(class_1657 player, class_1799 paintbrush, ITintable tintable, @Nullable IMaterialHolder materialHolder) {
        HashMap<class_2960, Integer> remainingParts = new HashMap<class_2960, Integer>(PaintbrushItem.getRemainingParts(paintbrush));
        List itemHandlers = InventoryHelper.getItemHandlersFromPlayerIncludingContainers((class_1657)player);
        int mainColorToSet = PaintbrushItem.getMainColor(paintbrush) & 0xFFFFFF;
        int accentColorToSet = PaintbrushItem.getAccentColor(paintbrush) & 0xFFFFFF;
        int originalMainColor = tintable.getMainColor();
        int originalAccentColor = tintable.getAccentColor();
        if (originalMainColor == mainColorToSet && originalAccentColor == accentColorToSet) {
            return false;
        }
        try (Transaction simulate = Transaction.openOuter();){
            if (!DecorationHelper.consumeDyes(mainColorToSet, accentColorToSet, remainingParts, itemHandlers, originalMainColor, originalAccentColor, (TransactionContext)simulate)) {
                boolean bl = false;
                return bl;
            }
        }
        tintable.setColors(mainColorToSet & 0xFFFFFF, accentColorToSet & 0xFFFFFF);
        if (materialHolder != null) {
            materialHolder.setMaterials(Collections.emptyMap());
        }
        try (Transaction consume = Transaction.openOuter();){
            DecorationHelper.consumeDyes(mainColorToSet, accentColorToSet, remainingParts, itemHandlers, originalMainColor, originalAccentColor, (TransactionContext)consume);
            consume.commit();
        }
        PaintbrushItem.setRemainingParts(paintbrush, remainingParts);
        return true;
    }

    private static boolean applyMaterials(class_1657 player, class_1799 paintbrush, IMaterialHolder materialHolder, ITintable tintable) {
        HashMap<BarrelMaterial, class_2960> materialsToApply;
        List itemHandlers = InventoryHelper.getItemHandlersFromPlayerIncludingContainers((class_1657)player);
        HashMap<class_2960, Integer> remainingParts = new HashMap<class_2960, Integer>(PaintbrushItem.getRemainingParts(paintbrush));
        HashMap<BarrelMaterial, class_2960> originalMaterials = new HashMap<BarrelMaterial, class_2960>(materialHolder.getMaterials());
        if (originalMaterials.equals(materialsToApply = new HashMap<BarrelMaterial, class_2960>(PaintbrushItem.getBarrelMaterials(paintbrush)))) {
            return false;
        }
        BarrelBlockItem.uncompactMaterials(originalMaterials);
        try (Transaction simulate = Transaction.openOuter();){
            if (!DecorationHelper.consumeMaterials(remainingParts, itemHandlers, originalMaterials, materialsToApply, (TransactionContext)simulate)) {
                boolean bl = false;
                return bl;
            }
        }
        try (Transaction consume = Transaction.openOuter();){
            DecorationHelper.consumeMaterials(remainingParts, itemHandlers, originalMaterials, materialsToApply, (TransactionContext)consume);
            consume.commit();
        }
        PaintbrushItem.setRemainingParts(paintbrush, remainingParts);
        tintable.setColors(-1, -1);
        BarrelBlockItem.compactMaterials(materialsToApply);
        materialHolder.setMaterials(materialsToApply);
        return true;
    }

    private static void playSoundAndParticles(class_1937 level, class_243 pos, float soundVolume, class_3414 placeSound, class_2350 effectOffsetDirection) {
        level.method_43128(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), placeSound, class_3419.field_15245, soundVolume, 1.0f);
        if (level instanceof class_3218) {
            double zOffset;
            double yOffset;
            double xOffset;
            class_3218 serverLevel = (class_3218)level;
            double x = pos.method_10216() + 0.5 + (double)effectOffsetDirection.method_10148() * 0.6;
            double y = pos.method_10214() + 0.5 + (double)effectOffsetDirection.method_10164() * 0.6;
            double z = pos.method_10215() + 0.5 + (double)effectOffsetDirection.method_10165() * 0.6;
            if (effectOffsetDirection.method_10166().method_10178()) {
                xOffset = 0.4;
                yOffset = 0.1;
                zOffset = 0.4;
            } else {
                xOffset = 0.1 + (double)effectOffsetDirection.method_10165() * 0.3;
                yOffset = 0.4;
                zOffset = 0.1 + (double)effectOffsetDirection.method_10148() * 0.3;
            }
            serverLevel.method_14199((class_2394)class_2398.field_11211, x, y, z, 4, xOffset, yOffset, zOffset, 1.0);
        }
    }

    private static void resetBarrelMaterials(class_1799 paintbrush) {
        NBTHelper.removeTag((class_1799)paintbrush, (String)BARREL_MATERIALS_TAG);
    }

    public static void resetMainColor(class_1799 paintbrush) {
        NBTHelper.removeTag((class_1799)paintbrush, (String)MAIN_COLOR_TAG);
    }

    public static void resetAccentColor(class_1799 paintbrush) {
        NBTHelper.removeTag((class_1799)paintbrush, (String)ACCENT_COLOR_TAG);
    }

    public static void setMainColor(class_1799 paintbrush, int mainColor) {
        NBTHelper.putInt((class_2487)paintbrush.method_7948(), (String)MAIN_COLOR_TAG, (int)mainColor);
        PaintbrushItem.resetBarrelMaterials(paintbrush);
    }

    public static void setAccentColor(class_1799 paintbrush, int secondaryColor) {
        NBTHelper.putInt((class_2487)paintbrush.method_7948(), (String)ACCENT_COLOR_TAG, (int)secondaryColor);
        PaintbrushItem.resetBarrelMaterials(paintbrush);
    }

    public static void setRemainingParts(class_1799 paintbrush, Map<class_2960, Integer> remainingParts) {
        NBTHelper.putMap((class_2487)paintbrush.method_7948(), (String)REMAINING_PARTS_TAG, remainingParts, class_2960::toString, class_2497::method_23247);
    }

    public static Map<class_2960, Integer> getRemainingParts(class_1799 paintbrush) {
        return NBTHelper.getMap((class_2487)paintbrush.method_7948(), (String)REMAINING_PARTS_TAG, class_2960::new, (rl, tag) -> Optional.of(((class_2497)tag).method_10701())).orElseGet(HashMap::new);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 tooltipFlag) {
        super.method_7851(stack, level, tooltip, tooltipFlag);
        tooltip.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(StorageTranslationHelper.INSTANCE.translItemTooltip(stack.method_7909()), null, new class_124[]{class_124.field_1063}));
        if (PaintbrushItem.hasBarrelMaterials(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)(StorageTranslationHelper.INSTANCE.translItemTooltip("paintbrush") + ".materials")).method_27692(class_124.field_1080));
            Map<BarrelMaterial, class_2960> barrelMaterials = PaintbrushItem.getBarrelMaterials(stack);
            barrelMaterials.forEach((barrelMaterial, blockName) -> class_7923.field_41175.method_17966(blockName).ifPresent(block -> tooltip.add((class_2561)class_2561.method_43469((String)(StorageTranslationHelper.INSTANCE.translItemTooltip("paintbrush") + ".material"), (Object[])new Object[]{class_2561.method_43471((String)StorageTranslationHelper.INSTANCE.translGui("barrel_part." + barrelMaterial.method_15434())), block.method_9518().method_27692(class_124.field_1062)}).method_27692(class_124.field_1080))));
        }
        if (PaintbrushItem.hasMainColor(stack)) {
            int mainColor = PaintbrushItem.getMainColor(stack);
            tooltip.add((class_2561)class_2561.method_43469((String)(StorageTranslationHelper.INSTANCE.translItemTooltip("paintbrush") + ".main_color"), (Object[])new Object[]{class_2561.method_43470((String)ColorHelper.getHexColor((int)mainColor)).method_27696(class_2583.field_24360.method_36139(mainColor))}).method_27692(class_124.field_1080));
        }
        if (PaintbrushItem.hasAccentColor(stack)) {
            int accentColor = PaintbrushItem.getAccentColor(stack);
            tooltip.add((class_2561)class_2561.method_43469((String)(StorageTranslationHelper.INSTANCE.translItemTooltip("paintbrush") + ".accent_color"), (Object[])new Object[]{class_2561.method_43470((String)ColorHelper.getHexColor((int)accentColor)).method_27696(class_2583.field_24360.method_36139(accentColor))}).method_27692(class_124.field_1080));
        }
    }

    private static boolean hasMainColor(class_1799 paintbrush) {
        return NBTHelper.hasTag((class_1799)paintbrush, (String)MAIN_COLOR_TAG);
    }

    private static boolean hasAccentColor(class_1799 paintbrush) {
        return NBTHelper.hasTag((class_1799)paintbrush, (String)ACCENT_COLOR_TAG);
    }

    private static boolean hasBarrelMaterials(class_1799 paintbrush) {
        return NBTHelper.hasTag((class_1799)paintbrush, (String)BARREL_MATERIALS_TAG);
    }

    public static int getMainColor(class_1799 paintbrush) {
        return NBTHelper.getInt((class_1799)paintbrush, (String)MAIN_COLOR_TAG).orElse(-1);
    }

    public static int getAccentColor(class_1799 paintbrush) {
        return NBTHelper.getInt((class_1799)paintbrush, (String)ACCENT_COLOR_TAG).orElse(-1);
    }

    public static Map<BarrelMaterial, class_2960> getBarrelMaterials(class_1799 paintbrush) {
        return NBTHelper.getMap((class_2487)paintbrush.method_7948(), (String)BARREL_MATERIALS_TAG, BarrelMaterial::fromName, (bm, tag) -> Optional.of(new class_2960(tag.method_10714()))).orElse(Map.of());
    }

    public record ItemRequirements(List<class_1799> itemsPresent, List<class_1799> itemsMissing) {
    }
}

