/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;

public class StorageBlockItem
extends BlockItemBase
implements ITintableBlockItem {
    private static final String ACCENT_COLOR_TAG = "accentColor";
    private static final String MAIN_COLOR_TAG = "mainColor";
    private static final String SHOWS_TIER_TAG = "showsTier";

    public StorageBlockItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public static Optional<class_2487> getEntityWrapperTagFromStack(class_1799 barrelStack) {
        return NBTHelper.getCompound((class_1799)barrelStack, (String)"BlockEntityTag").flatMap(tag -> NBTHelper.getCompound((class_2487)tag, (String)"storageWrapper"));
    }

    public static Optional<Integer> getMainColorFromStack(class_1799 barrelStack) {
        return StorageBlockItem.getEntityWrapperTagFromStack(barrelStack).map(tag -> NBTHelper.getInt((class_2487)tag, (String)MAIN_COLOR_TAG)).orElse(NBTHelper.getInt((class_1799)barrelStack, (String)MAIN_COLOR_TAG));
    }

    public static Optional<Integer> getAccentColorFromStack(class_1799 barrelStack) {
        return StorageBlockItem.getEntityWrapperTagFromStack(barrelStack).map(tag -> NBTHelper.getInt((class_2487)tag, (String)ACCENT_COLOR_TAG)).orElse(NBTHelper.getInt((class_1799)barrelStack, (String)ACCENT_COLOR_TAG));
    }

    public static void setNumberOfInventorySlots(class_1799 storageStack, int numberOfInventorySlots) {
        NBTHelper.setInteger((class_1799)storageStack, (String)"numberOfInventorySlots", (int)numberOfInventorySlots);
    }

    public static void setNumberOfUpgradeSlots(class_1799 storageStack, int numberOfUpgradeSlots) {
        NBTHelper.setInteger((class_1799)storageStack, (String)"numberOfUpgradeSlots", (int)numberOfUpgradeSlots);
    }

    public static int getNumberOfInventorySlots(class_1799 storageStack) {
        return NBTHelper.getInt((class_1799)storageStack, (String)"numberOfInventorySlots").orElse(0);
    }

    public static int getNumberOfUpgradeSlots(class_1799 storageStack) {
        return NBTHelper.getInt((class_1799)storageStack, (String)"numberOfUpgradeSlots").orElse(0);
    }

    @Override
    public void setMainColor(class_1799 storageStack, int mainColor) {
        storageStack.method_7948().method_10569(MAIN_COLOR_TAG, mainColor);
    }

    @Override
    public Optional<Integer> getMainColor(class_1799 storageStack) {
        return StorageBlockItem.getMainColorFromStack(storageStack);
    }

    @Override
    public void setAccentColor(class_1799 storageStack, int accentColor) {
        storageStack.method_7948().method_10569(ACCENT_COLOR_TAG, accentColor);
    }

    @Override
    public void removeMainColor(class_1799 stack) {
        NBTHelper.removeTag((class_1799)stack, (String)MAIN_COLOR_TAG);
    }

    @Override
    public void removeAccentColor(class_1799 stack) {
        NBTHelper.removeTag((class_1799)stack, (String)ACCENT_COLOR_TAG);
    }

    @Override
    public Optional<Integer> getAccentColor(class_1799 stack) {
        return StorageBlockItem.getAccentColorFromStack(stack);
    }

    public static boolean showsTier(class_1799 stack) {
        return NBTHelper.getBoolean((class_1799)stack, (String)SHOWS_TIER_TAG).orElse(true);
    }

    public static void setShowsTier(class_1799 stack, boolean showsTier) {
        if (showsTier) {
            NBTHelper.removeTag((class_1799)stack, (String)SHOWS_TIER_TAG);
        } else {
            stack.method_7948().method_10556(SHOWS_TIER_TAG, false);
        }
    }

    public static Optional<UUID> getContentsUuid(class_1799 stack) {
        return NBTHelper.getUniqueId((class_1799)stack, (String)"uuid");
    }
}

