/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3954;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.TargetContentsFilterLogic;

public class HopperUpgradeWrapper
extends UpgradeWrapperBase<HopperUpgradeWrapper, HopperUpgradeItem>
implements ITickableUpgrade,
INeighborChangeListenerUpgrade {
    private Set<class_2350> pullDirections = new LinkedHashSet<class_2350>();
    private Set<class_2350> pushDirections = new LinkedHashSet<class_2350>();
    private boolean directionsInitialized = false;
    private final Map<class_2350, ItemHandlerHolder> handlerCache = new EnumMap<class_2350, ItemHandlerHolder>(class_2350.class);
    private final ContentsFilterLogic inputFilterLogic;
    private final TargetContentsFilterLogic outputFilterLogic;
    private long coolDownTime = 0L;

    protected HopperUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputFilterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getInputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), "inputFilter");
        this.outputFilterLogic = new TargetContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getOutputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), "outputFilter");
        this.deserialize();
    }

    public void tick(@Nullable class_1297 entity, class_1937 level, class_2338 pos) {
        boolean done;
        this.initDirections(level, pos);
        if (this.coolDownTime > level.method_8510()) {
            return;
        }
        for (class_2350 pushDirection : this.pushDirections) {
            done = false;
            for (Storage<ItemVariant> itemHandler : this.getItemHandlers(level, pos, pushDirection, entity == null)) {
                if (!this.pushItems(itemHandler)) continue;
                done = true;
                break;
            }
            if (!done) {
                class_1278 worldlyContainer;
                Iterator<Storage<ItemVariant>> iterator = this.getWorldlyContainers(level, pos, pushDirection).iterator();
                while (iterator.hasNext() && !this.pushItemsToContainer((class_1263)(worldlyContainer = (class_1278)iterator.next()), pushDirection.method_10153())) {
                }
            }
            if (done) continue;
            this.getEntityContainer(level, pos, pushDirection, entity).ifPresent(container -> this.pushItemsToContainer((class_1263)container, pushDirection.method_10153()));
        }
        for (class_2350 pullDirection : this.pullDirections) {
            done = false;
            for (Storage<ItemVariant> itemHandler : this.getItemHandlers(level, pos, pullDirection, entity == null)) {
                if (!this.pullItems(itemHandler)) continue;
                done = true;
                break;
            }
            if (!done) {
                for (class_1278 worldlyContainer : this.getWorldlyContainers(level, pos, pullDirection)) {
                    if (!this.pullItemsFromContainer((class_1263)worldlyContainer, pullDirection.method_10153())) continue;
                    done = true;
                    break;
                }
            }
            if (done) continue;
            this.getEntityContainer(level, pos, pullDirection, entity).ifPresent(container -> this.pullItemsFromContainer((class_1263)container, pullDirection.method_10153()));
        }
        this.coolDownTime = level.method_8510() + ((HopperUpgradeItem)this.upgradeItem).getTransferSpeedTicks();
    }

    private Optional<class_1263> getEntityContainer(class_1937 level, class_2338 pos, class_2350 direction, @Nullable class_1297 entity) {
        List<class_2338> list;
        Object object;
        class_2680 storageState = level.method_8320(pos);
        if (entity == null && (object = storageState.method_26204()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)object;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.method_10093(direction));
        }
        List<class_2338> offsetPositions = list;
        ArrayList entities = new ArrayList();
        for (class_2338 offsetPosition : offsetPositions) {
            entities.addAll(level.method_8333((class_1297)null, new class_238(offsetPosition), e -> e != entity && class_1301.field_6152.test(e)));
        }
        if (!entities.isEmpty()) {
            Collections.shuffle(entities);
            return Optional.of((class_1263)entities.get(0));
        }
        return Optional.empty();
    }

    private boolean pushItemsToContainer(class_1263 worldlyContainer, class_2350 face) {
        ITrackedContentsItemHandler fromHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        this.outputFilterLogic.setInventory((Storage<ItemVariant>)Storage.empty());
        for (StorageView view : fromHandler.nonEmptyViews()) {
            long extracted;
            if (view.isResourceBlank() || !this.outputFilterLogic.matchesFilter(((ItemVariant)view.getResource()).toStack((int)view.getAmount())) || (extracted = StorageUtil.simulateExtract((Storage)fromHandler, (Object)((ItemVariant)view.getResource()), (long)Math.min(worldlyContainer.method_5444(), ((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize()), null)) <= 0L || !this.pushStackToContainer(worldlyContainer, face, extracted, (StorageView<ItemVariant>)view)) continue;
            return true;
        }
        return false;
    }

    private boolean pushStackToContainer(class_1263 container, class_2350 face, long extracted, StorageView<ItemVariant> view) {
        class_1799 extractedStack = ((ItemVariant)view.getResource()).toStack((int)extracted);
        for (int containerSlot = 0; containerSlot < container.method_5439(); ++containerSlot) {
            int maxStackSize;
            int remainder;
            boolean canPlaceItem;
            if (container instanceof class_1278) {
                class_1278 worldlyContainer = (class_1278)container;
                v0 = worldlyContainer.method_5492(containerSlot, extractedStack, face);
            } else {
                v0 = canPlaceItem = container.method_5437(containerSlot, extractedStack);
            }
            if (!canPlaceItem) continue;
            class_1799 existingStack = container.method_5438(containerSlot);
            if (existingStack.method_7960()) {
                container.method_5447(containerSlot, extractedStack);
                try (Transaction ctx = Transaction.openOuter();){
                    view.extract((Object)((ItemVariant)view.getResource()), extracted, (TransactionContext)ctx);
                    ctx.commit();
                }
                return true;
            }
            if (!ItemHandlerHelper.canItemStacksStack((class_1799)existingStack, (class_1799)extractedStack) || (remainder = (maxStackSize = Math.min(container.method_5444(), existingStack.method_7914())) - existingStack.method_7947()) <= 0) continue;
            int countToExtract = (int)Math.min(extracted, (long)remainder);
            existingStack.method_7933(countToExtract);
            container.method_5447(containerSlot, existingStack);
            try (Transaction ctx = Transaction.openOuter();){
                view.extract((Object)((ItemVariant)view.getResource()), (long)countToExtract, (TransactionContext)ctx);
                ctx.commit();
            }
            return true;
        }
        return false;
    }

    private boolean pullItemsFromContainer(class_1263 container, class_2350 face) {
        ITrackedContentsItemHandler toHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        for (int containerSlot = 0; containerSlot < container.method_5439(); ++containerSlot) {
            class_1278 worldlyContainer;
            class_1799 stackToInsert = container.method_5438(containerSlot).method_7972();
            if (stackToInsert.method_7947() > ((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize()) {
                stackToInsert.method_7939(((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize());
            }
            if (stackToInsert.method_7960() || container instanceof class_1278 && !(worldlyContainer = (class_1278)container).method_5493(containerSlot, stackToInsert, face) || !this.inputFilterLogic.matchesFilter(stackToInsert)) continue;
            ItemVariant resource = ItemVariant.of((class_1799)stackToInsert);
            long maxAmount = stackToInsert.method_7947();
            try (Transaction ctx = Transaction.openOuter();){
                maxAmount -= toHandler.insert((Object)resource, maxAmount, (TransactionContext)ctx);
                ctx.commit();
            }
            if (maxAmount <= 0L) continue;
            container.method_5447(containerSlot, resource.toStack((int)maxAmount));
            return true;
        }
        return false;
    }

    private void initDirections(class_1937 level, class_2338 pos) {
        if (this.upgrade.method_7985() && (this.upgrade.method_7909() != ModItems.HOPPER_UPGRADE || this.directionsInitialized)) {
            return;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            class_2350 horizontalDirection = storageBlock.getHorizontalDirection(state);
            VerticalFacing verticalFacing = storageBlock.getVerticalFacing(state);
            this.pullDirections.clear();
            this.pushDirections.clear();
            this.initDirections(BlockSide.BOTTOM.toDirection(horizontalDirection, verticalFacing), BlockSide.TOP.toDirection(horizontalDirection, verticalFacing));
            this.directionsInitialized = true;
        } else {
            this.initDirections(class_2350.field_11033, class_2350.field_11036);
        }
    }

    private List<class_1278> getWorldlyContainers(class_1937 level, class_2338 pos, class_2350 direction) {
        List<class_2338> list;
        class_2680 storageState = level.method_8320(pos);
        class_2248 class_22482 = storageState.method_26204();
        if (class_22482 instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.method_10093(direction));
        }
        List<class_2338> offsetPositions = list;
        ArrayList<class_1278> worldlyContainers = new ArrayList<class_1278>();
        offsetPositions.forEach(offsetPos -> {
            class_2680 state = level.method_8320(offsetPos);
            class_2248 patt10574$temp = state.method_26204();
            if (patt10574$temp instanceof class_3954) {
                class_3954 worldlyContainerHolder = (class_3954)patt10574$temp;
                worldlyContainers.add(worldlyContainerHolder.method_17680(state, (class_1936)level, offsetPos));
            }
        });
        return worldlyContainers;
    }

    private boolean pullItems(Storage<ItemVariant> fromHandler) {
        return this.moveItems(fromHandler, (Storage<ItemVariant>)this.storageWrapper.getInventoryForUpgradeProcessing(), (FilterLogic)this.inputFilterLogic);
    }

    private boolean pushItems(Storage<ItemVariant> toHandler) {
        this.outputFilterLogic.setInventory(toHandler);
        return this.moveItems((Storage<ItemVariant>)this.storageWrapper.getInventoryForUpgradeProcessing(), toHandler, (FilterLogic)this.outputFilterLogic);
    }

    private boolean moveItems(Storage<ItemVariant> fromHandler, Storage<ItemVariant> toHandler, FilterLogic filterLogic) {
        for (StorageView view : fromHandler.nonEmptyViews()) {
            ItemVariant resource = (ItemVariant)view.getResource();
            class_1799 slotStack = resource.toStack((int)view.getAmount());
            if (slotStack.method_7960() || !filterLogic.matchesFilter(slotStack)) continue;
            long maxExtracted = StorageUtil.simulateExtract((StorageView)view, (Object)resource, (long)((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize(), null);
            Transaction transferTransaction = Transaction.openOuter();
            try {
                long accepted = toHandler.insert((Object)resource, maxExtracted, (TransactionContext)transferTransaction);
                if (fromHandler.extract((Object)resource, accepted, (TransactionContext)transferTransaction) != accepted) continue;
                transferTransaction.commit();
                boolean bl = true;
                return bl;
            }
            finally {
                if (transferTransaction == null) continue;
                transferTransaction.close();
            }
        }
        return false;
    }

    @Override
    public void onNeighborChange(class_1937 level, class_2338 pos, class_2350 direction) {
        if (!level.method_8608() && (this.pushDirections.contains(direction) || this.pullDirections.contains(direction)) && this.needsCacheUpdate(level, pos, direction)) {
            this.updateCacheOnSide(level, pos, direction);
        }
    }

    private boolean needsCacheUpdate(class_1937 level, class_2338 pos, class_2350 direction) {
        ItemHandlerHolder holder = this.handlerCache.get(direction);
        if (holder == null || holder.handlers().isEmpty()) {
            return !level.method_8320(pos).method_26215();
        }
        if (holder.refreshOnEveryNeighborChange()) {
            return true;
        }
        for (BlockApiCache<Storage<ItemVariant>, class_2350> handler : holder.handlers()) {
            if (handler.find((Object)direction.method_10153()) != null) continue;
            return true;
        }
        return false;
    }

    public void updateCacheOnSide(class_1937 level, class_2338 pos, class_2350 direction) {
        List<class_2338> list;
        if (!(level.method_8477(pos) && level.method_8477(pos.method_10093(direction)) && level instanceof class_3218)) {
            this.handlerCache.remove(direction);
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        class_2680 storageState = level.method_8320(pos);
        class_2248 class_22482 = storageState.method_26204();
        if (class_22482 instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.method_10093(direction));
        }
        List<class_2338> offsetPositions = list;
        ArrayList<BlockApiCache<Storage<ItemVariant>, class_2350>> caches = new ArrayList<BlockApiCache<Storage<ItemVariant>, class_2350>>();
        AtomicBoolean refreshOnEveryNeighborChange = new AtomicBoolean(false);
        offsetPositions.forEach(offsetPos -> {
            offsetPos = level.method_35230(offsetPos, ModBlocks.STORAGE_INPUT_BLOCK_ENTITY_TYPE).flatMap(storageInputBlockEntity -> {
                refreshOnEveryNeighborChange.set(true);
                return storageInputBlockEntity.getControllerPos();
            }).orElse(offsetPos);
            caches.add(BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)serverLevel, (class_2338)offsetPos));
        });
        this.handlerCache.put(direction, new ItemHandlerHolder(caches, refreshOnEveryNeighborChange.get()));
    }

    private List<Storage<ItemVariant>> getItemHandlers(class_1937 level, class_2338 pos, class_2350 direction, boolean useCache) {
        if (useCache && !this.handlerCache.containsKey(direction)) {
            this.updateCacheOnSide(level, pos, direction);
        }
        return this.handlerCache.containsKey(direction) ? this.handlerCache.get(direction).handlers().stream().map(handlerCache -> (Storage)handlerCache.find((Object)direction.method_10153())).filter(Objects::nonNull).toList() : Collections.emptyList();
    }

    public ContentsFilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public ContentsFilterLogic getOutputFilterLogic() {
        return this.outputFilterLogic;
    }

    public boolean isPullingFrom(class_2350 direction) {
        return this.pullDirections.contains(direction);
    }

    public boolean isPushingTo(class_2350 direction) {
        return this.pushDirections.contains(direction);
    }

    public void setPullingFrom(class_2350 direction, boolean shouldPull) {
        if (shouldPull) {
            this.pullDirections.add(direction);
        } else {
            this.pullDirections.remove(direction);
        }
        this.serializePullDirections();
    }

    public void setPushingTo(class_2350 direction, boolean isPushing) {
        if (isPushing) {
            this.pushDirections.add(direction);
        } else {
            this.pushDirections.remove(direction);
        }
        this.serializePushDirections();
    }

    private void serializePullDirections() {
        NBTHelper.putList((class_2487)this.upgrade.method_7948(), (String)"pullDirections", this.pullDirections, d -> class_2519.method_23256((String)d.method_15434()));
        this.save();
    }

    private void serializePushDirections() {
        NBTHelper.putList((class_2487)this.upgrade.method_7948(), (String)"pushDirections", this.pushDirections, d -> class_2519.method_23256((String)d.method_15434()));
        this.save();
    }

    public void deserialize() {
        this.pullDirections.clear();
        this.pushDirections.clear();
        if (this.upgrade.method_7985()) {
            this.pullDirections = NBTHelper.getCollection((class_2487)this.upgrade.method_7948(), (String)"pullDirections", (byte)8, t -> Optional.ofNullable(class_2350.method_10168((String)t.method_10714())), HashSet::new).orElseGet(HashSet::new);
            this.pushDirections = NBTHelper.getCollection((class_2487)this.upgrade.method_7948(), (String)"pushDirections", (byte)8, t -> Optional.ofNullable(class_2350.method_10168((String)t.method_10714())), HashSet::new).orElseGet(HashSet::new);
        }
    }

    public void initDirections(class_2350 pushDirection, class_2350 pullDirection) {
        this.setPushingTo(pushDirection, true);
        this.setPullingFrom(pullDirection, true);
    }

    private record ItemHandlerHolder(List<BlockApiCache<Storage<ItemVariant>, class_2350>> handlers, boolean refreshOnEveryNeighborChange) {
    }
}

