/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.util;

import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5253;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;

public class DecorationHelper {
    public static final int BLOCK_TOTAL_PARTS = 24;
    private static final int MAIN_COLOR_PARTS = 18;
    private static final int ACCENT_COLOR_PARTS = 6;
    private static final Map<BarrelMaterial, Integer> DECORATIVE_SLOT_PARTS_NEEDED = Map.of(BarrelMaterial.TOP_INNER_TRIM, 1, BarrelMaterial.TOP_TRIM, 1, BarrelMaterial.SIDE_TRIM, 4, BarrelMaterial.BOTTOM_TRIM, 1, BarrelMaterial.TOP, 3, BarrelMaterial.SIDE, 12, BarrelMaterial.BOTTOM, 3);

    private DecorationHelper() {
    }

    public static Optional<class_2960> getMaterialLocation(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return Optional.of(class_7923.field_41175.method_10221((Object)blockItem.method_7711()));
        }
        return Optional.empty();
    }

    public static boolean consumeDyes(int mainColorBeingSet, int accentColorBeingSet, Map<class_2960, Integer> remainingParts, List<Storage<ItemVariant>> dyes, Integer storageMainColor, Integer storageAccentColor, TransactionContext ctx) {
        Map<class_6862<class_1792>, Integer> partsNeeded = DecorationHelper.getDyePartsNeeded(mainColorBeingSet, accentColorBeingSet, storageMainColor, storageAccentColor);
        if (partsNeeded.isEmpty()) {
            return true;
        }
        return DecorationHelper.consumeDyePartsNeeded(partsNeeded, dyes, remainingParts, ctx).hasEnough();
    }

    public static Map<class_6862<class_1792>, Integer> getDyePartsNeeded(int mainColorBeingSet, int accentColorBeingSet, int storageMainColor, int storageAccentColor) {
        return DecorationHelper.getDyePartsNeeded(mainColorBeingSet, accentColorBeingSet, storageMainColor, storageAccentColor, 18, 6);
    }

    public static Map<class_6862<class_1792>, Integer> getDyePartsNeeded(int mainColorBeingSet, int accentColorBeingSet, int storageMainColor, int storageAccentColor, int mainColorParts, int accentColorParts) {
        int[] rgbPartsNeeded;
        HashMap<class_6862<class_1792>, Integer> partsNeeded = new HashMap<class_6862<class_1792>, Integer>();
        if (mainColorBeingSet != -1 && mainColorBeingSet != storageMainColor) {
            rgbPartsNeeded = DecorationHelper.calculateRGBPartsNeeded(mainColorBeingSet, mainColorParts);
            DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded, partsNeeded);
        }
        if (accentColorBeingSet != -1 && accentColorBeingSet != storageAccentColor) {
            rgbPartsNeeded = DecorationHelper.calculateRGBPartsNeeded(accentColorBeingSet, accentColorParts);
            DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded, partsNeeded);
        }
        return partsNeeded;
    }

    private static void addPartsNeededIfAny(int[] rgbPartsNeeded, Map<class_6862<class_1792>, Integer> partsNeeded) {
        DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded[0], partsNeeded, (class_6862<class_1792>)ConventionalItemTags.RED_DYES);
        DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded[1], partsNeeded, (class_6862<class_1792>)ConventionalItemTags.GREEN_DYES);
        DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded[2], partsNeeded, (class_6862<class_1792>)ConventionalItemTags.BLUE_DYES);
    }

    private static void addPartsNeededIfAny(int parts, Map<class_6862<class_1792>, Integer> partsNeeded, class_6862<class_1792> dyeName) {
        if (parts != 0) {
            partsNeeded.compute(dyeName, (location, partsTotal) -> partsTotal == null ? parts : partsTotal + parts);
        }
    }

    private static int[] calculateRGBPartsNeeded(int color, int totalParts) {
        int i2;
        float[] ratios = new float[]{(float)class_5253.class_5254.method_27765((int)color) / 255.0f, (float)class_5253.class_5254.method_27766((int)color) / 255.0f, (float)class_5253.class_5254.method_27767((int)color) / 255.0f};
        float totalRaios = ratios[0] + ratios[1] + ratios[2];
        ratios[0] = ratios[0] / totalRaios;
        ratios[1] = ratios[1] / totalRaios;
        ratios[2] = ratios[2] / totalRaios;
        int n = ratios.length;
        int[] result = new int[n];
        double[] remainders = new double[n];
        double[] scaled = new double[n];
        for (int i3 = 0; i3 < n; ++i3) {
            scaled[i3] = ratios[i3] * (float)totalParts;
            result[i3] = (int)scaled[i3];
            remainders[i3] = scaled[i3] - (double)result[i3];
        }
        int remaining = totalParts - Arrays.stream(result).sum();
        Integer[] indices = new Integer[n];
        for (i2 = 0; i2 < n; ++i2) {
            indices[i2] = i2;
        }
        Arrays.sort(indices, Comparator.comparingDouble(i -> -remainders[i]));
        for (i2 = 0; i2 < remaining; ++i2) {
            int n2 = indices[i2 % n];
            result[n2] = result[n2] + 1;
        }
        return result;
    }

    public static boolean consumeMaterials(Map<class_2960, Integer> remainingParts, List<Storage<ItemVariant>> decorativeBlocks, Map<BarrelMaterial, class_2960> originalMaterials, Map<BarrelMaterial, class_2960> materials, TransactionContext ctx) {
        Map<class_2960, Integer> partsNeeded = DecorationHelper.getMaterialPartsNeeded(originalMaterials, materials);
        return DecorationHelper.consumeMaterialPartsNeeded(partsNeeded, remainingParts, decorativeBlocks, ctx).hasEnough();
    }

    public static ConsumptionResult consumeMaterialPartsNeeded(Map<class_2960, Integer> partsNeeded, Map<class_2960, Integer> remainingParts, List<Storage<ItemVariant>> decorativeBlocks, TransactionContext ctx) {
        return DecorationHelper.consumePartsNeeded(partsNeeded, decorativeBlocks, location -> location, (materialLocation, stack) -> DecorationHelper.getMaterialLocation(stack).map(ml -> ml.equals(materialLocation)).orElse(false), remainingParts, ctx);
    }

    public static Map<class_2960, Integer> getMaterialPartsNeeded(Map<BarrelMaterial, class_2960> originalMaterials, Map<BarrelMaterial, class_2960> materialsToApply) {
        HashMap<class_2960, Integer> partsNeeded = new HashMap<class_2960, Integer>();
        BarrelBlockItem.uncompactMaterials(materialsToApply);
        class_2960 topInnerTrimMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.TOP_INNER_TRIM, null, partsNeeded, originalMaterials);
        class_2960 topTrimMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.TOP_TRIM, topInnerTrimMaterialLocation, partsNeeded, originalMaterials);
        class_2960 sideTrimMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.SIDE_TRIM, topTrimMaterialLocation, partsNeeded, originalMaterials);
        DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.BOTTOM_TRIM, sideTrimMaterialLocation, partsNeeded, originalMaterials);
        class_2960 topMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.TOP, topTrimMaterialLocation, partsNeeded, originalMaterials);
        class_2960 sideMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.SIDE, topMaterialLocation, partsNeeded, originalMaterials);
        DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.BOTTOM, sideMaterialLocation, partsNeeded, originalMaterials);
        return partsNeeded;
    }

    @Nullable
    private static class_2960 addMaterialCostForSlotAndGetMaterial(Map<BarrelMaterial, class_2960> materials, BarrelMaterial barrelMaterial, @Nullable class_2960 defaultMaterialLocation, Map<class_2960, Integer> partsNeeded, Map<BarrelMaterial, class_2960> originalMaterials) {
        boolean materialIsTheSame = Objects.deepEquals(originalMaterials.get((Object)barrelMaterial), materials.get((Object)barrelMaterial));
        boolean newHasNoMaterial = !materials.containsKey((Object)barrelMaterial);
        boolean hasNoCost = barrelMaterial == BarrelMaterial.TOP_TRIM && defaultMaterialLocation != null || materialIsTheSame || newHasNoMaterial;
        class_2960 materialLocation = materials.getOrDefault((Object)barrelMaterial, defaultMaterialLocation);
        if (hasNoCost) {
            return materialLocation;
        }
        if (materialLocation != null) {
            int parts = DECORATIVE_SLOT_PARTS_NEEDED.get((Object)barrelMaterial);
            partsNeeded.compute(materialLocation, (key, value) -> value == null ? parts : value + parts);
        }
        return materialLocation;
    }

    public static ConsumptionResult consumeDyePartsNeeded(Map<class_6862<class_1792>, Integer> partsNeeded, List<Storage<ItemVariant>> resourceHandlers, Map<class_2960, Integer> remainingParts, TransactionContext ctx) {
        return DecorationHelper.consumePartsNeeded(partsNeeded, resourceHandlers, class_6862::comp_327, (dyeName, stack) -> stack.method_31573(dyeName), remainingParts, ctx);
    }

    private static <T> ConsumptionResult consumePartsNeeded(Map<T, Integer> partsNeeded, List<Storage<ItemVariant>> resourceHandlers, Function<T, class_2960> locationGetter, BiPredicate<T, class_1799> stackMatcher, Map<class_2960, Integer> remainingParts, TransactionContext ctx) {
        HashMap<class_2960, Integer> missingParts = new HashMap<class_2960, Integer>();
        for (Map.Entry<T, Integer> entry : partsNeeded.entrySet()) {
            SingleItemConsumptionResult singleItemConsumptionResult;
            T material = entry.getKey();
            Integer parts = entry.getValue();
            class_2960 materialLocation = locationGetter.apply(material);
            int remainingPartCount = remainingParts.getOrDefault(materialLocation, 0);
            if (remainingPartCount > parts) {
                int finalParts = parts;
                TransactionCallback.onSuccess((TransactionContext)ctx, () -> remainingParts.put(materialLocation, remainingPartCount - finalParts));
                continue;
            }
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> remainingParts.remove(materialLocation));
            if (remainingPartCount == parts || (singleItemConsumptionResult = DecorationHelper.consumeFromHandlers(resourceHandlers, stackMatcher, remainingParts, ctx, material, parts = Integer.valueOf(parts - remainingPartCount), materialLocation)).hasEnough()) continue;
            missingParts.put(materialLocation, singleItemConsumptionResult.countMissing());
        }
        return new ConsumptionResult(missingParts.isEmpty(), missingParts);
    }

    private static <T> SingleItemConsumptionResult consumeFromHandlers(List<Storage<ItemVariant>> resourceHandlers, BiPredicate<T, class_1799> stackMatcher, Map<class_2960, Integer> remainingParts, TransactionContext ctx, T material, Integer parts, class_2960 materialLocation) {
        for (Storage<ItemVariant> resources : resourceHandlers) {
            for (StorageView view : resources.nonEmptyViews()) {
                class_1799 stack = ((ItemVariant)view.getResource()).toStack((int)view.getAmount());
                if (!stackMatcher.test(material, stack)) continue;
                int toRemove = (int)Math.ceil((double)parts.intValue() / 24.0);
                long removed = resources.extract((Object)((ItemVariant)view.getResource()), (long)toRemove, ctx);
                int partsRemoved = (int)removed * 24;
                if (partsRemoved >= parts) {
                    int finalParts = parts;
                    TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
                        if (partsRemoved > finalParts) {
                            remainingParts.put(materialLocation, partsRemoved - finalParts);
                        }
                    });
                    return new SingleItemConsumptionResult(true, 0);
                }
                parts = parts - partsRemoved;
            }
        }
        return new SingleItemConsumptionResult(false, parts);
    }

    public record ConsumptionResult(boolean hasEnough, Map<class_2960, Integer> missingParts) {
    }

    private record SingleItemConsumptionResult(boolean hasEnough, int countMissing) {
    }
}

