/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.SimplePacketBase;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class TransferItemsMessage
extends SimplePacketBase {
    private final boolean transferToInventory;
    private final boolean filterByContents;

    public TransferItemsMessage(boolean transferToInventory, boolean filterByContents) {
        this.transferToInventory = transferToInventory;
        this.filterByContents = filterByContents;
    }

    public TransferItemsMessage(class_2540 packetBuffer) {
        this(packetBuffer.readBoolean(), packetBuffer.readBoolean());
    }

    @Override
    public void write(class_2540 packetBuffer) {
        packetBuffer.writeBoolean(this.transferToInventory);
        packetBuffer.writeBoolean(this.filterByContents);
    }

    @Override
    public boolean handle(SimplePacketBase.Context context) {
        context.enqueueWork(() -> {
            class_3222 player = context.getSender();
            class_1703 patt2181$temp = player.field_7512;
            if (!(patt2181$temp instanceof StorageContainerMenuBase)) {
                return;
            }
            StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)patt2181$temp;
            Object storageWrapper = storageMenu.getStorageWrapper();
            if (this.transferToInventory) {
                if (this.filterByContents) {
                    TransferItemsMessage.mergeToPlayersInventoryFiltered((class_1657)player, storageWrapper);
                } else {
                    TransferItemsMessage.mergeToPlayersInventory(storageWrapper, (class_1657)player);
                }
            } else {
                InventoryHelper.transfer((Storage<ItemVariant>)new PlayerMainInvWithoutHotbarWrapper(player.method_31548()), (Storage<ItemVariant>)new FilteredStorageItemHandler((IStorageWrapper)storageWrapper, this.filterByContents), s -> {}, null);
            }
        });
        return true;
    }

    private static void mergeToPlayersInventory(IStorageWrapper storageWrapper, class_1657 player) {
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)storageWrapper.getInventoryHandler(), (slot, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            class_1799 result = InventoryHelper.mergeIntoPlayerInventory(player, stack, 9);
            if (result.method_7947() != stack.method_7947()) {
                storageWrapper.getInventoryHandler().setStackInSlot((int)slot, result);
            }
        });
    }

    private static void mergeToPlayersInventoryFiltered(class_1657 player, IStorageWrapper storageWrapper) {
        Set<ItemStackKey> uniqueStacks = InventoryHelper.getUniqueStacks((Storage<ItemVariant>)new PlayerMainInvWrapper(player.method_31548()));
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)storageWrapper.getInventoryHandler(), (slot, stack) -> {
            if (stack.method_7960() || !uniqueStacks.contains(ItemStackKey.of(stack))) {
                return;
            }
            class_1799 result = InventoryHelper.mergeIntoPlayerInventory(player, stack, 0);
            if (result.method_7947() != stack.method_7947()) {
                storageWrapper.getInventoryHandler().setStackInSlot((int)slot, result);
            }
        });
    }

    public boolean transferToInventory() {
        return this.transferToInventory;
    }

    public boolean filterByContents() {
        return this.filterByContents;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransferItemsMessage that = (TransferItemsMessage)obj;
        return this.transferToInventory == that.transferToInventory && this.filterByContents == that.filterByContents;
    }

    public int hashCode() {
        return Objects.hash(this.transferToInventory, this.filterByContents);
    }

    public String toString() {
        return "TransferItemsMessage[transferToInventory=" + this.transferToInventory + ", filterByContents=" + this.filterByContents + "]";
    }

    private static class PlayerMainInvWrapper
    extends RangedWrapper {
        private final class_1661 inventoryPlayer;

        public PlayerMainInvWrapper(class_1661 inv) {
            super(inv, 0, inv.field_7547.size());
            this.inventoryPlayer = inv;
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert(resource, maxAmount, transaction);
            if (inserted != maxAmount && !this.getInventoryPlayer().field_7546.method_37908().field_9236 && this.getInventoryPlayer().field_7546 instanceof class_3222) {
                this.getInventoryPlayer().field_7546.field_7512.method_7623();
            }
            return inserted;
        }

        public class_1661 getInventoryPlayer() {
            return this.inventoryPlayer;
        }
    }

    private static class PlayerMainInvWithoutHotbarWrapper
    extends RangedWrapper {
        private final class_1661 inventoryPlayer;

        public PlayerMainInvWithoutHotbarWrapper(class_1661 inv) {
            super(inv, 9, inv.field_7547.size());
            this.inventoryPlayer = inv;
        }

        public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
            class_1799 inSlot;
            long inserted = super.insertSlot(slot, resource, maxAmount, transaction);
            if (inserted != maxAmount && !(inSlot = this.getStackInSlot(slot)).method_7960()) {
                if (this.getInventoryPlayer().field_7546.method_37908().field_9236) {
                    inSlot.method_7912(5);
                } else if (this.getInventoryPlayer().field_7546 instanceof class_3222) {
                    this.getInventoryPlayer().field_7546.field_7512.method_7623();
                }
            }
            return 0L;
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert(resource, maxAmount, transaction);
            if (inserted != maxAmount && !this.getInventoryPlayer().field_7546.method_37908().field_9236 && this.getInventoryPlayer().field_7546 instanceof class_3222) {
                this.getInventoryPlayer().field_7546.field_7512.method_7623();
            }
            return inserted;
        }

        public class_1661 getInventoryPlayer() {
            return this.inventoryPlayer;
        }
    }

    private static class FilteredStorageItemHandler
    extends FilteredItemHandler<ITrackedContentsItemHandler>
    implements IItemHandlerSimpleInserter {
        private final IStorageWrapper storageWrapper;

        public FilteredStorageItemHandler(IStorageWrapper storageWrapper, boolean smart) {
            super(storageWrapper.getInventoryHandler(), smart);
            this.storageWrapper = storageWrapper;
        }

        @Override
        protected Set<ItemStackKey> getUniqueStacks(ITrackedContentsItemHandler itemHandler) {
            return itemHandler.getTrackedStacks();
        }

        @Override
        protected boolean matchesFilter(class_1799 stack) {
            return super.matchesFilter(stack) || this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).matchesFilter(stack);
        }

        @Override
        public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!this.matchContents || this.matchesFilter(resource.toStack((int)maxAmount))) {
                return ((ITrackedContentsItemHandler)this.itemHandler).insert(resource, maxAmount, transaction);
            }
            return 0L;
        }

        @Override
        public void setStackInSlot(int slot, class_1799 stack) {
            ((ITrackedContentsItemHandler)this.itemHandler).setStackInSlot(slot, stack);
        }
    }

    private static class RangedWrapper
    implements IItemHandlerSimpleInserter {
        private final InventoryStorageImpl inventoryStorage;

        public RangedWrapper(class_1661 inv, int start, int end) {
            this.inventoryStorage = (InventoryStorageImpl)InventoryStorage.of((class_1263)inv, null);
            this.inventoryStorage.parts = Collections.unmodifiableList(this.inventoryStorage.parts.subList(start, end));
        }

        public int getSlotCount() {
            return this.inventoryStorage.getSlotCount();
        }

        public SingleSlotStorage<ItemVariant> getSlot(int slot) {
            return this.inventoryStorage.getSlot(slot);
        }

        public List<SingleSlotStorage<ItemVariant>> getSlots() {
            return this.inventoryStorage.parts;
        }

        public class_1799 getStackInSlot(int slot) {
            SingleSlotStorage<ItemVariant> s = this.getSlot(slot);
            return ((ItemVariant)s.getResource()).toStack((int)s.getAmount());
        }

        public void setStackInSlot(int slot, class_1799 stack) {
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return this.inventoryStorage.insert((Object)resource, maxAmount, transaction);
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return this.inventoryStorage.extract((Object)resource, maxAmount, transaction);
        }
    }

    private static class FilteredItemHandler<T extends IItemHandlerSimpleInserter>
    implements IItemHandlerSimpleInserter {
        protected final T itemHandler;
        protected final boolean matchContents;
        private final Set<ItemStackKey> uniqueStacks;

        public FilteredItemHandler(T itemHandler, boolean matchContents) {
            this.itemHandler = itemHandler;
            this.matchContents = matchContents;
            this.uniqueStacks = this.getUniqueStacks(itemHandler);
        }

        protected Set<ItemStackKey> getUniqueStacks(T itemHandler) {
            return InventoryHelper.getUniqueStacks(itemHandler);
        }

        public int getSlotCount() {
            return this.itemHandler.getSlotCount();
        }

        public SingleSlotStorage<ItemVariant> getSlot(int slot) {
            return this.itemHandler.getSlot(slot);
        }

        @Nonnull
        public class_1799 getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, class_1799 stack) {
        }

        public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!this.matchContents || this.matchesFilter(resource.toStack((int)maxAmount))) {
                return this.itemHandler.insertSlot(slot, resource, maxAmount, transaction);
            }
            return 0L;
        }

        protected boolean matchesFilter(class_1799 stack) {
            return this.uniqueStacks.contains(ItemStackKey.of(stack));
        }

        public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return this.itemHandler.extractSlot(slot, resource, maxAmount, transaction);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            return this.itemHandler.isItemValid(slot, resource, count);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!this.matchContents || this.matchesFilter(resource.toStack((int)maxAmount))) {
                return this.itemHandler.insert((Object)resource, maxAmount, transaction);
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return this.itemHandler.extract((Object)resource, maxAmount, transaction);
        }
    }
}

