/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public interface IUpgradeItem<T extends IUpgradeWrapper> {
    public UpgradeType<T> getType();

    default public UpgradeSlotChangeResult canAddUpgradeTo(IStorageWrapper storageWrapper, class_1799 upgradeStack, boolean firstLevelStorage, boolean isClientSide) {
        UpgradeSlotChangeResult result = this.checkUpgradePerStorageTypeLimit(storageWrapper);
        if (!result.isSuccessful()) {
            return result;
        }
        result = this.checkForConflictingUpgrades(storageWrapper, this.getUpgradeConflicts(), -1);
        if (!result.isSuccessful()) {
            return result;
        }
        result = this.checkThisForConflictsWithExistingUpgrades(upgradeStack, storageWrapper, -1);
        if (!result.isSuccessful()) {
            return result;
        }
        return this.checkExtraInsertConditions(upgradeStack, storageWrapper, isClientSide, null);
    }

    default public UpgradeSlotChangeResult checkThisForConflictsWithExistingUpgrades(class_1799 upgradeStack, IStorageWrapper storageWrapper, int excludeUpgradeSlot) {
        AtomicReference<UpgradeSlotChangeResult.Success> result = new AtomicReference<UpgradeSlotChangeResult.Success>(new UpgradeSlotChangeResult.Success());
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
            class_1792 patt1903$temp;
            if (slot != excludeUpgradeSlot && (patt1903$temp = stack.method_7909()) instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)patt1903$temp;
                for (UpgradeConflictDefinition conflictDefinition : upgradeItem.getUpgradeConflicts()) {
                    if (conflictDefinition.maxConflictingAllowed() != 0 || !conflictDefinition.isConflictingItem.test(upgradeStack.method_7909())) continue;
                    result.set((UpgradeSlotChangeResult.Success)((Object)new UpgradeSlotChangeResult.Fail(conflictDefinition.otherBeingAddedErrorMessage, Set.of(slot), Set.of(), Set.of())));
                    return;
                }
            }
        }, () -> !((UpgradeSlotChangeResult)result.get()).isSuccessful());
        return result.get();
    }

    private UpgradeSlotChangeResult checkForConflictingUpgrades(IStorageWrapper storageWrapper, List<UpgradeConflictDefinition> upgradeConflicts, int excludeUpgradeSlot) {
        for (UpgradeConflictDefinition conflictDefinition : upgradeConflicts) {
            AtomicInteger conflictingCount = new AtomicInteger(0);
            HashSet<Integer> conflictingSlots = new HashSet<Integer>();
            InventoryHelper.iterate((SlottedStorage<ItemVariant>)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
                if (slot != excludeUpgradeSlot && !stack.method_7960() && conflictDefinition.isConflictingItem.test(stack.method_7909())) {
                    conflictingCount.incrementAndGet();
                    conflictingSlots.add((Integer)slot);
                }
            });
            if (conflictingCount.get() <= conflictDefinition.maxConflictingAllowed) continue;
            return new UpgradeSlotChangeResult.Fail(conflictDefinition.errorMessage, conflictingSlots, Set.of(), Set.of());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    public List<UpgradeConflictDefinition> getUpgradeConflicts();

    private UpgradeSlotChangeResult checkUpgradePerStorageTypeLimit(IStorageWrapper storageWrapper) {
        int upgradesPerStorage = this.getUpgradesPerStorage(storageWrapper.getStorageType());
        int upgradesInGroupPerStorage = this.getUpgradesInGroupPerStorage(storageWrapper.getStorageType());
        if (upgradesPerStorage == Integer.MAX_VALUE && upgradesInGroupPerStorage == Integer.MAX_VALUE) {
            return new UpgradeSlotChangeResult.Success();
        }
        if (upgradesPerStorage == 0) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.upgrade_not_allowed", this.getName(), storageWrapper.getDisplayName()), Set.of(), Set.of(), Set.of());
        }
        if (upgradesInGroupPerStorage == 0) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.upgrade_not_allowed", class_2561.method_43471((String)this.getUpgradeGroup().translName()), storageWrapper.getDisplayName()), Set.of(), Set.of(), Set.of());
        }
        HashSet<Integer> slotsWithUpgrade = new HashSet<Integer>();
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
            if (stack.method_7909() == this) {
                slotsWithUpgrade.add((Integer)slot);
            }
        });
        if (slotsWithUpgrade.size() >= upgradesPerStorage) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.only_x_upgrades_allowed", upgradesPerStorage, this.getName(), storageWrapper.getDisplayName(), upgradesPerStorage), slotsWithUpgrade, Set.of(), Set.of());
        }
        HashSet<Integer> slotsWithUgradeGroup = new HashSet<Integer>();
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
            IUpgradeItem upgradeItem;
            class_1792 patt5226$temp = stack.method_7909();
            if (patt5226$temp instanceof IUpgradeItem && (upgradeItem = (IUpgradeItem)patt5226$temp).getUpgradeGroup() == this.getUpgradeGroup()) {
                slotsWithUgradeGroup.add((Integer)slot);
            }
        });
        if (slotsWithUgradeGroup.size() >= upgradesInGroupPerStorage) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.only_x_upgrades_allowed", upgradesInGroupPerStorage, class_2561.method_43471((String)this.getUpgradeGroup().translName()), storageWrapper.getDisplayName()), slotsWithUgradeGroup, Set.of(), Set.of());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    default public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide, class_1657 player) {
        return this.canRemoveUpgradeFrom(storageWrapper, isClientSide);
    }

    default public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide) {
        return new UpgradeSlotChangeResult.Success();
    }

    default public UpgradeSlotChangeResult canSwapUpgradeFor(class_1799 upgradeStackToPut, int upgradeSlot, IStorageWrapper storageWrapper, boolean isClientSide) {
        if (upgradeStackToPut.method_7909() == this) {
            return new UpgradeSlotChangeResult.Success();
        }
        class_1792 class_17922 = upgradeStackToPut.method_7909();
        if (class_17922 instanceof IUpgradeItem) {
            UpgradeSlotChangeResult result;
            int upgradesInGroupPerStorage;
            IUpgradeItem upgradeToPut = (IUpgradeItem)class_17922;
            int upgradesPerStorage = upgradeToPut.getUpgradesPerStorage(storageWrapper.getStorageType());
            if (upgradesPerStorage < (upgradesInGroupPerStorage = upgradeToPut.getUpgradesInGroupPerStorage(storageWrapper.getStorageType())) ? !(result = upgradeToPut.checkUpgradePerStorageTypeLimit(storageWrapper)).isSuccessful() : upgradeToPut.getUpgradeGroup() != this.getUpgradeGroup() && !(result = upgradeToPut.checkUpgradePerStorageTypeLimit(storageWrapper)).isSuccessful()) {
                return result;
            }
            result = this.checkForConflictingUpgrades(storageWrapper, upgradeToPut.getUpgradeConflicts(), upgradeSlot);
            if (!result.isSuccessful()) {
                return result;
            }
            return upgradeToPut.checkExtraInsertConditions(upgradeStackToPut, storageWrapper, isClientSide, this);
        }
        return new UpgradeSlotChangeResult.Success();
    }

    default public UpgradeSlotChangeResult checkExtraInsertConditions(class_1799 upgradeStack, IStorageWrapper storageWrapper, boolean isClientSide, @Nullable IUpgradeItem<?> upgradeInSlot) {
        return new UpgradeSlotChangeResult.Success();
    }

    default public int getInventoryColumnsTaken() {
        return 0;
    }

    default public class_1799 getCleanedUpgradeStack(class_1799 upgradeStack) {
        return upgradeStack;
    }

    public int getUpgradesPerStorage(String var1);

    public int getUpgradesInGroupPerStorage(String var1);

    default public UpgradeGroup getUpgradeGroup() {
        return UpgradeGroup.NONE;
    }

    public class_2561 getName();

    public record UpgradeConflictDefinition(Predicate<class_1792> isConflictingItem, int maxConflictingAllowed, class_2561 errorMessage, class_2561 otherBeingAddedErrorMessage) {
        public UpgradeConflictDefinition(Predicate<class_1792> isConflictingItem, int maxConflictingAllowed, class_2561 errorMessage) {
            this(isConflictingItem, maxConflictingAllowed, errorMessage, errorMessage);
        }
    }
}

