/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.crafting;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8566;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CraftingUpgradeContainer
extends UpgradeContainerBase<CraftingUpgradeWrapper, CraftingUpgradeContainer>
implements ICraftingContainer {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private static final String DATA_SELECT_RESULT = "selectResult";
    private final class_1731 craftResult = new class_1731();
    private final CraftingItemHandler craftMatrix;
    private final class_1734 craftingResultSlot;
    @Nullable
    private class_3955 lastRecipe = null;
    private List<class_3955> matchedCraftingRecipes = new ArrayList<class_3955>();
    private List<class_1799> matchedCraftingResults = new ArrayList<class_1799>();
    private int selectedCraftingResultIndex = 0;

    public CraftingUpgradeContainer(final class_1657 player, int upgradeContainerId, CraftingUpgradeWrapper upgradeWrapper, UpgradeContainerType<CraftingUpgradeWrapper, CraftingUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        int slot;
        for (slot = 0; slot < upgradeWrapper.getInventory().getSlotCount(); ++slot) {
            this.slots.add(new SlotSuppliedHandler(upgradeWrapper::getInventory, slot, -100, -100){

                public void method_7668() {
                    super.method_7668();
                    CraftingUpgradeContainer.this.updateCraftingResult(player.method_37908(), player, (class_8566)CraftingUpgradeContainer.this.craftMatrix, CraftingUpgradeContainer.this.craftResult, CraftingUpgradeContainer.this.craftingResultSlot);
                    CraftingUpgradeContainer.this.craftMatrix.method_5431();
                }
            });
        }
        this.craftMatrix = new CraftingItemHandler(upgradeWrapper::getInventory, this::onCraftMatrixChanged);
        this.craftingResultSlot = new class_1734(player, (class_8566)this.craftMatrix, (class_1263)this.craftResult, slot, -100, -100){

            public void method_7667(class_1657 thePlayer, class_1799 stack) {
                class_1799 remainingStack = this.method_7677();
                this.method_7669(stack);
                class_2371 items = CraftingUpgradeContainer.this.lastRecipe != null && CraftingUpgradeContainer.this.lastRecipe.method_8115((class_1263)CraftingUpgradeContainer.this.craftMatrix, player.method_37908()) ? CraftingUpgradeContainer.this.lastRecipe.method_8111((class_1263)CraftingUpgradeContainer.this.craftMatrix) : CraftingUpgradeContainer.this.craftMatrix.method_51305();
                for (int i = 0; i < items.size(); ++i) {
                    if (i >= 9) {
                        this.logErrorAndDropRemainingItems(i, (List<class_1799>)items);
                        break;
                    }
                    class_1799 itemstack = CraftingUpgradeContainer.this.craftMatrix.method_5438(i);
                    class_1799 itemstack1 = (class_1799)items.get(i);
                    if (!itemstack.method_7960()) {
                        CraftingUpgradeContainer.this.craftMatrix.method_5434(i, 1);
                        itemstack = CraftingUpgradeContainer.this.craftMatrix.method_5438(i);
                    }
                    if (itemstack1.method_7960()) continue;
                    if (itemstack.method_7960()) {
                        CraftingUpgradeContainer.this.craftMatrix.method_5447(i, itemstack1);
                        continue;
                    }
                    if (class_1799.method_31577((class_1799)itemstack, (class_1799)itemstack1)) {
                        itemstack1.method_7933(itemstack.method_7947());
                        CraftingUpgradeContainer.this.craftMatrix.method_5447(i, itemstack1);
                        continue;
                    }
                    if (player.method_31548().method_7394(itemstack1)) continue;
                    player.method_7328(itemstack1, false);
                }
                if (!remainingStack.method_7960()) {
                    player.method_7328(remainingStack, false);
                }
            }

            private void logErrorAndDropRemainingItems(int i, List<class_1799> items) {
                for (int j = i; j < items.size(); ++j) {
                    class_1799 remaining = items.get(j);
                    if (remaining.method_7960()) continue;
                    player.method_7328(remaining, false);
                }
                SophisticatedCore.LOGGER.error("Recipe " + String.valueOf(CraftingUpgradeContainer.this.lastRecipe != null ? CraftingUpgradeContainer.this.lastRecipe.method_8114() : "[unknown]") + " returned more than 9 remaining items, dropping the rest!");
            }

            public void method_7668() {
                super.method_7668();
                if (player.method_37908().method_8608()) {
                    CraftingUpgradeContainer.this.matchedCraftingRecipes.clear();
                    CraftingUpgradeContainer.this.matchedCraftingResults.clear();
                    if (!this.method_7677().method_7960()) {
                        CraftingUpgradeContainer.this.matchedCraftingRecipes = RecipeHelper.safeGetRecipesFor(class_3956.field_17545, CraftingUpgradeContainer.this.craftMatrix, player.method_37908());
                        int resultIndex = 0;
                        for (class_3955 craftingRecipe : CraftingUpgradeContainer.this.matchedCraftingRecipes) {
                            class_1799 result = craftingRecipe.method_8116((class_1263)CraftingUpgradeContainer.this.craftMatrix, player.method_37908().method_30349());
                            CraftingUpgradeContainer.this.matchedCraftingResults.add(result);
                            if (class_1799.method_31577((class_1799)this.method_7677(), (class_1799)result)) {
                                CraftingUpgradeContainer.this.selectedCraftingResultIndex = resultIndex;
                            }
                            ++resultIndex;
                        }
                    }
                }
            }
        };
        this.slots.add(this.craftingResultSlot);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.onCraftMatrixChanged((class_1263)this.craftMatrix);
    }

    private void onCraftMatrixChanged(class_1263 iInventory) {
        this.updateCraftingResult(this.player.method_37908(), this.player, (class_8566)this.craftMatrix, this.craftResult, this.craftingResultSlot);
    }

    private void updateCraftingResult(class_1937 level, class_1657 player, class_8566 inventory, class_1731 inventoryResult, class_1734 craftingResultSlot) {
        if (!level.field_9236) {
            class_3222 serverplayerentity = (class_3222)player;
            class_1799 itemstack = class_1799.field_8037;
            if (this.lastRecipe != null && this.lastRecipe.method_8115((class_1263)inventory, level)) {
                itemstack = this.lastRecipe.method_8116((class_1263)inventory, level.method_30349());
            } else {
                List recipes = RecipeHelper.safeGetRecipesFor(class_3956.field_17545, inventory, level);
                if (!recipes.isEmpty()) {
                    this.matchedCraftingRecipes = recipes;
                    this.matchedCraftingResults.clear();
                    this.selectedCraftingResultIndex = 0;
                    class_3955 craftingRecipe = this.matchedCraftingRecipes.get(0);
                    if (inventoryResult.method_7665(level, serverplayerentity, (class_1860)craftingRecipe)) {
                        this.lastRecipe = craftingRecipe;
                        itemstack = this.lastRecipe.method_8116((class_1263)inventory, level.method_30349());
                        this.matchedCraftingResults.add(itemstack.method_7972());
                    } else {
                        this.lastRecipe = null;
                    }
                    for (int i = 1; i < this.matchedCraftingRecipes.size(); ++i) {
                        this.matchedCraftingResults.add(this.matchedCraftingRecipes.get(i).method_8116((class_1263)inventory, level.method_30349()));
                    }
                }
            }
            craftingResultSlot.method_7673(itemstack);
        }
    }

    public List<class_1799> getMatchedCraftingResults() {
        return this.matchedCraftingResults;
    }

    public void selectNextCraftingResult() {
        if (this.matchedCraftingResults.size() > 1) {
            this.selectCraftingResult((this.selectedCraftingResultIndex + 1) % this.matchedCraftingResults.size());
        }
    }

    public void selectPreviousCraftingResult() {
        if (this.matchedCraftingResults.size() > 1) {
            this.selectCraftingResult((this.selectedCraftingResultIndex + this.matchedCraftingResults.size() - 1) % this.matchedCraftingResults.size());
        }
    }

    public void selectCraftingResult(int resultIndex) {
        if (resultIndex < 0 || resultIndex >= this.matchedCraftingResults.size()) {
            return;
        }
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            this.selectedCraftingResultIndex = resultIndex;
            this.lastRecipe = this.matchedCraftingRecipes.get(resultIndex);
            class_1799 result = this.matchedCraftingResults.get(resultIndex).method_7972();
            this.craftingResultSlot.method_7673(result);
            this.craftResult.method_7665(this.player.method_37908(), serverPlayer, (class_1860)this.lastRecipe);
        } else {
            this.sendDataToServer(() -> NBTHelper.putInt(new class_2487(), DATA_SELECT_RESULT, resultIndex));
        }
    }

    @Override
    public void handleMessage(class_2487 data) {
        if (data.method_10545(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.method_10577(DATA_SHIFT_CLICK_INTO_STORAGE));
        } else if (data.method_10545(DATA_SELECT_RESULT)) {
            this.selectCraftingResult(data.method_10550(DATA_SELECT_RESULT));
        }
    }

    @Override
    public class_1799 getSlotStackToTransfer(class_1735 slot) {
        if (slot == this.craftingResultSlot) {
            class_1799 slotStack = slot.method_7677();
            slotStack.method_7909().method_7843(slotStack, this.player.method_37908(), this.player);
            return slotStack;
        }
        return super.getSlotStackToTransfer(slot);
    }

    @Override
    public List<class_1735> getRecipeSlots() {
        return this.slots.subList(0, 9);
    }

    @Override
    public class_1263 getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public void setRecipeUsed(class_2960 recipeId) {
        if (this.lastRecipe != null && this.lastRecipe.method_8114().equals((Object)recipeId)) {
            return;
        }
        this.player.method_37908().method_8433().method_8130(recipeId).filter(r -> r.method_17716() == class_3956.field_17545).map(r -> (class_3955)r).ifPresent(recipe -> {
            this.lastRecipe = recipe;
            for (int i = 0; i < this.matchedCraftingRecipes.size(); ++i) {
                if (!this.matchedCraftingRecipes.get(i).method_8114().equals((Object)recipeId)) continue;
                this.selectCraftingResult(i);
                return;
            }
        });
    }

    @Override
    public class_3956<?> getRecipeType() {
        return class_3956.field_17545;
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((CraftingUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((CraftingUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new class_2487(), DATA_SHIFT_CLICK_INTO_STORAGE, shiftClickIntoStorage));
    }

    @Override
    public boolean mergeIntoStorageFirst(class_1735 slot) {
        return !(slot instanceof class_1734) || this.shouldShiftClickIntoStorage();
    }

    @Override
    public boolean allowsPickupAll(class_1735 slot) {
        return slot != this.craftingResultSlot;
    }
}

