/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel;

import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.accessors.ProgramSetAccessor;
import dev.djefrey.colorwheel.engine.ClrwlEngine;
import dev.djefrey.colorwheel.util.AccumulateTimer;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.lib.backend.SimpleBackend;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Optional;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.minecraft.class_1936;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class ClrwlBackend {
    public static final Backend IRIS_INSTANCING = SimpleBackend.builder().engineFactory(level -> new ClrwlEngine((class_1936)level, 256)).priority(500).supported(() -> GlCompat.SUPPORTS_INSTANCING && ClrwlBackend.isUsingCompatibleShaderPack()).register(Colorwheel.rl("instancing"));
    private static final AccumulateTimer ACCUMULATE_INCOMPATIBLE = new AccumulateTimer(0.5f);

    public static void init() {
    }

    public static boolean isUsingCompatibleShaderPack() {
        Optional pack = Iris.getCurrentPack();
        if (pack.isEmpty()) {
            return false;
        }
        if (!Colorwheel.CONFIG.isFallbackModeEnabled()) {
            String name = Iris.getCurrentPackName();
            ProgramSet programSet = ((ShaderPack)pack.get()).getProgramSet(Iris.getCurrentDimension());
            boolean isFallback = ((ProgramSetAccessor)programSet).colorwheel$isFallbackMode();
            if (isFallback) {
                if (Colorwheel.CONFIG.shouldAlertIncompatiblePack()) {
                    ACCUMULATE_INCOMPATIBLE.request(() -> {
                        Optional<String> patch = ClrwlBackend.findPatchedShaderpack(name);
                        Colorwheel.sendEmptyMessage();
                        class_5250 packComp = class_2561.method_43470((String)name).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
                        Colorwheel.sendErrorMessage((class_2561)class_2561.method_43469((String)"colorwheel.alert.incompatible_pack", (Object[])new Object[]{packComp}), true);
                        if (patch.isPresent()) {
                            class_5250 patchComp = class_2561.method_43470((String)patch.get()).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
                            Colorwheel.sendErrorMessage((class_2561)class_2561.method_43469((String)"colorwheel.alert.incompatible_pack.patch_available", (Object[])new Object[]{patchComp}), false);
                        } else {
                            class_5250 fallbackComp = class_2561.method_43471((String)"colorwheel.fallback_mode").method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11745, "/colorwheel enableFallbackMode on")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"colorwheel.fallback_mode.enable"))));
                            Colorwheel.sendErrorMessage((class_2561)class_2561.method_43469((String)"colorwheel.alert.incompatible_pack.ask_fallback_mode", (Object[])new Object[]{fallbackComp}), false);
                        }
                        class_5250 disableComp = class_2561.method_43471((String)"colorwheel.alert.ask_disable").method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11745, "/colorwheel alertIncompatiblePack off")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"colorwheel.alert.incompatible_pack.disable"))));
                        Colorwheel.sendEmptyMessage();
                        Colorwheel.sendErrorMessage((class_2561)disableComp, false);
                        Colorwheel.sendEmptyMessage();
                    });
                }
                return false;
            }
        }
        WorldRenderingPipeline worldPipeline = Iris.getPipelineManager().getPipelineNullable();
        return worldPipeline instanceof IrisRenderingPipeline;
    }

    public static Optional<String> findPatchedShaderpack(String shaderpack) {
        Path shaderpackFolder = Iris.getShaderpacksDirectory();
        try {
            Optional maybePatch;
            Class<?> clazz = Class.forName("dev.djefrey.colorwheel_patcher.ClrwlPatcher");
            Method method = clazz.getMethod("findPatchedShaderpackInFolder", String.class, Path.class);
            Object res = method.invoke(null, shaderpack, shaderpackFolder);
            if (res instanceof Optional && (maybePatch = (Optional)res).isPresent() && maybePatch.get() instanceof String) {
                return Optional.of((String)maybePatch.get());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

