/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.fabric;

import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.fabric.ClrwlConfigFabric;
import java.util.Collection;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModDependency;

public final class ClrwlFabric
implements ModInitializer {
    public void onInitialize() {
        boolean hasFlywheel = ClrwlFabric.hasFlywheel();
        if (hasFlywheel && !ClrwlFabric.isFlywheelVersionSupported()) {
            throw new RuntimeException("Flywheel version is not compatible with Colorwheel");
        }
        Colorwheel.init(hasFlywheel);
        if (hasFlywheel) {
            ClrwlConfigFabric.INSTANCE.load();
        }
    }

    public static boolean hasFlywheel() {
        return FabricLoader.getInstance().isModLoaded("flywheel");
    }

    public static boolean isFlywheelVersionSupported() {
        Collection dependencies = ((ModContainer)FabricLoader.getInstance().getModContainer("colorwheel").get()).getMetadata().getDependencies();
        Version flwVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("flywheel").get()).getMetadata().getVersion();
        for (ModDependency dep : dependencies) {
            if (!dep.getModId().equals("flywheel")) continue;
            return dep.matches(flwVersion);
        }
        throw new RuntimeException("Flywheel is not a dependency");
    }
}

