/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.p3pp3rf1y.porting_lib.base.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.BackpackWrapperLookup;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncClientInfoMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.MenuProviderHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public abstract class BackpackContext
implements MenuProviderHelper.ContextProvider {
    public abstract Optional<IStorageWrapper> getParentBackpackWrapper(class_1657 var1);

    public abstract boolean shouldLockBackpackSlot(class_1657 var1);

    public abstract IBackpackWrapper getBackpackWrapper(class_1657 var1);

    public abstract int getBackpackSlotIndex();

    public abstract BackpackContext getSubBackpackContext(int var1);

    public abstract BackpackContext getParentBackpackContext();

    public abstract ContextType getType();

    public void toBuffer(class_2540 packetBuffer) {
        this.getType().toBuffer(packetBuffer);
        this.addToBuffer(packetBuffer);
    }

    public abstract void addToBuffer(class_2540 var1);

    public abstract boolean canInteractWith(class_1657 var1);

    public class_2338 getBackpackPosition(class_1657 playerEntity) {
        return playerEntity.method_24515();
    }

    public class_2561 getDisplayName(class_1657 player) {
        return this.getBackpackWrapper(player).getBackpack().method_7964();
    }

    public abstract void onUpgradeChanged(class_1657 var1);

    public static BackpackContext fromBuffer(class_2540 buffer, class_1937 level) {
        ContextType type = ContextType.fromBuffer(buffer);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ContextType.BLOCK_BACKPACK -> Block.fromBuffer(buffer);
            case ContextType.BLOCK_SUB_BACKPACK -> BlockSubBackpack.fromBuffer(buffer);
            case ContextType.ITEM_SUB_BACKPACK -> ItemSubBackpack.fromBuffer(buffer);
            case ContextType.ITEM_BACKPACK -> Item.fromBuffer(buffer);
            case ContextType.ANOTHER_PLAYER_BACKPACK -> AnotherPlayer.fromBuffer(buffer, level);
            case ContextType.ANOTHER_PLAYER_SUB_BACKPACK -> AnotherPlayerSubBackpack.fromBuffer(buffer, level);
        };
    }

    public boolean wasOpenFromInventory() {
        return false;
    }

    public static enum ContextType {
        BLOCK_BACKPACK(0),
        BLOCK_SUB_BACKPACK(1),
        ITEM_BACKPACK(2),
        ITEM_SUB_BACKPACK(3),
        ANOTHER_PLAYER_BACKPACK(4),
        ANOTHER_PLAYER_SUB_BACKPACK(5);

        private final int id;
        private static final Map<Integer, ContextType> ID_CONTEXTS;

        private ContextType(int id) {
            this.id = id;
        }

        public void toBuffer(class_2540 buffer) {
            buffer.writeShort(this.id);
        }

        public static ContextType fromBuffer(class_2540 buffer) {
            return ID_CONTEXTS.getOrDefault(buffer.readShort(), ITEM_BACKPACK);
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (ContextType value : ContextType.values()) {
                builder.put((Object)value.id, (Object)value);
            }
            ID_CONTEXTS = builder.build();
        }
    }

    public static class Block
    extends BackpackContext {
        protected final class_2338 pos;

        public Block(class_2338 pos) {
            this.pos = pos;
        }

        @Override
        public class_2338 getBackpackPosition(class_1657 playerEntity) {
            return this.pos;
        }

        @Override
        public void onUpgradeChanged(class_1657 player) {
            if (!player.method_37908().field_9236) {
                WorldHelper.getBlockEntity((class_1922)player.method_37908(), (class_2338)this.pos, BackpackBlockEntity.class).ifPresent(BackpackBlockEntity::refreshRenderState);
            }
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(class_1657 player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot(class_1657 player) {
            return false;
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(class_1657 player) {
            return WorldHelper.getBlockEntity((class_1922)player.method_37908(), (class_2338)this.pos, BackpackBlockEntity.class).map(BackpackBlockEntity::getBackpackWrapper).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public int getBackpackSlotIndex() {
            return -1;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new BlockSubBackpack(this.pos, subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        public static BackpackContext fromBuffer(class_2540 packetBuffer) {
            return new Block(class_2338.method_10092((long)packetBuffer.readLong()));
        }

        @Override
        public void addToBuffer(class_2540 packetBuffer) {
            packetBuffer.writeLong(this.pos.method_10063());
        }

        @Override
        public boolean canInteractWith(class_1657 player) {
            return player.method_37908().method_8321(this.pos) instanceof BackpackBlockEntity && player.method_5649((double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5) <= 64.0;
        }

        @Override
        public ContextType getType() {
            return ContextType.BLOCK_BACKPACK;
        }
    }

    public static class BlockSubBackpack
    extends Block {
        private final int subBackpackSlotIndex;
        @Nullable
        private IStorageWrapper parentWrapper;

        public BlockSubBackpack(class_2338 pos, int subBackpackSlotIndex) {
            super(pos);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(class_1657 player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(class_1657 player) {
            return this.getParentBackpackWrapper(player).map(parent -> (IBackpackWrapper)BackpackWrapperLookup.get(parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex)).orElse((Object)IBackpackWrapper.Noop.INSTANCE)).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        public static BackpackContext fromBuffer(class_2540 packetBuffer) {
            return new BlockSubBackpack(class_2338.method_10092((long)packetBuffer.readLong()), packetBuffer.readInt());
        }

        @Override
        public void addToBuffer(class_2540 packetBuffer) {
            super.addToBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Block(this.pos);
        }

        @Override
        public ContextType getType() {
            return ContextType.BLOCK_SUB_BACKPACK;
        }

        @Override
        public class_2561 getDisplayName(class_1657 player) {
            return class_2561.method_43470((String)("... > " + super.getDisplayName(player).getString()));
        }

        @Override
        public void onUpgradeChanged(class_1657 player) {
        }
    }

    public static class ItemSubBackpack
    extends Item {
        private final int subBackpackSlotIndex;
        @Nullable
        private IStorageWrapper parentWrapper;

        public ItemSubBackpack(String handlerName, String identifier, int backpackSlotIndex, boolean parentOpenFromInventory, int subBackpackSlotIndex) {
            super(handlerName, identifier, backpackSlotIndex, parentOpenFromInventory);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(class_1657 player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(class_1657 player) {
            return this.getParentBackpackWrapper(player).map(parent -> (IBackpackWrapper)BackpackWrapperLookup.get(parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex)).orElse((Object)IBackpackWrapper.Noop.INSTANCE)).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        public static BackpackContext fromBuffer(class_2540 packetBuffer) {
            return new ItemSubBackpack(packetBuffer.method_19772(), packetBuffer.method_19772(), packetBuffer.readInt(), packetBuffer.readBoolean(), packetBuffer.readInt());
        }

        @Override
        public void addToBuffer(class_2540 packetBuffer) {
            super.addToBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Item(this.handlerName, this.identifier, this.backpackSlotIndex, super.wasOpenFromInventory());
        }

        @Override
        public ContextType getType() {
            return ContextType.ITEM_SUB_BACKPACK;
        }

        @Override
        public class_2561 getDisplayName(class_1657 player) {
            return class_2561.method_43470((String)("... > " + super.getDisplayName(player).getString()));
        }

        @Override
        public void onUpgradeChanged(class_1657 player) {
        }
    }

    public static class Item
    extends BackpackContext {
        protected final String handlerName;
        protected String identifier;
        protected final int backpackSlotIndex;
        private final boolean openFromInventory;

        public Item(String handlerName, int backpackSlotIndex) {
            this(handlerName, "", backpackSlotIndex);
        }

        public Item(String handlerName, String identifier, int backpackSlotIndex) {
            this(handlerName, identifier, backpackSlotIndex, false);
        }

        public Item(String handlerName, String identifier, int backpackSlotIndex, boolean openFromInventory) {
            this.handlerName = handlerName;
            this.identifier = identifier;
            this.backpackSlotIndex = backpackSlotIndex;
            this.openFromInventory = openFromInventory;
        }

        @Override
        public boolean wasOpenFromInventory() {
            return this.openFromInventory;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(class_1657 player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot(class_1657 player) {
            return PlayerInventoryProvider.get().getPlayerInventoryHandler(this.handlerName).map(PlayerInventoryHandler::isVisibleInGui).orElse(false);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(class_1657 player) {
            Optional<PlayerInventoryHandler> inventoryHandler = PlayerInventoryProvider.get().getPlayerInventoryHandler(this.handlerName);
            if (inventoryHandler.isEmpty()) {
                SophisticatedBackpacks.LOGGER.error("Error getting backpack wrapper - Unable to find inventory handler for \"{}\"", (Object)this.handlerName);
                return IBackpackWrapper.Noop.INSTANCE;
            }
            class_1799 stack = inventoryHandler.get().getStackInSlot(player, this.identifier, this.backpackSlotIndex);
            if (stack.method_7960()) {
                return IBackpackWrapper.Noop.INSTANCE;
            }
            LazyOptional<IBackpackWrapper> backpackWrapper = BackpackWrapperLookup.get(stack);
            if (!backpackWrapper.isPresent()) {
                SophisticatedBackpacks.LOGGER.error("Error getting backpack wrapper - Unable to find backpack at slot index {} in \"{}\" inventory handler", (Object)this.backpackSlotIndex, (Object)this.handlerName);
                return IBackpackWrapper.Noop.INSTANCE;
            }
            return (IBackpackWrapper)backpackWrapper.orElse((Object)IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public void onUpgradeChanged(class_1657 player) {
            if (!player.method_37908().field_9236 && this.handlerName.equals("main")) {
                IBackpackWrapper backpackWrapper = this.getBackpackWrapper(player);
                SBPPacketHandler.sendToClient((class_3222)player, (Object)new SyncClientInfoMessage(this.backpackSlotIndex, backpackWrapper.getRenderInfo().getNbt(), backpackWrapper.getColumnsTaken()));
            }
        }

        @Override
        public int getBackpackSlotIndex() {
            return this.backpackSlotIndex;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new ItemSubBackpack(this.handlerName, this.identifier, this.backpackSlotIndex, this.openFromInventory, subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        @Override
        public ContextType getType() {
            return ContextType.ITEM_BACKPACK;
        }

        public static BackpackContext fromBuffer(class_2540 packetBuffer) {
            return new Item(packetBuffer.method_19772(), packetBuffer.method_19772(), packetBuffer.readInt(), packetBuffer.readBoolean());
        }

        @Override
        public void addToBuffer(class_2540 packetBuffer) {
            packetBuffer.method_10814(this.handlerName);
            packetBuffer.method_10814(this.identifier);
            packetBuffer.writeInt(this.backpackSlotIndex);
            packetBuffer.writeBoolean(this.openFromInventory);
        }

        @Override
        public boolean canInteractWith(class_1657 player) {
            return true;
        }
    }

    public static class AnotherPlayer
    extends Item {
        protected final class_1657 otherPlayer;

        public AnotherPlayer(String handlerName, String identifier, int backpackSlotIndex, class_1657 otherPlayer) {
            super(handlerName, identifier, backpackSlotIndex);
            this.otherPlayer = otherPlayer;
        }

        @Override
        public boolean shouldLockBackpackSlot(class_1657 player) {
            return false;
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(class_1657 player) {
            return super.getBackpackWrapper(this.otherPlayer);
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new AnotherPlayerSubBackpack(this.otherPlayer, this.handlerName, this.identifier, this.backpackSlotIndex, subBackpackSlotIndex);
        }

        @Override
        public void addToBuffer(class_2540 packetBuffer) {
            packetBuffer.writeInt(this.otherPlayer.method_5628());
            packetBuffer.method_10814(this.handlerName);
            packetBuffer.method_10814(this.identifier);
            packetBuffer.writeInt(this.backpackSlotIndex);
        }

        @Override
        public boolean canInteractWith(class_1657 player) {
            return player.method_5739((class_1297)this.otherPlayer) < 8.0f;
        }

        @Override
        public ContextType getType() {
            return ContextType.ANOTHER_PLAYER_BACKPACK;
        }

        @Override
        public class_2561 getDisplayName(class_1657 player) {
            return super.getDisplayName(this.otherPlayer);
        }

        public static BackpackContext fromBuffer(class_2540 packetBuffer, class_1937 level) {
            int playerId = packetBuffer.readInt();
            class_1657 otherPlayer = (class_1657)level.method_8469(playerId);
            return new AnotherPlayer(packetBuffer.method_19772(), packetBuffer.method_19772(), packetBuffer.readInt(), Objects.requireNonNull(otherPlayer));
        }
    }

    public static class AnotherPlayerSubBackpack
    extends AnotherPlayer {
        private final int subBackpackSlotIndex;
        @Nullable
        private IStorageWrapper parentWrapper;

        public AnotherPlayerSubBackpack(class_1657 otherPlayer, String handlerName, String identifier, int backpackSlotIndex, int subBackpackSlotIndex) {
            super(handlerName, identifier, backpackSlotIndex, otherPlayer);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(class_1657 player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(class_1657 player) {
            return this.getParentBackpackWrapper(this.otherPlayer).map(parent -> (IBackpackWrapper)BackpackWrapperLookup.get(parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex)).orElse((Object)IBackpackWrapper.Noop.INSTANCE)).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public void addToBuffer(class_2540 packetBuffer) {
            super.addToBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new AnotherPlayer(this.handlerName, this.identifier, this.backpackSlotIndex, this.otherPlayer);
        }

        @Override
        public ContextType getType() {
            return ContextType.ANOTHER_PLAYER_SUB_BACKPACK;
        }

        @Override
        public class_2561 getDisplayName(class_1657 player) {
            return class_2561.method_43470((String)("... > " + super.getDisplayName(player).getString()));
        }

        public static BackpackContext fromBuffer(class_2540 packetBuffer, class_1937 level) {
            int playerId = packetBuffer.readInt();
            class_1657 otherPlayer = (class_1657)level.method_8469(playerId);
            return new AnotherPlayerSubBackpack(Objects.requireNonNull(otherPlayer), packetBuffer.method_19772(), packetBuffer.method_19772(), packetBuffer.readInt(), packetBuffer.readInt());
        }

        @Override
        public void onUpgradeChanged(class_1657 player) {
        }
    }
}

