/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.impl;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import malte0811.ferritecore.impl.Deduplicator;
import malte0811.ferritecore.util.PredicateHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import org.apache.commons.lang3.tuple.Pair;

public class KeyValueConditionImpl {
    private static final Map<Pair<class_2769<?>, Comparable<?>>, Predicate<class_2680>> STATE_HAS_PROPERTY_CACHE = new ConcurrentHashMap();

    public static Predicate<class_2680> getPredicate(class_2689<class_2248, class_2680> stateContainer, String key, String value, Splitter splitter) {
        Predicate<class_2680> isMatchedState;
        List matchedStates;
        boolean invert;
        class_2769 property = stateContainer.method_11663(key);
        if (property == null) {
            throw new RuntimeException(String.format("Unknown property '%s' on '%s'", key, ((class_2248)stateContainer.method_11660()).toString()));
        }
        String valueNoInvert = value;
        boolean bl = invert = !valueNoInvert.isEmpty() && valueNoInvert.charAt(0) == '!';
        if (invert) {
            valueNoInvert = valueNoInvert.substring(1);
        }
        if ((matchedStates = splitter.splitToList((CharSequence)valueNoInvert)).isEmpty()) {
            throw new RuntimeException(String.format("Empty value '%s' for property '%s' on '%s'", value, key, ((class_2248)stateContainer.method_11660()).toString()));
        }
        if (matchedStates.size() == 1) {
            isMatchedState = KeyValueConditionImpl.getBlockStatePredicate(stateContainer, property, valueNoInvert, key, value);
        } else {
            List subPredicates = matchedStates.stream().map(subValue -> KeyValueConditionImpl.getBlockStatePredicate(stateContainer, property, subValue, key, value)).collect(Collectors.toCollection(ArrayList::new));
            PredicateHelper.canonize(subPredicates);
            isMatchedState = Deduplicator.or(subPredicates);
        }
        return invert ? isMatchedState.negate() : isMatchedState;
    }

    private static <T extends Comparable<T>> Predicate<class_2680> getBlockStatePredicate(class_2689<class_2248, class_2680> container, class_2769<T> property, String subValue, String key, String value) {
        Optional optional = property.method_11900(subValue);
        if (optional.isEmpty()) {
            throw new RuntimeException(String.format("Unknown value '%s' for property '%s' on '%s' in '%s'", subValue, key, ((class_2248)container.method_11660()).toString(), value));
        }
        Comparable unwrapped = (Comparable)optional.get();
        return STATE_HAS_PROPERTY_CACHE.computeIfAbsent(Pair.of(property, (Object)unwrapped), pair -> {
            Comparable valueInt = (Comparable)pair.getRight();
            class_2769 propInt = (class_2769)pair.getLeft();
            return state -> state.method_11654(propInt).equals(valueInt);
        });
    }
}

