/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.resource.LoadedLightSourceResource;
import dev.yumi.commons.Unit;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LightSourceLoader<L>
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|LightSourceLoader");
    protected static final String SILENCE_ERROR_KEY = "silence_error";
    private final class_310 client = class_310.method_1551();
    protected final List<LoadedLightSourceResource> loadedLightSources = new ArrayList<LoadedLightSourceResource>();
    protected List<L> lightSources = List.of();

    protected abstract Logger getLogger();

    protected abstract String getResourcePath();

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.load(resourceManager);
            return Unit.INSTANCE;
        }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(reloadState -> {
            if (this.client.field_1687 != null) {
                this.apply(this.client.field_1687.method_30349());
            }
        }, applyExecutor);
    }

    protected void load(class_3300 resourceManager) {
        this.loadedLightSources.clear();
        resourceManager.method_14488("dynamiclights/" + this.getResourcePath(), path -> path.method_12832().endsWith(".json")).forEach(this::load);
    }

    public final void apply(class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        ArrayList lightSources = this.loadedLightSources.stream().filter(this::canApply).map(data -> this.apply((DynamicOps<JsonElement>)ops, (LoadedLightSourceResource)data)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ArrayList::new));
        this.doApply(registryAccess, lightSources);
        this.lightSources = lightSources;
    }

    protected void doApply(class_5455 registryAccess, List<L> lightSources) {
    }

    protected void load(class_2960 resourceId, class_3298 resource) {
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonElement rawJson = JsonParser.parseReader((Reader)reader);
            if (!rawJson.isJsonObject()) {
                LambDynLights.warn(this.getLogger(), "Failed to load {} light source \"{}\". Expected JSON object in file.", this.getResourcePath(), id);
                return;
            }
            JsonObject json = rawJson.getAsJsonObject();
            boolean silentError = false;
            if (json.has(SILENCE_ERROR_KEY)) {
                silentError = json.get(SILENCE_ERROR_KEY).getAsBoolean();
                json.remove(SILENCE_ERROR_KEY);
            }
            this.loadedLightSources.add(new LoadedLightSourceResource(id, json, silentError));
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.warn(this.getLogger(), "Failed to load {} light source \"{}\".", this.getResourcePath(), id, e);
        }
    }

    @NotNull
    protected abstract Optional<L> apply(DynamicOps<JsonElement> var1, LoadedLightSourceResource var2);

    protected boolean canApply(LoadedLightSourceResource loadedData) {
        if (loadedData.data().has("fabric:load_conditions")) {
            return ResourceConditions.objectMatchesConditions((JsonObject)loadedData.data());
        }
        if (loadedData.data().has("global_conditions")) {
            return LightSourceLoader.matchesMoonlightConditionsHack(loadedData.data());
        }
        return true;
    }

    private static boolean matchesMoonlightConditionsHack(JsonObject object) {
        try {
            JsonArray conditions = class_3518.method_15292((JsonObject)object, (String)"global_conditions", null);
            if (conditions == null) {
                return true;
            }
            return ResourceConditions.conditionsMatch((JsonArray)conditions, (boolean)true);
        }
        catch (RuntimeException exception) {
            return false;
        }
    }
}

