/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.entity;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.LambDynLightsConstants;
import dev.lambdaurora.lambdynlights.api.entity.EntityLightSource;
import dev.lambdaurora.lambdynlights.api.entity.EntityLightSourceManager;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.resource.LightSourceLoader;
import dev.lambdaurora.lambdynlights.resource.LoadedLightSourceResource;
import dev.lambdaurora.lambdynlights.resource.entity.luminance.ArrowItemDerivedLuminance;
import dev.lambdaurora.lambdynlights.resource.entity.luminance.CreeperLuminance;
import dev.lambdaurora.lambdynlights.resource.entity.luminance.DisplayEntityLuminance;
import dev.lambdaurora.lambdynlights.resource.item.ItemLightSources;
import dev.yumi.commons.event.Event;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityLightSources
extends LightSourceLoader<EntityLightSource>
implements EntityLightSourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|EntityLightSources");
    private static final class_2960 RESOURCE_RELOADER_ID = LambDynLights.id("entity_dynamic_lights");
    private static final List<class_2960> RESOURCE_RELOADER_DEPENDENCIES = List.of(ItemLightSources.RESOURCE_RELOADER_ID);
    public static final EntityLuminance.Type ARROW_ITEM_DERIVED = EntityLuminance.Type.registerSimple((class_2960)LambDynLights.id("arrow/derived_from_self_item"), (EntityLuminance)ArrowItemDerivedLuminance.INSTANCE);
    public static final EntityLuminance.Type CREEPER = EntityLuminance.Type.registerSimple((class_2960)LambDynLights.id("creeper"), (EntityLuminance)CreeperLuminance.INSTANCE);
    public static final EntityLuminance.Type DISPLAY = EntityLuminance.Type.register((class_2960)LambDynLights.id("display"), DisplayEntityLuminance.CODEC);
    public static final EntityLuminance.Type BLOCK_DISPLAY = EntityLuminance.Type.registerSimple((class_2960)LambDynLights.id("display/block"), (EntityLuminance)DisplayEntityLuminance.BlockDisplayLuminance.INSTANCE);
    public static final EntityLuminance.Type ITEM_DISPLAY = EntityLuminance.Type.registerSimple((class_2960)LambDynLights.id("display/item"), (EntityLuminance)DisplayEntityLuminance.ItemDisplayLuminance.INSTANCE);
    private final Event<class_2960, EntityLightSourceManager.OnRegister> onRegisterEvent = LambDynLights.EVENT_MANAGER.create(EntityLightSourceManager.OnRegister.class);
    private final ItemLightSourceManager itemLightSourceManager;

    public EntityLightSources(ItemLightSourceManager itemLightSourceManager) {
        this.itemLightSourceManager = itemLightSourceManager;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public class_2960 getFabricId() {
        return RESOURCE_RELOADER_ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return RESOURCE_RELOADER_DEPENDENCIES;
    }

    @Override
    protected String getResourcePath() {
        return "entity";
    }

    @Override
    protected void doApply(final class_5455 registryAccess, final List<EntityLightSource> lightSources) {
        ((EntityLightSourceManager.OnRegister)this.onRegisterEvent.invoker()).onRegister(new EntityLightSourceManager.RegisterContext(){

            @NotNull
            public class_5455 registryAccess() {
                return registryAccess;
            }

            public void register(@NotNull EntityLightSource entityLightSource) {
                lightSources.add(entityLightSource);
            }
        });
    }

    @Override
    @NotNull
    protected Optional<EntityLightSource> apply(DynamicOps<JsonElement> ops, LoadedLightSourceResource loadedData) {
        DataResult loaded = EntityLightSource.CODEC.parse(ops, (Object)loadedData.data());
        if (!loadedData.silenceError() || LambDynLightsConstants.FORCE_LOG_ERRORS) {
            loaded.error().ifPresent(error -> LambDynLights.warn(LOGGER, "Failed to load entity light source \"{}\" due to error: {}", loadedData.id(), error.message()));
        }
        return loaded.result();
    }

    @NotNull
    public Event<class_2960, EntityLightSourceManager.OnRegister> onRegisterEvent() {
        return this.onRegisterEvent;
    }

    public int getLuminance(@NotNull class_1297 entity) {
        int luminance = 0;
        for (EntityLightSource data : this.lightSources) {
            if (luminance == 15) break;
            if (!data.predicate().test(entity)) continue;
            luminance = Math.max(luminance, data.getLuminance(this.itemLightSourceManager, entity));
        }
        return luminance;
    }
}

