/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigSpec;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigType;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.ConfigBuilderImpl;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class ConfigBuilder {
    protected final Map<String, String> comments = new HashMap<String, String>();
    private String currentComment;
    private String currentKey;
    protected boolean synced;
    protected Runnable changeCallback;
    private final class_2960 name;
    protected final ConfigType type;
    public static final Predicate<Object> STRING_CHECK = o -> o instanceof String;
    public static final Predicate<Object> LIST_STRING_CHECK = s -> {
        if (s instanceof List) {
            return ((Collection)s).stream().allMatch(o -> o instanceof String);
        }
        return false;
    };
    public static final Predicate<Object> COLOR_CHECK = s -> {
        try {
            Integer.parseUnsignedInt(((String)s).replace("0x", ""), 16);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ConfigBuilder create(class_2960 name, ConfigType type) {
        void var1_1;
        return ConfigBuilderImpl.create(name, (ConfigType)var1_1);
    }

    public ConfigBuilder(class_2960 name, ConfigType type) {
        this.name = name;
        this.type = type;
    }

    public ConfigSpec buildAndRegister() {
        ConfigSpec spec = this.build();
        spec.register();
        return spec;
    }

    public abstract ConfigSpec build();

    public class_2960 getName() {
        return this.name;
    }

    public abstract ConfigBuilder push(String var1);

    public abstract ConfigBuilder pop();

    public abstract Supplier<Boolean> define(String var1, boolean var2);

    public abstract Supplier<Double> define(String var1, double var2, double var4, double var6);

    public abstract Supplier<Integer> define(String var1, int var2, int var3, int var4);

    public abstract Supplier<Integer> defineColor(String var1, int var2);

    public abstract Supplier<String> define(String var1, String var2, Predicate<Object> var3);

    public Supplier<String> define(String name, String defaultValue) {
        return this.define(name, defaultValue, STRING_CHECK);
    }

    public <T extends String> Supplier<List<String>> define(String name, List<? extends T> defaultValue) {
        return this.define(name, defaultValue, (Object s) -> true);
    }

    protected abstract String currentCategory();

    public abstract <T extends String> Supplier<List<String>> define(String var1, List<? extends T> var2, Predicate<Object> var3);

    public abstract <V extends Enum<V>> Supplier<V> define(String var1, V var2);

    @Deprecated(forRemoval=true)
    public abstract <T> Supplier<List<? extends T>> defineForgeList(String var1, List<? extends T> var2, Predicate<Object> var3);

    public class_2561 description(String name) {
        return class_2561.method_43471((String)this.translationKey(name));
    }

    public class_2561 tooltip(String name) {
        return class_2561.method_43471((String)this.tooltipKey(name));
    }

    public String tooltipKey(String name) {
        return name;
    }

    public String translationKey(String name) {
        return name;
    }

    public ConfigBuilder comment(String comment) {
        this.currentComment = comment;
        if (this.currentComment != null && this.currentKey != null) {
            this.comments.put(this.currentKey, this.currentComment);
            this.currentComment = null;
            this.currentKey = null;
        }
        return this;
    }

    public ConfigBuilder setSynced() {
        if (this.type == ConfigType.CLIENT) {
            throw new UnsupportedOperationException("Config syncing cannot be used for client config as its not needed");
        }
        this.synced = true;
        return this;
    }

    public ConfigBuilder onChange(Runnable callback) {
        this.changeCallback = callback;
        return this;
    }

    protected void maybeAddTranslationString(String name) {
        this.currentKey = this.tooltipKey(name);
        if (this.currentComment != null && this.currentKey != null) {
            this.comments.put(this.currentKey, this.currentComment);
            this.currentComment = null;
            this.currentKey = null;
        }
    }
}

