/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.configurations;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.class_2960;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigSettings;

public class BoundedFloatConfiguration
extends AbstractConfiguration<Float> {
    public BoundedFloatConfiguration(float defaultValue, ConfigSettings settings) {
        super(Float.valueOf(BoundedFloatConfiguration.validateDefaultValue(defaultValue)), settings);
    }

    private static float validateDefaultValue(float defaultValue) {
        if (defaultValue > 1.0f || defaultValue < 0.0f) {
            throw new IllegalArgumentException("Float Configurations cannot have a default value outside 0-1!");
        }
        return defaultValue;
    }

    @Override
    public Codec<Float> getValueCodec() {
        return Codec.either((Codec)Codec.FLOAT, (Codec)Codec.STRING.comapFlatMap(this::parseString, Object::toString)).xmap(either -> {
            if (either.left().isPresent()) {
                return (Float)either.left().get();
            }
            if (either.right().isPresent()) {
                return (Float)either.right().get();
            }
            return null;
        }, Either::left);
    }

    private DataResult<Float> parseString(String string) {
        try {
            return DataResult.success((Object)Float.valueOf(Float.parseFloat(string)));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "'" + string + "' cannot be parsed. " + e.getMessage());
        }
    }

    @Override
    protected class_2960 getConfigTypeId() {
        return PneumonoCore.location("bounded_float");
    }
}

