/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.configurations;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigSettings;

public class ValidatedStringConfiguration
extends AbstractConfiguration<String> {
    private final Predicate<String> predicate;

    public ValidatedStringConfiguration(String defaultValue, Predicate<String> predicate, ConfigSettings settings) {
        super(ValidatedStringConfiguration.validateDefaultValue(defaultValue, predicate), settings);
        this.predicate = predicate;
    }

    private static String validateDefaultValue(String defaultValue, Predicate<String> predicate) {
        if (!predicate.test(defaultValue)) {
            throw new IllegalArgumentException("Validated String Configurations cannot have a default value that does not pass its predicate!");
        }
        return defaultValue;
    }

    public boolean test(String string) {
        return this.predicate.test(string);
    }

    @Override
    public Codec<String> getValueCodec() {
        Function<String, String> function = string -> this.test((String)string) ? string : (String)this.info().getDefaultValue();
        return Codec.STRING.xmap(function, function);
    }

    @Override
    protected class_2960 getConfigTypeId() {
        return PneumonoCore.location("validated_string");
    }
}

