/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.MountingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.w3c.dom.Element;

public class StackLayout
extends BaseParentComponent {
    protected final List<Component> children = new ArrayList<Component>();
    protected final List<Component> childrenView = Collections.unmodifiableList(this.children);
    protected Size contentSize = Size.zero();

    protected StackLayout(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing);
    }

    @Override
    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.contentSize.width() + ((Insets)this.padding.get()).horizontal();
    }

    @Override
    protected int determineVerticalContentSize(Sizing sizing) {
        return this.contentSize.height() + ((Insets)this.padding.get()).vertical();
    }

    @Override
    public void layout(Size space) {
        Size childSpace = this.calculateChildSpace(space);
        this.children.forEach(child -> child.inflate(childSpace));
        MutableInt layoutWidth = new MutableInt();
        MutableInt layoutHeight = new MutableInt();
        ArrayList layout = new ArrayList();
        MountingHelper helper = MountingHelper.mountEarly((x$0, x$1, x$2) -> this.mountChild(x$0, x$1, x$2), this.childrenView, childSpace, child -> {
            child.mount(this, this.x + ((Insets)child.margins().get()).left(), this.y + ((Insets)child.margins().get()).top());
            layout.add(child);
            Size fullChildSize = child.fullSize();
            layoutWidth.setValue(Math.max(layoutWidth.getValue(), fullChildSize.width()));
            layoutHeight.setValue(Math.max(layoutHeight.getValue(), fullChildSize.height()));
        });
        this.contentSize = Size.of(layoutWidth.intValue(), layoutHeight.intValue());
        this.applySizing();
        HorizontalAlignment horizontalAlignment = this.horizontalAlignment();
        VerticalAlignment verticalAlignment = this.verticalAlignment();
        for (Component child2 : layout) {
            child2.updateX(child2.x() + horizontalAlignment.align(child2.fullSize().width(), this.width));
            child2.updateY(child2.y() + verticalAlignment.align(child2.fullSize().height(), this.height));
        }
        helper.mountLate();
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        this.drawChildren(context, mouseX, mouseY, partialTicks, delta, this.children);
    }

    public StackLayout child(Component child) {
        this.children.add(child);
        this.updateLayout();
        return this;
    }

    public StackLayout children(Collection<Component> children) {
        this.children.addAll(children);
        this.updateLayout();
        return this;
    }

    public StackLayout child(int index, Component child) {
        this.children.add(index, child);
        this.updateLayout();
        return this;
    }

    public StackLayout children(int index, Collection<Component> children) {
        this.children.addAll(index, children);
        this.updateLayout();
        return this;
    }

    @Override
    public StackLayout removeChild(Component child) {
        if (this.children.remove(child)) {
            child.dismount(Component.DismountReason.REMOVED);
            this.updateLayout();
        }
        return this;
    }

    public StackLayout clearChildren() {
        for (Component child : this.children) {
            child.dismount(Component.DismountReason.REMOVED);
        }
        this.children.clear();
        this.updateLayout();
        return this;
    }

    @Override
    public List<Component> children() {
        return this.childrenView;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        List components = UIParsing.get(children, "children", e -> UIParsing.allChildrenOfType(e, (short)1)).orElse(Collections.emptyList());
        for (Element child : components) {
            this.child(model.parseComponent(Component.class, child));
        }
    }
}

