/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_757;

public abstract class CannonChargeHud {
    protected final class_310 mc;

    protected CannonChargeHud(class_310 minecraft) {
        this.mc = minecraft;
    }

    public void render(class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        if (!this.mc.field_1690.field_1842 && CannonController.isActive()) {
            this.setupOverlayRenderState();
            class_2960 texture = ModTextures.CANNON_ICONS_TEXTURE;
            CannonBlockTile cannon = CannonController.cannon;
            this.renderHotBar(graphics, screenWidth, screenHeight, texture, cannon);
            CannonChargeHud.renderCrossHair(graphics, screenWidth, screenHeight, texture);
            this.renderBar(graphics, screenWidth, screenHeight, texture, cannon, partialTicks);
            CannonChargeHud.renderTrajectoryIcons(graphics, screenWidth, screenHeight, texture);
        }
    }

    private static void renderTrajectoryIcons(class_332 graphics, int screenWidth, int screenHeight, class_2960 texture) {
        int iconLeft = screenWidth / 2 + 96;
        int iconTop = screenHeight - 22;
        int iconW = 14;
        int iconU = CannonController.shootingMode.ordinal() * iconW;
        graphics.method_25302(texture, iconLeft, iconTop, iconU, 42, iconW, iconW);
        iconLeft = screenWidth / 2 - 110;
        iconU = CannonController.showsTrajectory ? 0 : 14;
        graphics.method_25302(texture, iconLeft, iconTop, iconU, 56, iconW, iconW);
    }

    private void renderHotBar(class_332 graphics, int screenWidth, int screenHeight, class_2960 texture, CannonBlockTile cannon) {
        int left = screenWidth / 2 - 91;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, -90.0f);
        graphics.method_25302(texture, left, screenHeight - 22, 0, 19, 182, 22);
        graphics.method_51448().method_22909();
        class_746 player = class_310.method_1551().field_1724;
        int k2 = screenHeight - 16 - 3;
        this.renderSlot(graphics, left + 1 + 47 + 2, k2, (class_1657)player, cannon.getProjectile(), 1);
        this.renderSlot(graphics, left + 1 + 113 + 2, k2, (class_1657)player, cannon.getFuel(), 1);
    }

    private void renderBar(class_332 graphics, int screenWidth, int screenHeight, class_2960 texture, CannonBlockTile cannon, float partialTicks) {
        int xpBarLeft = screenWidth / 2 - 91;
        float c = 1.0f - cannon.getCooldownAnimation(partialTicks);
        int k = (int)(c * 183.0f);
        int xpBarTop = screenHeight - 32 + 3;
        graphics.method_25302(texture, xpBarLeft, xpBarTop, 0, 0, 182, 5);
        float f = cannon.getFiringAnimation(partialTicks);
        float min = 0.7f;
        if (f > 0.0f) {
            f = 1.0f - f;
            float red = f * 0.4f + min;
            float green = min - f * 0.4f * min;
            float blue = min;
            RenderSystem.setShaderColor((float)red, (float)green, (float)(min - f * blue), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)min, (float)min, (float)min, (float)1.0f);
        }
        graphics.method_25302(texture, xpBarLeft, xpBarTop, 0, 5, k, 5);
        byte power = CannonController.cannon.getPowerLevel();
        int color = switch (power) {
            case 2 -> 0xFFAA00;
            case 3 -> 0xFF8800;
            case 4 -> 0xFF6600;
            default -> 0xFFCC00;
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String s = String.valueOf(power);
        int i1 = (screenWidth - this.mc.field_1772.method_1727(s)) / 2;
        int j1 = screenHeight - 31 - 4;
        graphics.method_51433(this.mc.field_1772, s, i1 + 1, j1, 0, false);
        graphics.method_51433(this.mc.field_1772, s, i1 - 1, j1, 0, false);
        graphics.method_51433(this.mc.field_1772, s, i1, j1 + 1, 0, false);
        graphics.method_51433(this.mc.field_1772, s, i1, j1 - 1, 0, false);
        graphics.method_51433(this.mc.field_1772, s, i1, j1, color, false);
    }

    private static void renderCrossHair(class_332 graphics, int screenWidth, int screenHeight, class_2960 texture) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, -90.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        int w = 9;
        int hitType = CannonController.shootingMode == ShootingMode.STRAIGHT ? 6 : (CannonController.trajectory == null || CannonController.trajectory.miss() ? 2 : 0);
        graphics.method_25302(texture, (screenWidth - w) / 2, (screenHeight - w) / 2, hitType * w, 10, w, w);
        RenderSystem.defaultBlendFunc();
        graphics.method_51448().method_22909();
    }

    public void setupOverlayRenderState() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
    }

    private void renderSlot(class_332 guiGraphics, int x, int y, class_1657 player, class_1799 itemStack, int seed) {
        if (!itemStack.method_7960()) {
            guiGraphics.method_51423((class_1309)player, itemStack, x, y, seed);
            guiGraphics.method_51431(this.mc.field_1772, itemStack, x, y);
        }
    }
}

