/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.client.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestOpenCannonGuiMessage;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_744;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class CannonController {
    protected static CannonBlockTile cannon;
    private static class_5498 lastCameraType;
    protected static class_239 hit;
    private static boolean firstTick;
    private static float yawIncrease;
    private static float pitchIncrease;
    private static boolean needsToUpdateServer;
    protected static ShootingMode shootingMode;
    @Nullable
    protected static CannonTrajectory trajectory;
    private static class_243 lastCameraPos;
    private static float lastZoomOut;
    private static float lastCameraYaw;
    private static float lastCameraPitch;
    protected static boolean showsTrajectory;

    public static void startControlling(CannonBlockTile tile) {
        firstTick = true;
        class_310 mc = class_310.method_1551();
        if (cannon == null) {
            cannon = tile;
            shootingMode = cannon.getTrajectoryData().drag() != 0.0f ? ShootingMode.DOWN : ShootingMode.STRAIGHT;
            lastCameraType = mc.field_1690.method_31044();
        }
        mc.field_1690.method_31043(class_5498.field_26665);
        mc.field_1705.method_1758((class_2561)class_2561.method_43469((String)"message.supplementaries.cannon_maneuver", (Object[])new Object[]{mc.field_1690.field_1832.method_16007(), mc.field_1690.field_1886.method_16007()}), false);
    }

    private static void stopControllingAndSync() {
        if (cannon == null) {
            return;
        }
        CannonBlockTile.syncToServer(cannon, false, true);
        CannonController.stopControlling();
    }

    public static void stopControlling() {
        if (cannon == null) {
            return;
        }
        cannon = null;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        lastZoomOut = 0.0f;
        lastCameraPos = null;
        if (lastCameraType != null) {
            class_310.method_1551().field_1690.method_31043(lastCameraType);
        }
    }

    public static boolean isActive() {
        return cannon != null;
    }

    public static boolean setupCamera(class_4184 camera, class_1922 level, class_1297 entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (CannonController.isActive()) {
            class_243 centerCannonPos = cannon.method_11016().method_46558();
            if (lastCameraPos == null) {
                lastCameraPos = camera.method_19326();
                lastCameraYaw = camera.method_19330();
                lastCameraPitch = camera.method_19329();
            }
            class_243 targetCameraPos = centerCannonPos.method_1031(0.0, 2.0, 0.0);
            float targetYRot = camera.method_19330() + yawIncrease;
            float targetXRot = class_3532.method_15363((float)(camera.method_19329() + pitchIncrease), (float)-90.0f, (float)90.0f);
            camera.method_19322(targetCameraPos);
            camera.method_19325(targetYRot, targetXRot);
            lastCameraPos = camera.method_19326();
            lastCameraYaw = camera.method_19330();
            lastCameraPitch = camera.method_19329();
            lastZoomOut = (float)camera.method_19318(4.0);
            float horizontalOffset = -1.0f;
            camera.method_19324((double)(-lastZoomOut), 0.0, (double)horizontalOffset);
            yawIncrease = 0.0f;
            pitchIncrease = 0.0f;
            if (!cannon.isFiring()) {
                class_243 lookDir2 = new class_243(camera.method_19335());
                float maxRange = 128.0f;
                class_243 actualCameraPos = camera.method_19326().method_1019(lookDir2.method_1029());
                class_243 endPos = actualCameraPos.method_1019(lookDir2.method_1021((double)maxRange));
                hit = level.method_17742(new class_3959(actualCameraPos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, entity));
                class_243 targetVector = hit.method_17784().method_1020(cannon.method_11016().method_46558());
                class_241 target = new class_241((float)class_3532.method_39241((double)targetVector.field_1352, (double)targetVector.field_1350), (float)targetVector.field_1351);
                target = target.method_35586(target.method_35581().method_35582(0.05f));
                float wantedCannonYaw = (float)Math.PI + (float)class_3532.method_15349((double)(-targetVector.field_1352), (double)targetVector.field_1350);
                CannonBlockTile.Restraint restraints = cannon.getPitchAndYawRestrains();
                IBallisticBehavior.Data ballistic = cannon.getTrajectoryData();
                trajectory = CannonTrajectory.findBest(target, ballistic.gravity(), ballistic.drag(), cannon.getFirePower() * ballistic.initialSpeed(), shootingMode, restraints.minPitch(), restraints.maxPitch());
                if (trajectory != null) {
                    CannonController.setCannonAngles(partialTick, wantedCannonYaw * 57.295776f);
                }
            }
            return true;
        }
        return false;
    }

    private static void setCannonAngles(float partialTick, float targetYawDeg) {
        float followSpeed = 1.0f;
        cannon.setRestrainedPitch(class_3532.method_17821((float)followSpeed, (float)cannon.getPitch(), (float)(trajectory.pitch() * 57.295776f)));
        cannon.setRenderYaw(targetYawDeg);
    }

    public static float ud(float a) {
        return a;
    }

    public static void onPlayerRotated(double yawAdd, double pitchAdd) {
        float scale = 0.2f;
        yawIncrease += (float)(yawAdd * (double)scale);
        pitchIncrease += (float)(pitchAdd * (double)scale);
        if (yawAdd != 0.0 || pitchAdd != 0.0) {
            needsToUpdateServer = true;
        }
    }

    public static void onKeyJump() {
        if (trajectory != null && trajectory.gravity() != 0.0f) {
            shootingMode = shootingMode.cycle();
            needsToUpdateServer = true;
        }
    }

    public static void onKeyInventory() {
        ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundRequestOpenCannonGuiMessage(cannon.method_11016()));
    }

    public static void onKeyShift() {
        CannonController.stopControllingAndSync();
    }

    public static void onMouseScrolled(double scrollDelta) {
        if (scrollDelta != 0.0) {
            cannon.changeFirePower((int)scrollDelta);
            needsToUpdateServer = true;
        }
    }

    public static void onPlayerAttack() {
        if (cannon != null && cannon.readyToFire()) {
            CannonBlockTile.syncToServer(cannon, true, false);
        }
    }

    public static void onPlayerUse() {
        showsTrajectory = !showsTrajectory;
    }

    public static void onInputUpdate(class_744 input) {
        if (firstTick) {
            firstTick = false;
            input.field_3909 = false;
            input.field_3904 = false;
            input.field_3910 = false;
            input.field_3908 = false;
            input.field_3906 = false;
            input.field_3903 = false;
            input.field_3905 = 0.0f;
            input.field_3907 = 0.0f;
        }
    }

    public static void onClientTick(class_310 mc) {
        if (!CannonController.isActive()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1937 level = player.method_37908();
        class_2338 pos = cannon.method_11016();
        float maxDist = 7.0f;
        if (level.method_8321(pos) == cannon && !cannon.method_11015() && pos.method_19770((class_2374)player.method_19538()) < (double)(maxDist * maxDist)) {
            if (needsToUpdateServer) {
                needsToUpdateServer = false;
                CannonBlockTile.syncToServer(cannon, false, false);
            }
        } else {
            CannonController.stopControllingAndSync();
        }
    }

    static {
        firstTick = true;
        shootingMode = ShootingMode.DOWN;
        lastZoomOut = 0.0f;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        showsTrajectory = true;
    }
}

