/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.BumblezoneCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2292;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class SugarBlock
extends class_2292 {
    public SugarBlock(class_4970.class_2251 properties) {
        super(class_2246.field_10382, properties);
    }

    public void method_10127(class_1937 level, class_2338 pos, class_2680 blockState, class_2680 blockState2, class_1540 fallingBlock) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.method_9588(blockState, serverLevel, pos, level.field_9229);
        }
        if (this.isWater(blockState2)) {
            // empty if block
        }
    }

    public void method_9504(class_2680 state, class_1937 level, class_2338 pos, class_1959.class_1963 precipitation) {
        super.method_9504(state, level, pos, precipitation);
        if (precipitation == class_1959.class_1963.field_9382 && CommonConfigs.Building.SUGAR_CUBE_RAIN.get().booleanValue()) {
            level.method_8427(pos, state.method_26204(), 1, 0);
        }
    }

    public class_2680 method_9605(class_1750 context) {
        return this.method_9564();
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        level.method_39279(currentPos, (class_2248)this, this.method_26154());
        return state;
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (this.touchesLiquid((class_1922)level, pos)) {
            level.method_8427(pos, state.method_26204(), 1, 0);
        } else {
            super.method_9588(state, level, pos, random);
        }
    }

    public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int id, int param) {
        if (id == 1) {
            if (level.field_9236) {
                this.spawnDissolveParticles(level, pos);
            }
            if (this.shouldTurnToWater(level, pos)) {
                SugarBlock.turnIntoWater(level, pos);
            } else {
                level.method_8650(pos, false);
            }
            return true;
        }
        return super.method_9592(state, level, pos, id, param);
    }

    private static void turnIntoWater(class_1937 level, class_2338 pos) {
        if (CompatHandler.BUMBLEZONE) {
            BumblezoneCompat.turnToSugarWater(level, pos);
        } else {
            level.method_8501(pos, class_2246.field_10382.method_9564());
        }
    }

    private boolean shouldTurnToWater(class_1937 level, class_2338 pos) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        int count = 0;
        for (class_2350 direction : class_2350.values()) {
            if (direction == class_2350.field_11033) continue;
            mutableBlockPos.method_25505((class_2382)pos, direction);
            class_2680 s = level.method_8320((class_2338)mutableBlockPos);
            if (this.isWater(s) && (direction == class_2350.field_11036 || s.method_26227().method_15771())) {
                ++count;
            }
            if (count < 2) continue;
            return true;
        }
        return false;
    }

    private boolean touchesLiquid(class_1922 level, class_2338 pos) {
        boolean bl = false;
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
        if (this.isWater(blockState)) {
            return true;
        }
        for (class_2350 direction : class_2350.values()) {
            if (direction == class_2350.field_11033) continue;
            mutableBlockPos.method_25505((class_2382)pos, direction);
            blockState = level.method_8320((class_2338)mutableBlockPos);
            if (!this.isWater(blockState) || blockState.method_26206(level, pos, direction.method_10153())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isWater(class_2680 state) {
        return state.method_26227().method_15767(class_3486.field_15517);
    }

    public void spawnDissolveParticles(class_1937 level, class_2338 pos) {
        boolean d = false;
        boolean e = false;
        boolean f = false;
        int amount = 4;
        for (int ax = 0; ax < amount; ++ax) {
            for (int ay = 0; ay < amount; ++ay) {
                for (int az = 0; az < amount; ++az) {
                    double s = ((double)ax + 0.5) / (double)amount;
                    double t = ((double)ay + 0.5) / (double)amount;
                    double u = ((double)az + 0.5) / (double)amount;
                    double px = s + (double)d;
                    double py = t + (double)e;
                    double pz = u + (double)f;
                    level.method_8406((class_2394)ModParticles.SUGAR_PARTICLE.get(), (double)pos.method_10263() + px, (double)pos.method_10264() + py, (double)pos.method_10260() + pz, s - 0.5, 0.0, u - 0.5);
                }
            }
        }
    }

    public int method_10130(class_2680 state, class_1922 level, class_2338 pos) {
        return state.method_26205((class_1922)level, (class_2338)pos).field_16011;
    }

    protected void method_33614(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
        if (level.field_9236) {
            this.spawnDissolveParticles(level, pos);
        }
        class_2498 soundtype = state.method_26231();
        level.method_8396(null, pos, soundtype.method_10595(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
    }
}

