/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.events.ClientEvents;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1900;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class BombExplosion
extends class_1927 {
    private final BombEntity.BombType bombType;
    private final class_5362 damageCalculator;
    private static final class_5362 EXPLOSION_DAMAGE_CALCULATOR = new class_5362();

    public BombExplosion(class_1937 world, @Nullable class_1297 entity, @Nullable class_5362 context, double x, double y, double z, BombEntity.BombType bombType, class_1927.class_4179 interaction) {
        super(world, entity, null, context, x, y, z, (float)bombType.getRadius(), false, interaction);
        this.bombType = bombType;
        this.damageCalculator = context == null ? this.bombMakeDamageCalculator(entity) : context;
        this.field_9193 = ModDamageSources.bombExplosion(this.method_46406(), (class_1297)this.method_8347());
    }

    public BombExplosion(class_1937 level, @Nullable class_1297 source, double toBlowX, double toBlowY, double toBlowZ, float radius, List<class_2338> toBlow, BombEntity.BombType bombType) {
        super(level, source, toBlowX, toBlowY, toBlowZ, radius, toBlow);
        this.bombType = bombType;
        this.damageCalculator = this.bombMakeDamageCalculator(source);
    }

    private class_5362 bombMakeDamageCalculator(@Nullable class_1297 entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new class_5361(entity);
    }

    public BombEntity.BombType bombType() {
        return this.bombType;
    }

    public ObjectArrayList<class_2338> getToBlow() {
        return (ObjectArrayList)super.method_8346();
    }

    public void method_8350(boolean spawnParticles) {
        boolean interactsWithBlocks = this.method_46667();
        if (this.field_9187.field_9236) {
            ClientEvents.onExplosion(this);
            this.field_9187.method_8486(this.field_9195, this.field_9192, this.field_9189, ModSounds.BOMB_EXPLOSION.get(), class_3419.field_15245, this.bombType.volume(), 1.2f + (this.field_9187.field_9229.method_43057() - this.field_9187.field_9229.method_43057()) * 0.2f, false);
            if (spawnParticles) {
                if (!(this.field_9190 < 1.5f) && interactsWithBlocks) {
                    this.field_9187.method_8406((class_2394)ModParticles.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), this.field_9195, this.field_9192, this.field_9189, (double)this.field_9190, 0.0, 0.0);
                } else {
                    this.field_9187.method_8406((class_2394)ModParticles.BOMB_EXPLOSION_PARTICLE.get(), this.field_9195, this.field_9192, this.field_9189, 1.0, 0.0, 0.0);
                }
            }
            this.bombType.spawnExtraParticles(this.field_9195, this.field_9192, this.field_9189, this.field_9187);
        }
        ObjectArrayList drops = new ObjectArrayList();
        class_156.method_43028(this.getToBlow(), (class_5819)this.field_9187.field_9229);
        if (!interactsWithBlocks) {
            return;
        }
        for (class_2338 blockpos : this.getToBlow()) {
            class_1937 class_19372;
            class_2680 blockstate = this.field_9187.method_8320(blockpos);
            if (blockstate.method_26215()) continue;
            class_2338 immutable = blockpos.method_10062();
            this.field_9187.method_16107().method_15396("explosion_blocks");
            if (ForgeHelper.canDropFromExplosion((class_2680)blockstate, (class_1937)this.field_9187, (class_2338)blockpos, (class_1927)this) && (class_19372 = this.field_9187) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_2586 blockEntity = blockstate.method_31709() ? this.field_9187.method_8321(blockpos) : null;
                class_8567.class_8568 builder = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockpos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)blockEntity).method_51877(class_181.field_1226, (Object)this.field_9185);
                if (this.field_9184 == class_1927.class_4179.field_18687) {
                    builder.method_51874(class_181.field_1225, (Object)Float.valueOf(this.field_9190));
                }
                blockstate.method_26189(builder).forEach(stack -> BombExplosion.method_24023((ObjectArrayList)drops, (class_1799)stack, (class_2338)immutable));
            }
            ForgeHelper.onBlockExploded((class_2680)blockstate, (class_1937)this.field_9187, (class_2338)blockpos, (class_1927)this);
            this.field_9187.method_16107().method_15407();
        }
        for (Pair pair : drops) {
            class_2248.method_9577((class_1937)this.field_9187, (class_2338)((class_2338)pair.getSecond()), (class_1799)((class_1799)pair.getFirst()));
        }
    }

    public void method_8348() {
        class_1657 pl;
        class_1676 pr;
        class_1657 owner;
        this.field_9187.method_33596(this.field_9185, class_5712.field_28178, class_2338.method_49637((double)this.field_9195, (double)this.field_9192, (double)this.field_9189));
        HashSet set = Sets.newHashSet();
        class_1297 class_12972 = this.field_9185;
        class_1657 class_16572 = owner = class_12972 instanceof class_1676 && (class_12972 = (pr = (class_1676)class_12972).method_24921()) instanceof class_1657 ? (pl = (class_1657)class_12972) : null;
        if (this.field_9184 != class_1927.class_4179.field_40878) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.field_9195;
                        double d6 = this.field_9192;
                        double d8 = this.field_9189;
                        float f1 = 0.3f;
                        for (float f = this.field_9190 * (0.7f + this.field_9187.field_9229.method_43057() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            class_3610 fluidstate;
                            class_2680 blockstate;
                            class_2338 blockpos = class_2338.method_49637((double)d4, (double)d6, (double)d8);
                            Optional optional = this.damageCalculator.method_29555((class_1927)this, (class_1922)this.field_9187, blockpos, blockstate = this.field_9187.method_8320(blockpos), fluidstate = this.field_9187.method_8316(blockpos));
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.damageCalculator.method_29554((class_1927)this, (class_1922)this.field_9187, blockpos, blockstate, f) && (owner == null || !CompatHandler.FLAN || FlanCompat.canBreak(owner, blockpos))) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
        }
        this.getToBlow().addAll((Collection)set);
        float diameter = this.field_9190 * 2.0f;
        int k1 = class_3532.method_15357((double)(this.field_9195 - (double)diameter - 1.0));
        int l1 = class_3532.method_15357((double)(this.field_9195 + (double)diameter + 1.0));
        int i2 = class_3532.method_15357((double)(this.field_9192 - (double)diameter - 1.0));
        int i1 = class_3532.method_15357((double)(this.field_9192 + (double)diameter + 1.0));
        int j2 = class_3532.method_15357((double)(this.field_9189 - (double)diameter - 1.0));
        int j1 = class_3532.method_15357((double)(this.field_9189 + (double)diameter + 1.0));
        List list = this.field_9187.method_8335(this.method_46406(), new class_238((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeHelper.onExplosionDetonate((class_1937)this.field_9187, (class_1927)this, (List)list, (double)diameter);
        class_243 vector3d = new class_243(this.field_9195, this.field_9192, this.field_9189);
        for (class_1297 entity : list) {
            double dz;
            double dy;
            double dx;
            double distFromCenterSqr;
            double distSq;
            double normalizedDist;
            if (entity.method_5659() || owner != null && CompatHandler.FLAN && !FlanCompat.canAttack(owner, entity) || !((normalizedDist = (double)(class_3532.method_15355((float)((float)(distSq = entity.method_5707(vector3d)))) / diameter)) <= 1.0) || (distFromCenterSqr = (double)class_3532.method_15355((float)((float)((dx = entity.method_23317() - this.field_9195) * dx + (dy = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.field_9192) * dy + (dz = entity.method_23321() - this.field_9189) * dz)))) == 0.0) continue;
            dx /= distFromCenterSqr;
            dy /= distFromCenterSqr;
            dz /= distFromCenterSqr;
            double d14 = BombExplosion.method_17752((class_243)vector3d, (class_1297)entity);
            double d10 = (1.0 - normalizedDist) * d14;
            entity.method_5643(this.method_8349(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)diameter + 1.0)));
            double d11 = d10;
            boolean isPlayer = entity instanceof class_1657;
            class_1657 playerEntity = null;
            if (!(!isPlayer || (playerEntity = (class_1657)entity).method_7325() || playerEntity.method_7337() && playerEntity.method_31549().field_7479)) {
                this.method_8351().put(playerEntity, new class_243(dx * d10, dy * d10, dz * d10));
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (!isPlayer || !playerEntity.method_7325() && !playerEntity.method_7337()) {
                    this.bombType.applyStatusEffects(livingEntity, distSq);
                }
                if (entity instanceof class_1548) {
                    class_1548 creeper = (class_1548)entity;
                    creeper.method_7004();
                }
                d11 = class_1900.method_8237((class_1309)((class_1309)entity), (double)d10);
            }
            entity.method_18799(entity.method_18798().method_1031(dx * d11, dy * d11, dz * d11));
        }
        this.bombType.afterExploded(this, this.field_9187);
    }
}

