/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.BlackboardManager;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.SlimedRenderTypes;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import net.minecraft.class_799;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesGenerator
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesGenerator INSTANCE = new ClientDynamicResourcesGenerator();

    public ClientDynamicResourcesGenerator() {
        super(new DynamicTexturePack(Supplementaries.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        SlimedRenderTypes.clear();
        BlackboardManager.closeAll();
        executor.accept((manager, sink) -> {
            GlobeManager.refreshColorsAndTextures(manager);
            ColorHelper.refreshBubbleColors(manager);
            this.addEndermanHead(manager, sink);
            this.addRopeArrowModel(manager, sink);
            this.addTatteredBook(manager, sink);
            this.addSignPostAssets(manager, sink);
        });
    }

    private void addSignPostAssets(class_3300 manager, ResourceSink sink) {
        Respriter respriter;
        TextureImage template;
        StaticResource spItemModel = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Supplementaries.res("sign_post_oak")));
        StaticResource spBlockModel = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Supplementaries.res("sign_posts/sign_post_oak")));
        ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((class_1792)sign).method_12832();
            sink.addSimilarJsonResource(manager, spItemModel, "sign_post_oak", id);
            sink.addSimilarJsonResource(manager, spBlockModel, "sign_post_oak", id);
        });
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/sign_posts/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
                    class_2960 textureRes = Supplementaries.res("item/sign_posts/" + Utils.getID((class_1792)sign).method_12832());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    class_1792 signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)manager, (class_1792)signItem));
                             TextureImage signMask = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/sign_posts/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign, (TextureImage)signMask);
                            try (TextureImage newImage = respriter.recolor(targetPalette);){
                                try (TextureImage scribbles = ClientDynamicResourcesGenerator.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("item/sign_posts/sign_scribbles_mask"), Supplementaries.res("item/sign_posts/scribbles_template"));){
                                    TextureOps.applyOverlay((TextureImage)newImage, (TextureImage[])new TextureImage[]{scribbles});
                                }
                                catch (Exception ex) {
                                    this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                                }
                                sink.addTexture(textureRes, newImage);
                            }
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Could not find sign texture for wood explosionType {}. Using plank texture : {}", wood, (Object)ex);
                        }
                    } else {
                        try (TextureImage plankPalette = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            try (TextureImage newImage = respriter.recolor(targetPalette);){
                                sink.addTexture(textureRes, newImage);
                            }
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("block/sign_posts/sign_post_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
                    class_2960 textureRes = Supplementaries.res("block/sign_posts/" + Utils.getID((class_1792)sign).method_12832());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        try (TextureImage newImage = respriter.recolor(palette);){
                            sink.addTexture(textureRes, newImage);
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
    }

    private void addTatteredBook(class_3300 manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            sink.appendModelOverride(manager, new class_2960("written_book"), e -> e.add(new class_799(new class_2960("item/written_book_tattered"), List.of(new class_799.class_5826(Supplementaries.res("antique_ink"), 1.0f)))));
            sink.appendModelOverride(manager, new class_2960("filled_map"), e -> e.add(new class_799(new class_2960("item/antique_map"), List.of(new class_799.class_5826(Supplementaries.res("antique_ink"), 1.0f)))));
        }
    }

    private void addRopeArrowModel(class_3300 manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            sink.appendModelOverride(manager, new class_2960("crossbow"), e -> e.add(new class_799(new class_2960("item/crossbow_rope_arrow"), List.of(new class_799.class_5826(new class_2960("charged"), 1.0f), new class_799.class_5826(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
    }

    private void addEndermanHead(class_3300 manager, ResourceSink sink) {
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue() && ClientConfigs.Tweaks.ENDERMAN_HEAD_VANILLA.get().booleanValue()) {
            try (TextureImage text = TextureImage.open((class_3300)manager, (class_2960)new class_2960("entity/enderman/enderman"));
                 TextureImage eyeText = TextureImage.open((class_3300)manager, (class_2960)new class_2960("entity/enderman/enderman_eyes"));){
                sink.addTexture(Supplementaries.res("entity/enderman_head"), text, false);
                sink.addTexture(Supplementaries.res("entity/enderman_head_eyes"), eyeText, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static TextureImage recolorFromVanilla(class_3300 manager, TextureImage vanillaTexture, class_2960 vanillaMask, class_2960 templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((class_3300)manager, (class_2960)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((class_3300)manager, (class_2960)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        String bambooSpikes;
        ModRegistry.SIGN_POST_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.sign_post", (BlockType)type, (class_1792)item));
        if (MiscUtils.FESTIVITY.isAprilsFool()) {
            lang.addEntry("block.suppsquared.metal_frame", "Galvanized Square Steel Frame");
            lang.addEntry("block.suppsquared.metal_brace", "Galvanized Square Steel Brace");
            lang.addEntry("block.suppsquared.metal_cross_brace", "Galvanized Square Steel Cross Brace");
        }
        if ((bambooSpikes = lang.getEntry("item.supplementaries.bamboo_spikes_tipped.effect")) == null) {
            return;
        }
        for (class_1842 p : class_7923.field_41179) {
            String key = p.method_8051("item.supplementaries.bamboo_spikes_tipped.effect.");
            String arrowName = lang.getEntry(p.method_8051("item.minecraft.tipped_arrow.effect."));
            if (arrowName == null) {
                lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)Utils.getID((class_1842)p).method_12832())));
                continue;
            }
            lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)arrowName.toLowerCase(Locale.ROOT).replace("arrow of ", ""))));
        }
    }
}

