/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.pneumono.gravestones.Gravestones;

public class DeathArgumentType
implements ArgumentType<String> {
    protected static final DynamicCommandExceptionType COULD_NOT_READ = new DynamicCommandExceptionType(name -> class_2561.method_43470((String)("Could not read death file " + String.valueOf(name))));

    public String parse(StringReader reader) {
        int i = reader.getCursor();
        while (reader.canRead() && DeathArgumentType.isCharValid(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(i, reader.getCursor());
    }

    public static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '/' || c == '.' || c == '-';
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (!(object instanceof class_2168)) {
            Object object2 = context.getSource();
            if (object2 instanceof class_2172) {
                class_2172 commandSource = (class_2172)object2;
                return commandSource.method_9261(context);
            }
            return Suggestions.empty();
        }
        class_2168 serverCommandSource = (class_2168)object;
        File rootFile = Gravestones.GRAVESTONES_ROOT.apply(serverCommandSource.method_9211());
        File[] playerFiles = rootFile.listFiles();
        String[] playerFileStrings = rootFile.list();
        if (playerFiles == null || playerFileStrings == null) {
            return Suggestions.empty();
        }
        ArrayList<String> deathFiles = new ArrayList<String>();
        for (int i = 0; i < playerFiles.length; ++i) {
            File playerFile = playerFiles[i];
            String[] playerDeaths = playerFile.list();
            if (playerDeaths == null) continue;
            int finalI = i;
            deathFiles.addAll(Arrays.stream(playerDeaths).map(file -> playerFileStrings[finalI] + "/" + file).toList());
        }
        return class_2172.method_9265(deathFiles, (SuggestionsBuilder)builder);
    }

    public static DeathArgumentType death() {
        return new DeathArgumentType();
    }

    public static class_2487 getDeath(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_2487 nbt;
        File deathsFile = Gravestones.GRAVESTONES_ROOT.apply(((class_2168)context.getSource()).method_9211());
        String file = (String)context.getArgument(name, String.class);
        File deathFile = new File(deathsFile, file);
        try {
            nbt = class_2507.method_30613((File)deathFile);
        }
        catch (IOException e) {
            throw COULD_NOT_READ.create((Object)file);
        }
        if (nbt == null) {
            throw COULD_NOT_READ.create((Object)file);
        }
        return nbt;
    }
}

