/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import org.betterx.bclib.BCLibPatch;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.Chunker;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloClient;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloServer;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.RequestFiles;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.SendFiles;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLibNetherBiomeSource;
import org.betterx.bclib.api.v2.generator.GeneratorOptions;
import org.betterx.bclib.api.v2.levelgen.LevelGenEvents;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructurePoolElementTypes;
import org.betterx.bclib.api.v2.levelgen.structures.TemplatePiece;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.poi.PoiManager;
import org.betterx.bclib.api.v3.levelgen.features.blockpredicates.BlockPredicates;
import org.betterx.bclib.api.v3.levelgen.features.placement.PlacementModifiers;
import org.betterx.bclib.api.v3.tag.BCLBlockTags;
import org.betterx.bclib.blocks.signs.BaseHangingSignBlock;
import org.betterx.bclib.blocks.signs.BaseSignBlock;
import org.betterx.bclib.commands.CommandRegistry;
import org.betterx.bclib.commands.arguments.BCLibArguments;
import org.betterx.bclib.complexmaterials.BCLWoodTypeWrapper;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.networking.VersionChecker;
import org.betterx.bclib.recipes.AlloyingRecipe;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.betterx.bclib.recipes.CraftingRecipes;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.bclib.registry.BaseRegistry;
import org.betterx.bclib.registry.BlockRegistry;
import org.betterx.bclib.registry.PresetsRegistry;
import org.betterx.datagen.bclib.tests.TestStructure;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.util.Logger;
import org.betterx.worlds.together.world.WorldConfig;

public class BCLib
implements ModInitializer {
    public static final String MOD_ID = "bclib";
    public static final Logger LOGGER = new Logger("bclib");
    public static final boolean RUNS_NULLSCAPE = FabricLoader.getInstance().getModContainer("nullscape").isPresent();
    public static final boolean ADD_TEST_DATA = false;
    public static BCLWoodTypeWrapper TEST_WOOD;
    public static BaseSignBlock TEST_SIGN;
    public static BaseHangingSignBlock TEST_HANGING_SIGN;

    private void onDatagen() {
    }

    public void onInitialize() {
        WorldsTogether.onInitialize();
        BCLibArguments.register();
        PresetsRegistry.register();
        LevelGenEvents.register();
        BlockPredicates.ensureStaticInitialization();
        BCLBiomeRegistry.register();
        BaseRegistry.register();
        GeneratorOptions.init();
        BaseBlockEntities.register();
        BCLibEndBiomeSource.register();
        BCLibNetherBiomeSource.register();
        CraftingRecipes.init();
        BCLStructurePoolElementTypes.ensureStaticallyLoaded();
        WorldConfig.registerModCache(MOD_ID);
        DataExchangeAPI.registerMod(MOD_ID);
        AnvilRecipe.register();
        AlloyingRecipe.register();
        Conditions.registerAll();
        CommandRegistry.register();
        BCLBlockTags.ensureStaticallyLoaded();
        PoiManager.registerAll();
        if (BCLib.isDevEnvironment()) {
            TestStructure.registerBase();
        }
        DataExchangeAPI.registerDescriptors(List.of(HelloClient.DESCRIPTOR, HelloServer.DESCRIPTOR, RequestFiles.DESCRIPTOR, SendFiles.DESCRIPTOR, Chunker.DESCRIPTOR));
        BCLibPatch.register();
        TemplatePiece.ensureStaticInitialization();
        PlacementModifiers.ensureStaticInitialization();
        Configs.save();
        WorldsTogether.FORCE_SERVER_TO_BETTERX_PRESET = Configs.SERVER_CONFIG.forceBetterXPreset();
        VersionChecker.registerMod(MOD_ID);
        if (BCLib.isDatagen()) {
            this.onDatagen();
        }
    }

    public static boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean isDatagen() {
        return System.getProperty("fabric-api.datagen") != null;
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static class_2960 makeID(String path) {
        return new class_2960(MOD_ID, path);
    }

    private static void testObjects() {
        BlockRegistry bockReg = new BlockRegistry(new PathConfig(MOD_ID, "test"));
        bockReg.register(BCLib.makeID("test_sign"), (class_2248)TEST_SIGN);
        bockReg.registerBlockOnly(BCLib.makeID("test_wall_sign"), (class_2248)TEST_SIGN.getWallSignBlock());
        bockReg.register(BCLib.makeID("test_hanging_sign"), (class_2248)TEST_HANGING_SIGN);
        bockReg.registerBlockOnly(BCLib.makeID("test_wall_hanging_sign"), (class_2248)TEST_HANGING_SIGN.getWallSignBlock());
    }

    private static /* synthetic */ void lambda$static$2(class_1761.class_8128 itemDisplayParameters, class_1761.class_7704 output) {
        List<class_1799> list = List.of(TEST_SIGN.method_8389(), TEST_HANGING_SIGN.method_8389()).stream().map(b -> new class_1799((class_1935)b, 1)).toList();
        output.method_45423(list);
    }

    private static /* synthetic */ class_1799 lambda$static$0() {
        return new class_1799((class_1935)class_1802.field_8077);
    }

    static {
        TEST_SIGN = null;
        TEST_HANGING_SIGN = null;
    }
}

