/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1086;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_8567;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBarsBlock
extends class_2389
implements BlockModelProvider,
RenderLayerProvider,
BehaviourMetal {
    public BaseBarsBlock(class_2248 source) {
        this(class_4970.class_2251.method_9630((class_4970)source).method_9629(5.0f, 6.0f).method_22488());
    }

    public BaseBarsBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        return Collections.singletonList(new class_1799((class_1935)this));
    }

    public Optional<String> getModelString(String block) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)this);
        if (block.contains("item")) {
            return PatternsHelper.createJson(BasePatterns.ITEM_BLOCK, blockId);
        }
        if (block.contains("post")) {
            return PatternsHelper.createJson(BasePatterns.BLOCK_BARS_POST, blockId);
        }
        return PatternsHelper.createJson(BasePatterns.BLOCK_BARS_SIDE, blockId);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 resourceLocation) {
        return ModelsHelper.createBlockItem(resourceLocation);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 blockId, class_2680 blockState) {
        class_2960 thisId = class_7923.field_41175.method_10221((Object)this);
        String path = blockId.method_12832();
        Optional<String> pattern = Optional.empty();
        if (path.endsWith("_post")) {
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_BARS_POST, thisId);
        }
        if (path.endsWith("_side")) {
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_BARS_SIDE, thisId);
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        class_2960 postId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832() + "_post");
        class_2960 sideId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832() + "_side");
        this.registerBlockModel(postId, postId, blockState, modelCache);
        this.registerBlockModel(sideId, sideId, blockState, modelCache);
        ModelsHelper.MultiPartBuilder builder = ModelsHelper.MultiPartBuilder.create((class_2689<class_2248, class_2680>)this.field_10647);
        builder.part(postId).setCondition(state -> (Boolean)state.method_11654((class_2769)field_10905) == false && (Boolean)state.method_11654((class_2769)field_10907) == false && (Boolean)state.method_11654((class_2769)field_10904) == false && (Boolean)state.method_11654((class_2769)field_10903) == false).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.method_11654((class_2769)field_10905)).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.method_11654((class_2769)field_10907)).setTransformation(class_1086.field_5366.method_3509()).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.method_11654((class_2769)field_10904)).setTransformation(class_1086.field_5355.method_3509()).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.method_11654((class_2769)field_10903)).setTransformation(class_1086.field_5347.method_3509()).setUVLock(true).add();
        return builder.build();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        if (direction.method_10166().method_10178() && stateFrom.method_26204() == this && !stateFrom.equals(state)) {
            return false;
        }
        return super.method_9522(state, stateFrom, direction);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public static class Metal
    extends BaseBarsBlock
    implements BehaviourMetal {
        public Metal(class_2248 source) {
            super(source);
        }

        public Metal(class_4970.class_2251 properties) {
            super(properties);
        }
    }
}

